<script language="javascript" type="text/javascript">
//<![CDATA[
	if (typeof lang == 'undefined') { lang = {}; }
	lang.ConfirmCancel = "{% lang 'ConfirmCancel' %}";
//]]>
</script>
<div class="row DashboardGettingStarted" style="{{ HideGettingStarted|safe }}">
	<div class="col-lg-12">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'GettingStartedIntro' %}</h3> 
				<a href="#" class="ToggleLink GettingStartedToggleLink" style="{{ HideToggleGettingStartedAtGlance|safe }}"><i class="fa fa-arrow-right fa-1x"></i> <strong>Aps Concludo CLique Aqui.</strong></a>
			</div> 
			<div class="panel-body">
		   		<div class="row">
		  			{{ GettingStarted|safe }}
		   		</div>
		   	</div>
		</div>
	</div>
</div>
<div class="row DashboardCommonTasks" style="{{ HideOverview|safe }}" >
	<div class="col-lg-8">
		<div class="sture" style="{{ HideAtAGlance|safe }}">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">N&uacute;meros da Loja</h3> 
				</div> 

				<div class="panel-body">
			   		<div class="row">
			   			{{ AtGlanceItems|safe }}
			   		</div>
			   	</div>
			</div>
	   	</div>

		<div class="panel panel-default DashboardPanelRecentOrders" style="{{ HideRecentOrders|safe }}">
			<div class="panel-heading DashboardPanelContent"> 
				<h3 class="panel-title DashboardFilterOptions">
					<span class="hidden-xs">Pedidos</span>
					<div class="btn-group pull-right DashboardRecentOrdersToggle">
						<button type="button" class="btn btn-default waves-effect btn-sm {{ RecentOrdersActiveRecentClass|safe }}" rel="status=recent">Recentes</button>
						<button type="button" class="btn btn-default waves-effect btn-sm {{ RecentOrdersActivePendingClass|safe }}" rel="status=pending">Pendentes</button>
						<button type="button" class="btn btn-default waves-effect btn-sm {{ RecentOrdersActiveCompletedClass|safe }}" rel="status=completed">Concludos</button>
						<button type="button" class="btn btn-default waves-effect btn-sm hidden-xs {{ RecentOrdersActiveRefundedClass|safe }}" rel="status=refunded">Reembolsados</button>
						<a href="index.php?ToDo=viewOrders" class="btn btn-default waves-effect btn-sm">{% lang 'ViewAllOrders' %}</a>
					</div>
					<br class="Clear" />
				</h3> 
			</div> 

			<div class="panel-body">
				<ul class="DashboardRecentOrderList">
					{{ RecentOrdersList|safe }}
				</ul>
			</div> 
		</div>
    </div>

    <div class="col-lg-4">
    	<div class="panel panel-default" style="{{ HideNotificationsList|safe }}">
	    	<div class="panel-heading DashboardPanelContent" > 
	    		<h3 class="panel-title"><span class="icon"><i class="fa fa-tasks"></i></span> Notificaes</h3>
			</div>
			<div class="panel-body">
					{{ NotificationsList|safe }}
					
				</div>
		</div>
    	<div class="row DashboardPanelPerformanceIndicators" id="DashboardPanelPerformanceIndicators">
			<div class="panel panel-default" style="{{ HideDashboardPerformanceIndcators|safe }}">
				<div class="panel-heading DashboardPanelContent"> 
					<h3 class="panel-title DashboardPerformanceIndicatorsPeriodButton">
						<span class="hidden-xs">Vis&atilde;o Geral</span>
						<div class="pull-right Buttons btn-group">
							<button type="button" class="btn btn-default waves-effect btn-sm {{ PerformanceIndicatorsActiveDay|safe }}" rel="period=day">{% lang 'Day' %}</button>
							<button type="button" class="btn btn-default waves-effect btn-sm {{ PerformanceIndicatorsActiveWeek|safe }}" rel="period=week">{% lang 'Week' %}</button>
							<button type="button" class="btn btn-default waves-effect btn-sm {{ PerformanceIndicatorsActiveMonth|safe }}" rel="period=month">{% lang 'Month' %}</button>
							<button type="button" class="btn btn-default waves-effect btn-sm {{ PerformanceIndicatorsActiveYear|safe }}" rel="period=year">{% lang 'Year' %}</button>
						</div>
						<br class="Clear" />
					</h3> 
				</div> 
				<div class="panel-body">
					<div id="DashboardPerformanceIndicators">
						{{ PerformanceIndicatorsTable|safe }}
					</div>
				</div>
			</div>
		</div>
    	<div class="panel panel-default DashboardPanelOrderBreakdown" style="{{ HideDashboardBreakdownGraph|safe }}">
			<div class="panel-heading DashboardPanelContent"> 
				<h3 class="panel-title DashboardFilterOptions">
					Pedidos <small>({% lang 'Last7Days' %})</small>
					<div class="btn-group pull-right DashboardRecentOrdersToggle">
						<span class="DashboardOrderBreakdownAllStatsButton">
							<a href="index.php?ToDo=viewStats" class="btn btn-default">{% lang 'ViewAllStatistics' %}</a>
						</span>
					</div>
				</h3>
			</div>

			<div class="DashboardPanelContent panel-body">
				<div class="PanelSpace">
					<ul class="OrderBreakdownChart">
						{{ DashboardBreakdownGraph|safe }}
					</ul>

					<div class="OrderBreakdownChartKey">
						<div class="First">{{ GraphSeriesLabel0|safe }}</div>
						<div>{{ GraphSeriesLabel1|safe }}</div>
						<div>{{ GraphSeriesLabel2|safe }}</div>
						<div>{{ GraphSeriesLabel3|safe }}</div>
						<div class="Last">{{ GraphSeriesLabel4|safe }}</div>
					</div>
				</div>
			</div>
		</div>
    </div>
</div>

<script language="javascript" src="script/category.selector.js?{{ JSCacheToken }}"></script>