<form action="index.php?ToDo={{ FormAction|safe }}" id="frmBanner" method="post" class="form-horizontal">
	<input type="hidden" name="bannerId" value="{{ BannerId|safe }}">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{% lang 'BannerIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
	<br />

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'NewBannerDetails' %}</h3> 
		</div> 

		<div class="panel-body">
			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'BannerName' %}</label>
				<div class="col-md-10">
					<input type="text" id="bannername" name="bannername" class="form-control" value="{{ BannerName|safe }}">
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'BannerContent' %}</label>
				<div class="col-md-10">
					{{ WYSIWYG|safe }}
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'BannerPage' %}</label>
				<div class="col-md-10">
					<div class="radio radio-primary">
						<input type="radio" name="bannerpage" id="bannerpage1" value="home_page" {{ IsHomePage|safe }} />
						<label for="bannerpage1">{% lang 'BannerHomePage' %}</label>
		            </div>

					<div class="radio radio-primary">
						<input type="radio" name="bannerpage" id="bannerpage2" value="category_page" {{ IsCategory|safe }} />
						<label for="bannerpage2">{% lang 'BannerCategoryPage' %}</label>
						<br />
						
						<div id="page_category">
							<select name="bannercat" id="bannercat" class="Field200">
								<option value="">{% lang 'ChooseACategory' %}</option>
								{{ CategoryOptions|safe }}
							</select>
						</div>
		            </div>

					<div class="radio radio-primary">
						<input type="radio" name="bannerpage" id="bannerpage3" value="brand_page" {{ IsBrand|safe }} />
						<label for="bannerpage3">{% lang 'BannerBrandPage' %}</label>
						<br />

						<div id="page_brand">
							<select name="bannerbrand" id="bannerbrand" class="Field200">
								<option value="">{% lang 'ChooseABrand' %}</option>
								{{ BrandOptions|safe }}
							</select>
						</div>
		            </div>

					<div class="radio radio-primary">
						<input type="radio" name="bannerpage" id="bannerpage4" value="search_page" {{ IsSearch|safe }} />
						<label for="bannerpage4">{% lang 'BannerSearchPage' %}</label><br />
		            </div>
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'BannerDateRange' %}</label>
				<div class="col-md-10">
					<div class="radio radio-primary">
						<input type="radio" id="bannerdate1" name="bannerdate" value="always" {{ IsAlwaysDate|safe }}>
						<label for="bannerdate1">{% lang 'BannerDisplayAlways' %}</label>
		            </div>

					<div class="radio radio-primary">
						<input type="radio" id="bannerdate2" name="bannerdate" value="custom" {{ IsCustomDate|safe }}>
						<label for="bannerdate2">{% lang 'BannerDisplayBetween' %}</label>
						<br />
						
						<div id="trCustomDate" style="display:none">
							<table border="0" style="width: 100%">
								<tr>
									<td style="width: 50px">
										{% lang 'BannerFrom' %}:
									</td>
									<td>
										<select name="from_day" id="from_day" class="form-control" style="width: auto; display: inline;">
											{{ FromDayOptions|safe }}
										</select>
										<select name="from_month" id="from_month" class="form-control" style="width: auto; display: inline;">
											{{ FromMonthOptions|safe }}
										</select>
										<select name="from_year" id="from_year" class="form-control" style="width: auto; display: inline;">
											{{ FromYearOptions|safe }}
										</select>
									</td>
								</tr>
								<tr>
									<td>
										{% lang 'BannerTo' %}:
									</td>
									<td>
										<select name="to_day" id="to_day" class="form-control" style="width: auto; display: inline;">
											{{ ToDayOptions|safe }}
										</select>
										<select name="to_month" id="to_month" class="form-control" style="width: auto; display: inline;">
											{{ ToMonthOptions|safe }}
										</select>
										<select name="to_year" id="to_year" class="form-control" style="width: auto; display: inline;">
											{{ ToYearOptions|safe }}
										</select>
									</td>
								</tr>
							</table>
						</div>
		            </div>
		        </div>
		    </div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'Visible' %}</label>
				<div class="col-md-10">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" id="bannerstatus" name="bannerstatus" value="ON" {{ Visible|safe }}>
						<label for="bannerstatus">{% lang 'YesBannerVisible' %}</label>
		            </div>
		        </div>
		    </div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'BannerLocation' %}</label>
				<div class="col-md-10">
					<select name="bannerloc" id="bannerloc" class="form-control">
						<option value="">{% lang 'ChooseALocation' %}</option>
						<option value="top" {{ IsLocationTop|safe }}>{% lang 'TopOfPage' %}</option>
						<option value="meio" {{ IsLocationMeio|safe }}>Meio da Pgina</option>
						<option value="bottom" {{ IsLocationBottom|safe }}>{% lang 'BottomOfPage' %}</option>
					</select>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
</form>

<script type="text/javascript" src="../javascript/jquery/plugins/jstree/jquery.jstree.js?{{ JSCacheToken }}"></script>
<script type="text/javascript">
	//<![CDATA[
		var selected_page = '';

		function ConfirmCancel() {
			if(confirm("{% lang 'ConfirmCancelBanner' %}"))
				document.location.href = "index.php?ToDo=viewBanners";
		}

		function CheckBannerForm() {
			return false;
		}

		function ToggleDate(DateType) {
			if(DateType == "custom") {
				$("#trCustomDate").css("display", "");
			}
			else {
				$("#trCustomDate").css("display", "none");
			}
		}

		// Hide the location options on page load
		$(document).ready(function() {
			$('#page_category').css('display', 'none');
			$('#page_brand').css('display', 'none');

			// Do we need to show the custom date range?
			{{ ShowCustomDate|safe }}

			// Do we need to show the category dropdown?
			{{ ShowCategory|safe }}

			{{ category.categoryPicker("bannerCategories", CategoryOptions, false, 'category-' ~ bannerCategory) }}

			$("#bannerCategories").bind("select_node.jstree", function(event, data) {
				var categoryId = data.rslt.obj.data("id");
				$("#bannercat").val(categoryId);
			});

			// Do we need to show the brand dropdown?
			{{ ShowBrand|safe }}

			{{ SelectedJS|safe }}
		});

		$('#bannerpage1').click(function() {
			$('#page_category').css('display', 'none');
			$('#page_brand').css('display', 'none');
		});

		$('#bannerpage2').click(function() {
			$('#page_category').css('display', '');
			$('#bannercat').focus();
			$('#page_brand').css('display', 'none');
		});

		$('#bannerpage3').click(function() {
			$('#page_brand').css('display', '');
			$('#bannerbrand').focus();
			$('#page_category').css('display', 'none');
		});

		$('#bannerpage4').click(function() {
			$('#page_category').css('display', 'none');
			$('#page_brand').css('display', 'none');
		});

		$('#bannerdate1').click(function() {
			$('#trCustomDate').css('display', 'none');
		});

		$('#bannerdate2').click(function() {
			$('#trCustomDate').css('display', '');
		});

		// Save the page type when it's changed
		$('#bannerpage1').click(function() {
			selected_page = $('#bannerpage1').val();
		});

		$('#bannerpage2').click(function() {
			selected_page = $('#bannerpage2').val();
		});

		$('#bannerpage3').click(function() {
			selected_page = $('#bannerpage3').val();
		});

		$('#bannerpage4').click(function() {
			selected_page = $('#bannerpage4').val();
		});

		// Check the form when it's submitted
		$('#frmBanner').submit(function() {
			if($('#bannername').val() == '') {
				alert('{% lang 'EnterBannerName' %}');
				$('#bannername').focus();
				$('#bannername').select();
				return false;
			}

			switch(selected_page) {
				case 'category_page': {
					if($('#bannercat').val() == '') {
						alert('{% lang 'BannerChooseCat' %}');
						$('#bannercat').focus();
						return false;
					}
					break;
				}
				case 'brand_page': {
					if($('#bannerbrand :selected').val() == '') {
						alert('{% lang 'BannerChooseBrand' %}');
						$('#bannerbrand').focus();
						return false;
					}
					break;
				}
				case '': {
					alert('{% lang 'ChooseBannerShow' %}');
					return false;

				}
			}

			if($('#bannerloc :selected').val() == '') {
				alert('{% lang 'ChooseBannerLocation' %}');
				$('#bannerloc').focus();
				return false;
			}
		});

	//]]></script>
