{% import "macros/forms.tpl" as formBuilder %}
<div id="content">
	<h4 class="page-title">{{ lang.EditRobotsTxtFile }}</h4>
	<p class="intro">{{ lang.RobotsIntro }}</p>
	{{ flashMessages|safe }}
	<form action="index.php?ToDo=saveRobotsTxt" method="post" id="robotsForm">
		<p class="intro">
			<input type="submit" value="{{ lang.Save }}" class="saveButton btn btn-primary m-b-5" />
			<input type="submit" value="{{ lang.RobotsRevertButton }}" id="robotstxtRevertButton" name="robotstxtRevertButton" class="btn btn-success m-b-5" />
		</p>
		{{ formBuilder.startForm }}
			{{ formBuilder.heading(lang.RobotsTxt) }}
			{{ formBuilder.startRow }}
			<textarea class="form-control" rows="20" name="robotstxtFileContent">{{ fileContent|safe }}</textarea>
			{{ formBuilder.endRow }}
		{{ formBuilder.endForm }}
	</form>
</div>
<script type="text/javascript" charset="utf-8">
	$('#robotstxtRevertButton').bind('click', function () {
		var r = confirm("{{ lang.RobotsRevertPrompt }}");
		return r;
	});

	$('#robotstxtCancelLink').bind('click', function () {
		var r = confirm( "{{ lang.RobotsCancelPrompt }}");
		if (r == true) {
			window.location = 'index.php?ToDo=ViewEditRobotsTxt';
		}

		return false;
	});
</script>
