{% import "macros/util.tpl" as util %}
<table class="GridPanel SortableGrid AutoExpand" cellspacing="0" cellpadding="0" border="0" id="IndexGrid" style="width:100%;">
	<tr>
		<td colspan="12" class="text-center">
			<nav aria-label="Page navigation example">
				<ul class="pagination LetterSort">
					{% for displayLetter, letter in letters %}
					<li class="page-item"><a class="SortLink page-link" class="SortLink {% if letter == activeLetter %}ActiveLetter{% endif %}" href="index.php?ToDo=viewProducts&amp;{{ letterURL|http_build_query }}&amp;letter={{ letter }}">{{ displayLetter }}</a></li>
					{% endfor %}
					<li class="page-item"><a class="SortLink" href="index.php?ToDo=viewProducts&amp;{{ letterURL|http_build_query }}">{% lang 'Clear' %}</a></li>
				</ul>
			</nav>
		</td>
	</tr>
	
	<tr>
		<td colspan="12" class="text-center">
			{{ util.paging(numProducts, perPage, currentPage, pageURL, true) }}
		</td>
	</tr>
</table>
<div class="panel panel-default">
	<div class="panel-body" style="padding: 0">
	<div class="table-responsive">
		<table class="GridPanel SortableGrid AutoExpand table table-striped" id="IndexGrid" style="margin: 0">
			<thead>
				<tr>
					<th><input type="checkbox" onclick="ToggleDeleteBoxes(this.checked)"></th>
					<th></th>
					<th style="display: {{ HideInventoryOptions|safe }}"></th>
					<th class="ImageField">{% lang 'Image' %}</th>
					<th>{% lang 'ProductSKU' %} &nbsp;{{ SortLinksCode|safe }}</th>
					<th style="width: 95px; display: {{ HideInventoryOptions|safe }}">
						Estoque &nbsp;
						{{ SortLinksStock|safe }}
					</th>
					<th colspan="{{ ProductNameSpan|safe }}">
						{% lang 'ProductName' %} &nbsp;
						{{ SortLinksName|safe }}
					</th>
					<th width="70" style="text-align: right;">
						{% lang 'ProductPrice' %} &nbsp;
						{{ SortLinksPrice|safe }}
					</th>
					<th width="85" style="text-align: right;">
						{% lang 'Status' %} &nbsp;
						{{ SortLinksStatus|safe }}
					</th>
					<th width="70" nowrap="nowrap">
						{% lang 'ProductVisible' %} &nbsp;
						{{ SortLinksVisible|safe }}
					</th>
					<th width="80" nowrap="nowrap">
						Destaque &nbsp;
						{{ SortLinksFeatured|safe }}
					</th>
					<th style="width:70px;">
						{% lang 'Action' %}
					</th>
				</tr>
			</thead>
			
			<tbody>
				{{ ProductGrid|safe }}
			</tbody>
			
			<tr align="right">
				<td colspan="12" class="text-center">
					{{ util.paging(numProducts, perPage, currentPage, pageURL, true) }}
				</td>
			</tr>
		</table>
	</div>
	</div>
</div>