<script type="text/javascript" src="script/page.js?{{ JSCacheToken }}"></script>
<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onSubmit="return ValidateForm(CheckPageForm);" id="frmNews" method="post">
	<input type="hidden" name="pageId" id="pageId" value="{{ PageId|safe }}">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{% lang 'PageIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" />
			<input type="submit" name="addAnother2" value="{{ SaveAndAddAnother|safe }}" class="btn btn-primary" />
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel();" />
			<input id="currentTab" name="currentTab" value="details" type="hidden">
		</div>
	</div>
	<br />

	<div id="div0">
		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">Configuraes da Pgina</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">Tipo de Pgina</label>
					<div class="col-md-10">
						<div class="radio radio-primary">
							<input onclick="SwitchType(0)" type="radio" id="pagetype_0" name="pagetype" value="0" {{ SelType0|safe }}>
							<label for="pagetype_0">{% lang 'NormalPage' %}</label>
		                </div>

						<div class="radio radio-primary">
							<input onclick="SwitchType(1)" type="radio" id="pagetype_1" name="pagetype" value="1" {{ SelType1|safe }}>
							<label for="pagetype_1">{% lang 'ExternalLink' %}</label>
		                </div>

						<div class="radio radio-primary">
							<input onclick="SwitchType(2)" type="radio" id="pagetype_2" name="pagetype" value="2" {{ SelType2|safe }}>
							<label for="pagetype_2">{% lang 'RSSPage' %}</label>
		                </div>

						<div class="radio radio-primary">
							<input onclick="SwitchType(3)" type="radio" id="pagetype_3" name="pagetype" value="3" {{ SelType3|safe }}>
							<label for="pagetype_3">{% lang 'ContactPage' %}</label>
		                </div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">Detalhes da Pgina</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'PageTitle' %}</label>
					<div class="col-md-10">
						<input type="text" id="pagetitle" name="pagetitle" class="form-control" value="{{ PageTitle|safe }}">
					</div>
				</div>

				<div class="form-group HideIfNotPage PageContent">
					<label class="col-md-2 control-label">{% lang 'PageContent' %}</label>
					<div class="col-md-10">
						{{ WYSIWYG|safe }}
					</div>
				</div>

				<div class="form-group HideIfPage">
					<label class="col-md-2 control-label">{% lang 'Link' %}</label>
					<div class="col-md-10">
						<input type="text" id="pagelink" name="pagelink" class="form-control" value="{{ PageLink|safe }}">
					</div>
				</div>

				<div class="form-group HideIfRSS">
					<label class="col-md-2 control-label">{% lang 'RSSFeed' %}</label>
					<div class="col-md-10">
						<input type="text" id="pagefeed" name="pagefeed" class="form-control" value="{{ PageFeed|safe }}">
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default HideIfContact form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">Detalhes da Pgina de Contato</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">Tipo de Pgina</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield1" name="contactfields[]" value="ON" checked="checked" disabled="disabled">
							<label for="contactfield1">{% lang 'ContactEmail' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield2" name="contactfields[]" value="ON" checked="checked" disabled="disabled">
							<label for="contactfield2">{% lang 'ContactQuestion' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield3" name="contactfields[fullname]" value="fullname" {{ IsContactFullName|safe }}>
							<label for="contactfield3">{% lang 'ContactName' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield4" name="contactfields[companyname]" value="companyname" {{ IsContactCompanyName|safe }}>
							<label for="contactfield4">{% lang 'ContactCompanyName' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield5" name="contactfields[phone]" value="phone" {{ IsContactPhone|safe }}>
							<label for="contactfield5">{% lang 'ContactPhone' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield6" name="contactfields[orderno]" value="orderno" {{ IsContactOrderNo|safe }}>
							<label for="contactfield6">{% lang 'ContactOrderNo' %}</label>
		                </div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="contactfield7" name="contactfields[rma]" value="rma" {{ IsContactRMA|safe }}>
							<label for="contactfield7">{% lang 'ContactRMANo' %}</label>
		                </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'EmailQuestionsTo' %}</label>
					<div class="col-md-10">
						<input type="text" id="pageemail" name="pageemail" class="form-control" value="{{ PageEmail|safe }}">
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'NavigationMenuOptions' %}</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'ParentPage' %}</label>
					<div class="col-md-10">
						<select id="pageparentid" name="pageparentid" class="form-control" size="5">
							<option SELECTED value='0'>-- {% lang 'NoParentPage' %} --</option>
							{{ ParentPageOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'NavigationMenu' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="pagestatus" name="pagestatus" value="ON" {{ Visible|safe }}>
							<label for="pagestatus">{% lang 'YesPageVisible' %}</label>
		                </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'DisplayAsHomePage' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="pageishomepage" name="pageishomepage" value="ON" {{ IsHomePage|safe }}>
							<label for="pageishomepage">{% lang 'YesDisplayAsHomePage' %}</label>
		                </div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'PageCustomersOnly' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" id="pagecustomersonly" name="pagecustomersonly" value="1" {{ IsCustomersOnly|safe }}>
							<label for="pagecustomersonly">{% lang 'YesRestrictToCustomersOnly' %}</label>
		                </div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default HideIfLink">
			<div class="panel-heading"> 
				<h3 class="panel-title">SEO</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="row">
					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'MetaTitle' %}</label>
							<input type="text" id="pagemetatitle" name="pagemetatitle" class="form-control" value="{{ PageMetaTitle|safe }}">
						</div>
					</div>

					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'MetaKeywords' %}</label>
							<input type="text" id="pagekeywords" name="pagekeywords" class="form-control" value="{{ PageKeywords|safe }}">
						</div>
					</div>
				</div>

				<div class="row">
					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'MetaDescription' %}</label>
							<input type="text" id="pagedesc" name="pagedesc" class="form-control" value="{{ PageDesc|safe }}">
						</div>
					</div>

					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'SearchKeywords' %}</label>
							<input type="text" id="pagesearchkeywords" name="pagesearchkeywords" class="form-control" value="{{ PageSearchKeywords|safe }}">
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default HideIfLink">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'AdvancedPageOptions' %}</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="row">
					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'TemplateLayoutFile' %}</label>
							<select name="pagelayoutfile" id="pagelayoutfile" class="form-control">
								{{ LayoutFiles|safe }}
							</select>
						</div>
					</div>

					<div class="col-sm-6">
						<div class="form-group">
							<label>{% lang 'SortOrder' %}</label>
							<input type="text" id="pagesort" name="pagesort" class="form-control" size="5" value="{{ PageSort|safe }}">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" />
			<input type="submit" name="addAnother2" value="{{ SaveAndAddAnother|safe }}" class="btn btn-primary" />
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel();" />
			<input id="currentTab" name="currentTab" value="details" type="hidden">
		</div>
	</div>
</form>

<script type="text/javascript">
	parentOptions = new Array();
	function ConfirmCancel() {
		if(confirm("{% lang 'ConfirmCancelPage' %}"))
			document.location.href = "index.php?ToDo=viewPages";
	}

	function ToggleVendor(vendorId) {
		if(typeof(parentOptions[vendorId]) != 'undefined') {
			$('#pageparentid').find('option:gt(0)').remove();
			$('#pageparentid').append(parentOptions[vendorId]);
			return;
		}
		
		$('#pageparentid').attr('disabled', true);
		$.ajax({
			url: 'remote.php?w=getPageParentOptions',
			data: {
				pageId: $('#pageId').val(),
				vendorId: vendorId,
				parentId: $('#pageparentid').val()
			},
			
			success: function(data) {
				parentOptions[vendorId] = data;
				$('#pageparentid').attr('disabled', false);
				$('#pageparentid').find('option:gt(0)').remove();
				$('#pageparentid').append(parentOptions[vendorId]);
			}
		});
	}

	function CheckPageForm() {
		var pt0 = g("pagetype_0");
		var pt1 = g("pagetype_1");
		var pt2 = g("pagetype_2");
		var pt3 = g("pagetype_3");
		var pagetitle = g("pagetitle");
		var pagelink = g("pagelink");
		var pagefeed = g("pagefeed");
		var pageemail = g("pageemail");

		if(pagetitle.value == "") {
			alert("{% lang 'EnterPageTitle' %}");
			pagetitle.focus();
			return false;
		}

		if(pt1.checked) {
			if(pagelink.value == "" || pagelink.value == "http://") {
				alert("{% lang 'EnterPageLink' %}");
				pagelink.focus();
				pagelink.select();
				return false;
			}
		} else if(pt2.checked) {
			if(pagefeed.value == "" || pagefeed.value == "http://") {
				alert("{% lang 'EnterPageFeed' %}");
				pagefeed.focus();
				pagefeed.select();
				return false;
			}
		} else if(pt3.checked) {
			if(IsWysiwygEditorEmpty(content.value)) {
				alert("{% lang 'EnterPageContent' %}");
				return false;
			}

			if(pageemail.value && pageemail.value.indexOf("@") == -1 || pageemail.value.indexOf(".") == -1) {
				alert("{% lang 'EnterPageEmail' %}");
				pageemail.focus();
				pageemail.select();
				return false;
			}
		} else if ($('#pageEnableOptimizer').attr('checked')) {
			if(!Optimizer.ValidateConfigForm(ShowTab, 'optimizer')) {
				return false;
			}
		}

		return true;
	}

	function SwitchType(PageType) {
		if(PageType == 0) {
			$('.HideIfPage').hide();
			$('.HideIfNotPage').show();
			$('.HideIfLink').show();
			$('.HideIfNotLink').show();
			$('.HideIfRSS').hide();
			$('.HideIfContact').hide();
			$('#pagetype_0').attr('checked', 'true');
			if (!{{ IsVendor|safe }}) {
				$('.HideIfLinkVendor').show();
			}
		} else if(PageType == 1) {
			$('.HideIfPage').show();
			$('.HideIfNotPage').hide();
			$('.HideIfLink').hide();
			$('.HideIfNotLink').hide();
			$('.HideIfRSS').hide();
			$('.HideIfContact').hide();
			$('.HideIfLinkVendor').hide();
			$('#pagetype_1').attr('checked', 'true');
		} else if(PageType == 2) {
			$('.HideIfPage').hide();
			$('.HideIfNotPage').hide();
			$('.HideIfLink').show();
			$('.HideIfNotLink').show();
			$('.HideIfRSS').show();
			$('.HideIfContact').hide();
			if (!{{ IsVendor|safe }}) {
				$('.HideIfLinkVendor').show();
			}
			$('#pagetype_2').attr('checked', 'true');
		} else if(PageType == 3) {
			$('.HideIfPage').hide();
			$('.HideIfNotPage').hide();
			$('.HideIfLink').show();
			$('.HideIfNotLink').show();
			$('.HideIfRSS').hide();
			$('.HideIfContact').show();
			$('.PageContent').show();
			if (!{{ IsVendor|safe }}) {
				$('.HideIfLinkVendor').show();
			}
			$('#pagetype_3').attr('checked', 'true');
		}
	}

	$(document).ready(function() {
		{{ SetupType|safe }}
	});
</script>