<form enctype="multipart/form-data" action="index.php" id="frmSearch" method="get" onsubmit="return ValidateForm(CheckSearchForm)">
	<input type="hidden" name="ToDo" value="searchOrdersRedirect" />
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'SearchOrders' %}</h4>
			<p>{% lang 'SearchOrdersIntro' %}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="IndexCreateButton" value="{% lang 'Search' %}" id="IndexCreateButton" class=" btn btn-primary">
			<input type="reset" onclick="ConfirmCancel()" value="{% lang 'Cancel' %}" class="btn btn-danger">
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'AdvancedSearch' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'SearchKeywords' %}:
						</label>
						<div class="col-md-10">
							<input type="text" id="searchQuery" name="searchQuery" class="form-control" style="width: 100% !important">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'OrderStatus1' %}:
						</label>
						<div class="col-md-10">
							<select id="orderStatus" name="orderStatus" class="form-control">
								<option value="">{% lang 'ChooseAnOrderStatus' %}</option>
								{{ OrderStatusOptions|safe }}
							</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'PaymentMethod' %}:
						</label>
						<div class="col-md-10">
							<select id="paymentMethod" name="paymentMethod" class="form-control">
								<option value="">{% lang 'ChooseAPaymentMethod' %}</option>
								{{ OrderPaymentOptions|safe }}
							</select>
						</div>
					</div>

					{% if OrderTypeOptions %}
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'OrderType' %}:
						</label>
						<div class="col-md-10">
							<select id="ebayOrderId" name="ebayOrderId" class="form-control">
								<option value="">{% lang 'ChooseAnOrderType' %}</option>
								{{ OrderTypeOptions|safe }}
							</select>
						</div>
					</div>
					{% endif %}

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ShippingMethod' %}:
						</label>
						<div class="col-md-10">
							<select id="shippingMethod" name="shippingMethod" class="form-control">
								<option value="">{% lang 'ChooseAShippingMethod' %}</option>
								{{ OrderShippingOptions|safe }}
							</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'CouponCode' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="couponCode" class="form-control" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'PreOrders' %}:
						</label>
						<div class="col-md-10">
							<label for="preorders_0"><input type="checkbox" name="preorders[]" value="0" id="preorders_0" checked="checked" /> {% lang 'Includeordersthatdonotcontainpreorderproducts' %}</label><br />
							<label for="preorders_1"><input type="checkbox" name="preorders[]" value="1" id="preorders_1" checked="checked" /> {% lang 'Includeordersthatcontainpreorderproducts' %}</label><br />
						</div>
					</div>
					{% if ISC_CFG.DeletedOrdersAction == 'delete' %}
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'DeletedOrders' %}:
						</label>
						<div class="col-md-10">
							<label><input name="searchDeletedOrders" value="no" type="radio" checked="checked" />{% lang 'SearchDeletedOrders_No' %}</label><br />
						  	<label><input name="searchDeletedOrders" value="both" type="radio" />{% lang 'SearchDeletedOrders_Both' %}</label><br />
						  	<label><input name="searchDeletedOrders" value="only" type="radio" />{% lang 'SearchDeletedOrders_Only' %}</label>
						</div>
					</div>
					{% endif %}
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'SearchByRange' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'OrderID' %}:
						</label>
						<div class="col-md-10">
							{% lang 'SearchFrom' %} &nbsp;&nbsp;<input type="text" id="orderFrom" name="orderFrom" class="form-control" style="width: 100px; display: inline;"> {% lang 'SearchTo' %}
							&nbsp;&nbsp;<input type="text" id="orderTo" name="orderTo" class="form-control" style="width: 100px;; display: inline;">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'OrderTotal' %}:
						</label>
						<div class="col-md-10">
							{% lang 'SearchFrom' %} {{ CurrencyTokenLeft|safe }}<input type="text" id="totalFrom" name="totalFrom" class="form-control" style="width: 100px;; display: inline;"> {{ CurrencyTokenRight|safe }} {% lang 'SearchTo' %}
						{{ CurrencyTokenLeft|safe }}<input type="text" id="totalTo" name="totalTo" class="form-control" style="width: 100px;; display: inline;"> {{ CurrencyTokenRight|safe }}
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">Faixa de Data</h3>
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'DateRange' %}:
						</label>
						<div class="col-md-10">
							<select name="dateRange" id="dateRange" onchange="ToggleRange()" class="form-control">
								<option value="">{% lang 'ChooseOrderDate' %}</option>
								<option value="today">{% lang 'Today' %}</option>
								<option value="yesterday">{% lang 'Yesterday' %}</option>
								<option value="day">{% lang 'Last24Hours' %}</option>
								<option value="week">{% lang 'Last7Days' %}</option>
								<option value="month">{% lang 'Last30Days' %}</option>
								<option value="this_month">{% lang 'ThisMonth' %}</option>
								<option value="this_year">{% lang 'ThisYear' %}</option>
								<option value="custom">{% lang 'CustomPeriod' %}</option>
							</select>

							<div id="dateRangeCustom" style="margin-left: 30px; margin-top: 10px;">
								{% lang 'SearchFrom' %} <input class="plain" name="fromDate" id="dc1" size="12" onfocus="this.blur()" readonly><a href="javascript:void(0)" onclick="if(self.gfPop)gfPop.fStartPop(document.getElementById('dc1'),document.getElementById('dc2'));return false;" HIDEFOCUS><img name="popcal" align="absmiddle" src="images/calbtn.gif" width="34" height="22" border="0" alt=""></a>
								{% lang 'SearchTo' %} <input class="plain" name="toDate" id="dc2" size="12" onfocus="this.blur()" readonly><a href="javascript:void(0)" onclick="if(self.gfPop)gfPop.fEndPop(document.getElementById('dc1'),document.getElementById('dc2'));return false;" HIDEFOCUS><img name="popcal" align="absmiddle" src="images/calbtn.gif" width="34" height="22" border="0" alt=""></a>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'SearchByDateType' %}:
						</label>
						<div class="col-md-10">
							<label><input name="SearchByDate" value="0" type="radio" checked="checked" />{% lang 'SearchByOrderDate' %}</label><br />
							<label><input name="SearchByDate" value="1" type="radio" />{% lang 'SearchByEventDate' %}</label><br />
							<label><input name="SearchByDate" value="2" type="radio" />{% lang 'SearchByOrderAndEventDate' %}</label>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'SortOrder' %}</h3>
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'SortOrder' %}:
						</label>
						<div class="col-md-10">
							<select name="sortField" class="form-control" style="width: auto; display: inline;">
								<option value="orderid">{% lang 'OrderId' %}</option>
								<option value="custname">{% lang 'Customer' %}</option>
								<option value="orddate">{% lang 'Date' %}</option>
								<option value="ordstats">{% lang 'Status' %}</option>
								<option value="newmessages">{% lang 'NewMessages' %}</option>
								<option value="total_inc_tax">{% lang 'Total' %}</option>
							</select>
							em&nbsp;
							<select name="sortOrder" class="form-control" style="width: 140px; display: inline;">
								<option value="asc">{% lang 'AscendingOrder' %}</option>
								<option value="desc">{% lang 'DescendingOrder' %}</option>
							</select>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="IndexCreateButton" value="{% lang 'Search' %}" id="IndexCreateButton" class=" btn btn-primary">
			<input type="reset" onclick="ConfirmCancel()" value="{% lang 'Cancel' %}" class="btn btn-danger">
		</div>
	</div>
	<iframe width=132 height=142 name="gToday:contrast:agenda.js" id="gToday:contrast:agenda.js" src="calendar/ipopeng.htm" scrolling="no" frameborder="0" style="visibility:visible; z-index:999; position:absolute; left:-500px; top:0px;"></iframe>
</form>

<script type="text/javascript">
	function ToggleRange() {
		var range = document.getElementById('dateRange');
		if(range.options[range.selectedIndex].value == "custom") {
			document.getElementById('dateRangeCustom').style.display = '';
		} else {
			document.getElementById('dateRangeCustom').style.display = 'none';
		}
	}

	ToggleRange();

	function ConfirmCancel() {
		if(confirm("{% lang 'ConfirmCancelSearch' %}"))
			document.location.href = "index.php?ToDo=viewOrders";
	}

	function CheckSearchForm() {
		var orderFrom = document.getElementById("orderFrom");
		var orderTo = document.getElementById("orderTo");
		var totalFrom = document.getElementById("totalFrom");
		var totalTo = document.getElementById("totalTo");
		var fromDate = document.getElementById("dc1");
		var toDate = document.getElementById("dc2");

		if(orderFrom.value != "" && isNaN(orderFrom.value)) {
			alert("{% lang 'SearchEnterValidOrderId' %}");
			orderFrom.focus();
			orderFrom.select();
			return false;
		}

		if(orderTo.value != "" && isNaN(orderTo.value)) {
			alert("{% lang 'SearchEnterValidOrderId' %}");
			orderTo.focus();
			orderTo.select();
			return false;
		}

		if(totalFrom.value != "" && isNaN(priceFormat(totalFrom.value))) {
			alert("{% lang 'SearchEnterValidTotal' %}");
			totalFrom.focus();
			totalFrom.select();
			return false;
		}

		if(totalTo.value != "" && isNaN(priceFormat(totalTo.value))) {
			alert("{% lang 'SearchEnterValidTotal' %}");
			totalTo.focus();
			totalTo.select();
			return false;
		}

		if(fromDate.value != "" && fromDate.value == toDate.value) {
			alert("{% lang 'SearchChooseDifferentDates' %}");
			return false;
		}

		return true;
	}
</script>