<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return ValidateForm(CheckNewsForm)" id="frmNews" method="post" class="form-horizontal">
	<input type="hidden" name="newsId" value="{{ NewsId|safe }}">

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
	<br />

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'NewNewsDetails' %}</h3> 
		</div> 

		<div class="panel-body">
			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'NewsTitle' %}</label>
				<div class="col-md-10">
					<input type="text" id="newstitle" name="newstitle" class="form-control" value="{{ NewsTitle|safe }}">
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'SearchKeywords' %}</label>
				<div class="col-md-10">
					<input type="text" id="newssearchkeywords" name="newssearchkeywords" class="form-control" value="{{ NewsSearchKeywords|safe }}">
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'Visible' %}</label>
				<div class="col-md-10">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" id="newsvisible" name="newsvisible" value="1" {{ NewsVisible|safe }}>
						<label for="newsvisible">{% lang 'YesNewsVisible' %}</label>
		            </div>
		        </div>
		    </div>
		</div>
	</div>

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'PostContent' %}</h3> 
		</div> 

		<div class="panel-body">
			{{ WYSIWYG|safe }}
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
		</div>
	</div>
</form>

<script type="text/javascript">
	function ConfirmCancel(){
		if(confirm("{% lang 'ConfirmCancelNews' %}"))
		document.location.href = "index.php?ToDo=viewNews";
	}

	function CheckNewsForm(){
		var title = g("newstitle");

		if(g("wysiwyg"))
			var wysiwyg = g("wysiwyg"); // Text area
		else
			var wysiwyg = g("wysiwyg_html"); // DevEdit

		if(IsWysiwygEditorEmpty(wysiwyg.value)){
			alert("{% lang 'EnterNewsContent' %}");
			return false;
		}

		if(title.value == ""){
			alert("{% lang 'EnterNewsTitle' %}");
			title.focus();
			return false;
		}

		return true;
	}
</script>