<form enctype="multipart/form-data" action="index.php?ToDo=importCustomers&Step=2" onsubmit="return ValidateForm(CheckImportCustomerForm)" id="frmImport" method="post">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ImportCustomersStep1' %}</h4>
			<p>{% lang 'ImportCustomersStep1Desc' %}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
	<br />

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportBulkEditCSV' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="BulkEditTemplate" id="BulkEditTemplate" value="1" /> {% lang 'ImportBulkEditCSVYes' %}</label>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportOverride' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="OverrideDuplicates" id="Override" value="1" /> {% lang 'YesImportOverride' %}</label>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportFileDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportFile' %}:
						</label>
						<div class="col-md-10">
							<label>
								<input id="CustomerImportUseUpload" type="radio" name="useserver" value="0" checked="checked" onclick="ToggleSource();" />{% lang 'ImportFileUpload' %} {% lang 'ImportMaxSize' with ['maxSize': ImportMaxSize]%}
							</label>

							<div id="CustomerImportUploadField">
								<input type="file" name="importfile" id="ImportFile" class="Field250" />
							</div>

							<div>
								<label><input id="CustomerImportUseServer" type="radio" name="useserver" value="1" onclick="ToggleSource();" /> {% lang 'ImportFileServer' %}</label>
							</div>

							<div id="CustomerImportServerField" style=" display: none;">
								<select name="serverfile" id="ServerFile" class="Field250">
									<option value="">{% lang 'ImportChooseFile' %}</option>
									{{ ServerFiles|safe }}
								</select>
							</div>

							<div id="CustomerImportServerNoList" style="display: none; font-style: italic;" class="Field250">
								{% lang 'FieldNoServerFiles' %}
							</div>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportContainsHeaders' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="Headers" id="Headers" value="1" /> {% lang 'YesImportContainsHeaders' %}</label>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldSeparator' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldSeparator" id="FieldSeparator" class="Field250" value="{{ FieldSeparator|safe }}" />
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldEnclosure' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldEnclosure" id="FieldEnclosure" class="Field250" value='{{ FieldEnclosure|safe }}' />
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
</form>

<script type="text/javascript">
	function ConfirmCancel() {
		if(confirm('{% lang 'ConfirmCancelImport' %}'))
			window.location = 'index.php?ToDo=manageCustomers';
	}

	function CheckImportCustomerForm() {
		var f = document.getElementById('CustomerImportUseUpload');
		if(f.checked == true) {
			var f = document.getElementById('ImportFile');
			if(f.value == '') {
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		} else {
			var f = document.getElementById('ServerFile');
			if(f.value < 1) {
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		}

		var f = document.getElementById('FieldSeparator');
		if(f.value == '') {
			alert('{% lang 'NoImportFieldSeparator' %}');
			f.focus();
			return false;
		}

		var f = document.getElementById('FieldEnclosure');
		if(f.value == '') {
			alert('{% lang 'NoImportFieldEnclosure' %}');
			f.focus();
			return false;
		}
		return true;
	}

	function ToggleSource() {
		var file = document.getElementById('CustomerImportUseUpload');
		if(file.checked == true) {
			document.getElementById('CustomerImportUploadField').style.display = '';
			document.getElementById('CustomerImportServerField').style.display = 'none';
			document.getElementById('CustomerImportServerNoList').style.display = 'none';
		} else {
			document.getElementById('CustomerImportUploadField').style.display = 'none';

			if(document.getElementById('CustomerImportServerField').getElementsByTagName('SELECT')[0].options.length == 1) {
				document.getElementById('CustomerImportServerNoList').style.display = '';
			} else {
				document.getElementById('CustomerImportServerField').style.display = '';
			}
		}
	}

	$("#BulkEditTemplate").change(function() {
		var disabled = '';
		if ($(this).attr('checked')) {
			disabled = 'disabled';
		}

		$("#Headers").attr({
			'checked': $(this).attr('checked'),
			'disabled': disabled

		});

		$("#Override").attr({
			'checked': $(this).attr('checked'),
			'disabled': disabled
		});

		$("#Override").change();

		$(".BulkImportRowHide").toggle();
	});
</script>