<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return ValidateForm(CheckForm)" id="frmTemplate" method="post">
{{ hiddenFields|safe }}
<input id="currentTab" name="currentTab" value="0" type="hidden">
<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{{ TemplateTitle|safe }}</h4>
		<p>{{ ExportIntro|safe }}</p>
		<div id="CustomerStatus">{{ Message|safe }}</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="submit" value="{% lang 'Continue' %}" class="btn btn-primary" />
		<input type="button" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
	</div>
</div>
<br />

<div class="row" style="{{ HideForm|safe }}">
	<div class="col-sm-12">
		<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="margin-bottom: 20px;">
			<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'ExportDetails' %}</a></li>
			<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'DataSummary' %}</a></li>
			<br class="Clear" />
		</ul>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<div id="div0" style="{{ HideForm|safe }}">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ExportFormatTitle' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group">
						<label class="col-md-2 control-label">
							{% lang 'TemplateLabel' %}:
						</label>
						<div class="col-md-10">
							{{ TemplatesList|safe }}
						</div>
					</div>

					<div class="form-group">
						<label class="col-md-2 control-label">
							{% lang 'ExportFileFormat' %}:
						</label>
						<div class="col-md-10">
							{{ Methods|safe }}
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div1" style="display: none;">
			<div class="GridContainer" id="GridContainer">
				{{ DataGrid|safe }}
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-sm-12">
		<input type="submit" value="{% lang 'Continue' %}" class="btn btn-primary" />
		<input type="button" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
	</div>
</div>
</form>

<script type="text/javascript">
	function ConfirmCancel() {
		if(confirm('{% lang 'CancelMessage' %}')) {
			document.location.href='{{ ViewLink|safe }}';
		} else {
			return false;
		}
	}

	function CheckForm() {
		if ($("#template").val() == null) {
			alert("{% lang 'NoTemplateSelected' %}");

			return false;
		}

		var formData = $("#frmTemplate").serialize();

		$.iModal({
			type: 'ajax',
			url: 'index.php?ToDo={{ FormAction|safe }}',
			urlData: formData,
			width: 400,
			onBeforeClose: function() {
				CancelAjaxExport();
			}
		});

		return false;
	}

	function ShowTab(T) {
		i = 0;
		while (document.getElementById("tab" + i) != null) {
			$('#div'+i).hide();
			$('#tab'+i).removeClass('active');
			++i;
		}

		$('#div'+T).show();
		$('#tab'+T).addClass('active');
	}
</script>