{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}
<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" id="frmNews" method="post" onSubmit="return CheckDiscountRuleForm()">
	<input type="hidden" id="discountId" name="discountId" value="{{ DiscountId|safe }}">
	<style>.Field20{width: auto !important; display: inline}</style>
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br />

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'NewDiscountDetails' %}</h3> 
		</div> 

		<div class="panel-body"> 
			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'DiscountFormRuleName' %}</label>
				<div class="col-md-10">
					<input type="text" id="discountname" name="discountname" class="form-control" value="{{ DiscountName|safe }}" />
					<span class="help-block"><small>Como 'Frete grtis em pedidos acima de R$200'. Esse nome serve somente para sua referncia.</small></span>
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'DiscountFormEnabled' %}</label>
				<div class="col-md-10">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" name="enabled" id="enabled" value="1" {{ DiscountEnabledCheck|safe }}>
						<label>{% lang 'DiscountFormEnabledDescription' %}</label>
		            </div>
		        </div>
		    </div>

			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'DiscountFormRuleExpires' %}</label>
				<div class="col-md-10">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" name="discountruleexpires" id="discountruleexpires"  {{ DiscountExpiryCheck|safe }} onclick="if(this.checked) { $('.DiscountExpiryFields').show(); } else { $('.DiscountExpiryFields').hide(); }" value="1" />
						<label>{% lang 'DiscountFormRuleExpiresDescription' %}</label>
		            </div>
		            <div style="display:none" id="rulexpires"></div>
		            <br />
		            <div style="margin-top: 3px; padding-left:20px; {{ DiscountExpiryFields|safe }}" class="DiscountExpiryFields">
						<div class="col-md-8 form-group">
                            <div class="input-group">
                            	<span class="input-group-addon">
                              		<input name="discountruleexpiresuses" id="discountruleexpiresuses" onclick="$('#discountruleexpiresusesamount').attr('readonly', !$('#discountruleexpiresusesamount').attr('readonly'));" type="checkbox">
                                </span>
                                <span class="input-group-addon">Tornar esta regra de desconto inativa aps</span>
                                <input name="discountruleexpiresusesamount" id="discountruleexpiresusesamount" class="form-control" value="1" onclick="$('#discountruleexpiresusesamount').attr('readonly', false);$('#discountruleexpiresuses').attr('checked', true);"> 
                                <span class="input-group-addon">uso(s)</span>
                            </div>
                        </div>
		            </div>
		        </div>
		    </div>
		</div>
	</div>

	<div class="panel panel-default form-horizontal">
		<div class="panel-heading"> 
			<h3 class="panel-title">Tipo de Desconto</h3> 
		</div> 

		<div class="panel-body"> 
			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'DiscountFormRuleType' %}</label>
				<div class="col-md-10">
					{{ RuleList|safe }}
				</div>
			</div>
		</div>
	</div>

	<div class="panel panel-default form-horizontal" id="FreeShipingDiscountRulesOptionsSection" style="display: none">
		<div class="panel-heading"> 
			<h3 class="panel-title">Tipo de Desconto</h3> 
		</div> 

		<div class="panel-body"> 
			<div class="form-group">
				<label class="col-md-2 control-label">{% lang 'FreeShippingMessage' %}</label>
				<div class="col-md-10">
					<textarea name="FreeShippingMessage" id="FreeShippingMessage" class="form-control" rows="5">Gaste mais %%REMAINING_AMOUNT%% para se qualificar para frete grtis!</textarea>
				</div>
			</div>

			<div class="form-group">
				<label class="col-md-2 control-label"></label>
				<div class="col-md-10">
					<div class="checkbox checkbox-primary">
						<input name="ShowFreeShippingMesgOn[homepage]" class="ShowFreeShippingMesgOn" id="ShowFreeShippingMesgOnHomePage" value="homepage" type="checkbox">
						<label for="ShowFreeShippingMesgOnHomePage"> Exibir a mensagem de frete grtis na pgina principal</label>
		            </div>

					<div class="checkbox checkbox-primary">
						<input name="ShowFreeShippingMesgOn[productpage]" class="ShowFreeShippingMesgOn" id="ShowFreeShippingMesgOnProductPage" value="productpage" type="checkbox">
						<label for="ShowFreeShippingMesgOnProductPage"> Exibir a mensagem de frete grtis na pgina do produto</label>
		            </div>

					<div class="checkbox checkbox-primary">
						<input name="ShowFreeShippingMesgOn[cartpage]" class="ShowFreeShippingMesgOn" id="ShowFreeShippingMesgOnCartPage" value="cartpage" type="checkbox">
						<label for="ShowFreeShippingMesgOnCartPage"> Exibir a mensagem de frete grtis na pgina do carrinho</label>
		            </div>

					<div class="checkbox checkbox-primary">
						<input name="ShowFreeShippingMesgOn[checkoutpage]" class="ShowFreeShippingMesgOn" id="ShowFreeShippingMesgOnCheckoutPage" value="checkoutpage" type="checkbox">
						<label for="ShowFreeShippingMesgOnCheckoutPage"> Exibir a mensagem de frete grtis na pgina de finalizao da compra</label>
		            </div>
		        </div>
		    </div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>

<script type="text/javascript">
	var previous = {{ CurrentRule|safe }};

	function ConfirmCancel()
	{
		if(confirm("{% lang 'ConfirmCancelDiscount' %}"))
			document.location.href = "index.php?ToDo=viewDiscounts";
	}

		function VendorSupport() {
				alert('{% lang 'DiscountVendorWarning' %}');
		}

		function UpdateModule(module, vendor) {

			if ({{ Vendor|safe }} && !vendor) {
				$('#'+module).attr('checked', false);
				$('#'+previous).attr('checked', true);
				alert('{% lang 'DiscountVendorWarning' %}');
				return;
			}

			previous = module;

			if(module == '' || module == null) {
				return;
			}

			$.ajax({
				'url': 'remote.php',
				'method': 'post',
				'data': {
					'remoteSection': 'discounts',
					'w': 'getRuleModuleProperties',
					'module': module
				},
				'success': function(data) {
					$('.ruleWrapper').hide();
					$('.ruleSettings').html('');
					$('#ruleSettings'+module).html(data);
					$('#ruleWrapper'+module).show();
					$('.discountFirst').focus();

				}
			});
		}

		function CheckDiscountRuleForm()
		{
			var discountname = document.getElementById("discountname");
			var discountruleexpires = document.getElementById("discountruleexpires");
			var discountruleexpiresuses = document.getElementById("discountruleexpiresuses");
			var discountruleexpiresusesamount = document.getElementById("discountruleexpiresusesamount");
			var discountruleexpiresdate = document.getElementById("discountruleexpiresdate");
			var discountruleexpiresdateamount = document.getElementById("discountruleexpiresdateamount");
			var enabled = document.getElementById("enabled");

			var type = document.getElementsByName("RuleType");

			if(discountname.value == "") {
				alert("{% lang 'EnterDiscountName' %}");
				discountname.focus();
				return false;
			}

			if (discountruleexpires.checked) {
				if (discountruleexpiresuses.checked) {
					if (isNaN(discountruleexpiresusesamount.value)) {
						alert("{% lang 'EnterDiscountExpiresUsesAmount' %}");
						discountruleexpiresusesamount.focus();
						discountruleexpiresusesamount.select();
						return false;
					}
				}

				if (discountruleexpiresdate.checked) {
					if (discountruleexpiresdateamount.value == '' || new Date(discountruleexpiresdateamount.value) == 'Invalid Date') {
						alert("{% lang 'EnterDiscountExpiresDateAmount' %}");
						discountruleexpiresdateamount.focus();
						discountruleexpiresdateamount.select();
						return false;
					}
				}
			}
			var checked = false;
			for (var i = 0; i < type.length; i++) {
				if (type[i].checked) {

					var response = this[type[i].id]();

					if (response == true)
					{
						checked = true;
						break;
					}

					return false;
				}
			}

			if (!checked) {
				alert("{% lang 'EnterDiscountSelectRule' %}");
				return false;
			}

			if ($(".discountRadio:checked").val() == 'rule_buyxgetfreeshipping'
			|| $(".discountRadio:checked").val() == 'rule_freeshippingwhenoverx') {
				if ($.trim($("#FreeShippingMessage").val()) == '') {
					alert("{% lang 'EnterFreeShippingMessage' %}");
					$("#FreeShippingMessage").focus();
					return false;
				}
				if ($(".ShowFreeShippingMesgOn:checked").length <= 0) {
					alert("{% lang 'EnterShowFreeShippingMesgOn' %}");
					$("#ShowFreeShippingMesgOnHomePage").focus();
					return false;
				}
			}
			return true;
		}
		$(document).ready(function() {
			$(".discountRadio").live('change', function() {
				if ($(this).val() == 'rule_buyxgetfreeshipping'
				|| $(this).val() == 'rule_freeshippingwhenoverx') {
					$("#FreeShipingDiscountRulesOptionsSection").show();
				} else {
					$("#FreeShipingDiscountRulesOptionsSection").hide();
				}
			});
			$(".discountRadio:checked").trigger("change")

			$('.LearnMoreFreeShippingMessagePlaceHolder').click(function(event){
				event.preventDefault();
				LaunchHelp('907');
			});
		});

		{{ DiscountJavascriptValidation|safe }}
	</script>
