{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}
<script type="text/javascript" src="../javascript/formfield.js?{{ JSCacheToken }}"></script>
<form action="index.php?ToDo={{ FormAction|safe }}" onsubmit="return ValidateForm(checkAddCustomerForm)" id="frmCustomer" method="post">
	<input type="hidden" name="customerId" id="customerId" value="{{ CustomerId|safe }}" />
	<input type="hidden" name="newCustomer" id="newCustomer" value="{{ NewCustomer|safe }}" />
	<input id="currentTab" name="currentTab" value="0" type="hidden" />

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			<div id="MessageTmpBlock">{{ Message|safe }}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="submit" value="{{ SaveAndAddAnother|safe }}" name="SaveContinueButton1"  onclick="saveAndAddAnother();" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="confirmCancel()" />
		</div>
	</div>
	<br />

	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs tabs" style="margin-bottom: 20px;">
				<li class="tab"><a href="#" id="tab0" onclick="ShowTab(0)" class="active">{% lang 'CustomerDetails' %}</a></li>
				<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'CustomerAddressBook' %}</a></li>
			</ul>
		</div>
	</div>

	<div id="div0">
		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CustomerDetails' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerFirstName' %}</label>
					<div class="col-md-10">
						<input type="text" id="custFirstName" name="custFirstName" class="form-control" value="{{ CustomerFirstName|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerLastName' %}</label>
					<div class="col-md-10">
						<input type="text" id="custLastName" name="custLastName" class="form-control" value="{{ CustomerLastName|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerCompany' %}</label>
					<div class="col-md-10">
						<input type="text" id="custCompany" name="custCompany" class="form-control" value="{{ CustomerCompany|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerEmail' %}</label>
					<div class="col-md-10">
						<div class="input-group">
							<input type="text" id="custEmail" name="custEmail" class="form-control" value="{{ CustomerEmail|safe }}">
							<span class="input-group-btn">
								<button type="button" class="btn waves-effect waves-light btn-primary" onclick="checkEmailUniqueRequest(); return false;">{% lang 'CustomerEmailUniqueCheckLink' %}</button>
							</span>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerGroup' %}</label>
					<div class="col-md-10">
						<select id="custGroupId" name="custGroupId" class="form-control">
							<option value="0">{% lang 'CustomerGroupNotAssoc' %}</option>
							{{ CustomerGroupOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerPhone' %}</label>
					<div class="col-md-10">
						<input type="text" id="custPhone" name="custPhone" class="form-control" value="{{ CustomerPhone|safe }}" />
					</div>
				</div>

				{% if HideStoreCredit != "none" %}
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerStoreCredit' %}</label>
					<div class="col-md-10">
						<div class="input-group">
							<span class="input-group-addon">R$</span>
							<input type="text" id="custStoreCredit" name="custStoreCredit" class="form-control" value="{{ CustomerStoreCredit|safe }}">
						</div>
					</div>
				</div>
				{% endif %}

				{{ CustomFields|safe }}
			</div>
		</div>

		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CustomerPasswordDetails' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'PasswordLabel' %}</label>
					<div class="col-md-10">
						<input type="password" id="custPassword" name="custPassword" class="form-control" value="{{ CustomerPassword|safe }}" AUTOCOMPLETE = "OFF">
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CustomerPasswordConfirm' %}</label>
					<div class="col-md-10">
						<input type="password" id="custPasswordConfirm" name="custPasswordConfirm" class="form-control" value="{{ CustomerPasswordConfirm|safe }}" AUTOCOMPLETE = "OFF">
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div id="div1">
		<div class="alert alert-warning" style="display: {{ CustomerAddressEmptyShow|safe }}">{{ CustomerAddressListWarning|safe }}</div>
		<p class="Intro" style="display: {{ HideCustomerAddressButtons|safe }};">
			<input type="button" value="{% lang 'CustomerAddShippingAddress' %}" onclick="addShippingAddress();" class="btn btn-primary btn-sm" {{ CustomerAddressAddDisabled|safe }} />
			<input type="button" value="{% lang 'DeleteSelected' %}" name="DeleteAddressesButton" onclick="confirmDeleteAddressBoxes();" class="btn btn-danger btn-sm" {{ CustomerAddressDeleteDisabled|safe }}/>
		</p>
		<div class="GridContainer" style="display: {{ CustomerAddressEmptyHide|safe }}">
			{{ CustomerShippingAddressGrid|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" name="SaveButton1" />
			<input type="submit" value="{{ SaveAndAddAnother|safe }}" name="SaveContinueButton1"  onclick="saveAndAddAnother();" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" name="CancelButton1" onclick="confirmCancel()" />
		</div>
	</div>
</div>
</form>

<script type="text/javascript"><!--

	$(document).ready(function() {
		ShowTab({{ CurrentTab|safe }});
	});

	function ShowTab(T)
	{
			i = 0;
			while (document.getElementById("tab" + i) != null) {
				document.getElementById("div" + i).style.display = "none";
				document.getElementById("tab" + i).className = "";
				i++;
			}

			if (T == 1) {
				$('#SaveButtons').hide();
			} else {
				$('#SaveButtons').show();
			}

			document.getElementById("div" + T).style.display = "";
			document.getElementById("tab" + T).className = "active";
			document.getElementById("currentTab").value = T;
	}

	function getAddressBoxes()
	{
		return $("#IndexGrid :checkbox[name='addresses[]']");
	}

	function selectedAddressBoxes()
	{
		return getAddressBoxes().not("[checked=false]");
	}

	function toggleAddressBoxes(status)
	{
		getAddressBoxes().each(function() { $(this).attr("checked", status); });
	}

	function confirmDeleteAddressBoxes(addressId)
	{
		if ((!isNaN(addressId) && addressId > 0) || selectedAddressBoxes().length > 0) {
			if (confirm("{% lang 'ConfirmDeleteCustomerAddresses' %}")) {
				if (!isNaN(addressId) && addressId > 0) {
					MakeHidden('addresses', addressId, 'frmCustomer');
				}
				document.getElementById("frmCustomer").action = "index.php?ToDo=deleteCustomerAddress";
				document.getElementById("frmCustomer").submit();
			}
		} else {
			alert("{% lang 'ChooseCustomerAddress' %}");
		}
	}

	function saveAndAddAnother() {
		MakeHidden('addanother', '1', 'frmCustomer');
	}

	function saveAndAddAddress() {
		ShowTab(0);
		if (checkAddCustomerForm()) {
			MakeHidden('addaddresses', '1', 'frmCustomer');
			document.getElementById("frmCustomer").submit();
		}
	}

	function confirmCancel() {
		if(confirm('{{ CancelMessage|safe }}')) {
			document.location.href='index.php?ToDo=viewCustomers';
		} else {
			return false;
		}
	}

	function checkAddCustomerForm()
	{
		var checkFileds = new Array();

		checkFileds['custFirstName'] = "{% lang 'CustomerFirstNameRequired' %}"
		checkFileds['custLastName'] = "{% lang 'CustomerLastNameRequired' %}"
		checkFileds['custEmail'] = "{% lang 'CustomerEmailRequired' %}";

		if ("{{ PasswordRequiredCheck|safe }}" == "1") {
			checkFileds['custPassword'] = "{% lang 'CustomerPasswordRequired' %}";
		}

		for (var i in checkFileds) {
			if ($('#' + i).val() == '') {
				alert(checkFileds[i]);
				$('#' + i).focus();
				return false;
			}
		}

		if($('#custEmail').val().indexOf("@") == -1 || $('#custEmail').val().indexOf(".") == -1) {
			alert("{% lang 'CustomerEmailInvalue' %}");
			$('#custEmail').focus();
			return false;
                }

		if ($('#custPassword').val() !== $('#custPasswordConfirm').val()) {
			alert("{{ PasswordConfirmError|safe }}");
			$('#custPassword').focus();
			return false;
		}

		if($('#custStoreCredit').val() && isNaN(priceFormat($('#custStoreCredit').val()))) {
			alert("{% lang 'CustomerStoreCreditError' %}");
			$('#custStoreCredit').focus().select();
			return false;
		}

		/**
		 * Now for the custom fields
		 */
		var formfields = FormField.GetValues({{ CustomFieldsAccountFormId|safe }});

		for (var i=0; i<formfields.length; i++) {
			var rtn = FormField.Validate(formfields[i].field);

			if (!rtn.status) {
				alert(rtn.msg);
				FormField.Focus(formfields[i].field);
				return false;
			}
		}

		return true;
	}

	function checkEmailUniqueRequest(formCheck)
	{
		if (formCheck !== 1) {
			formCheck = 0;
		}

		var obj = {};

		obj.type    = 'POST';
		obj.url     = 'remote.php';
		obj.data    = {
				'w'            : 'checkemailuniqueness',
				'remoteSection': 'customers',
				'customerId'   : '{{ CustomerId|safe }}',
				'email'        : $('#custEmail').val()
				};
		obj.success = checkEmailUniqueResponse;

		$.ajax(obj);
	}

	function checkEmailUniqueResponse(data)
	{
		var message = $('message', data).text();

		$('#MessageTmpBlock').hide();
		$('#MessageTmpBlock').html(message);
		$('#MessageTmpBlock').show('slow');
	}

	function addShippingAddress()
	{
		document.getElementById('frmCustomer').action = 'index.php?ToDo=addCustomerAddress';
		document.getElementById('frmCustomer').submit();
		return false;
	}

	function editShippingAddress(addressId)
	{
		MakeHidden('addressId', addressId, 'frmCustomer');
		document.getElementById('frmCustomer').action = 'index.php?ToDo=editCustomerAddress';
		document.getElementById('frmCustomer').submit();
		return false;
	}

	{{ FormFieldEventData|safe }}

//--></script>