{% import "macros/forms.tpl" as forms %}
{% import "macros/util.tpl" as util %}
<link rel="stylesheet" href="Styles/categories.css" type="text/css" />
<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" name="frmAddCategory" id="frmAddCategory" method="post" class=" form-horizontal">
	{{ hiddenFields|safe }}

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ CatTitle|safe }}</h4>
			<p>{{ CatIntro|safe }}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" />
			<input type="submit" name="addAnother2" value="{{ SaveAndAddAnother|safe }}" class="btn btn-primary" />
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel();" />
			<input id="currentTab" name="currentTab" value="details" type="hidden">
		</div>
	</div>
	<br />

	<div id="div0">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CatDetails' %}</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CatName' %}</label>
					<div class="col-md-10">
						<input type="text" name="catname" id="catname" class="form-control" value="{{ CategoryName|safe }}">
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">URL da Categoria</label>
					<div class="col-md-10">
						<input type="text" name="caturl" id="caturl" class="form-control" value="{{ CategoryUrl|safe }}">
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">Ativar Google Merchant?</label>
					<div class="col-md-10">
						<input {{ DisablegoogleCheckbox|safe }} type="checkbox" name="catenablegoogle" id="catenablegoogle" {{ CheckEnablegoogle|safe }} />
						<label for="catenablegoogle">Sim, habilitar a pesquisa de produtos do Google para esta categoria</label>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">ID Google</label>
					<div class="col-md-10">
						<input type="text" id="catidgoogle" name="catidgoogle" class="form-control" value="{{ CategoryIdGoogle|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CatDesc' %}</label>
					<div class="col-md-10">
						{{ WYSIWYG|safe }}
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CatParentCategory' %}</label>
					<div class="col-md-10">
						<select size="10" name="catparentid" id="catparentid" class="form-control">
							{{ CategoryOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'TemplateLayoutFile' %}</label>
					<div class="col-md-10">
						<select name="catlayoutfile" id="catlayoutfile" class="form-control">
							{{ LayoutFiles|safe }}
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CatSort' %}</label>
					<div class="col-md-10">
						<input type="text" name="catsort" id="catsort" class="form-control" size="5" style="width: 100px;" value="{{ CategorySort|safe }}">
					</div>
				</div>

				<div class="form-group" id='CategoryImageRow' style="display:none">
					<label class="col-md-2 control-label">{% lang 'CatImage' %}</label>
					<div class="col-md-10">
						<input type="file" id="catimagefile" name="catimagefile" class="form-control" {{ DisableFileUpload|safe }} />
						<div id="YesUseImageRow" style="display:{{ ShowYesUseImageRow|safe }}">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" id="YesUseImage" name="YesUseImage" value="1" checked />
								<label for="YesUseImage">{{ CatImageFile|safe }} <span id="PreviewCatImage"> - <a title="{% lang 'PreviewCatImage' %}" href="{{ CatImageLink|safe }}" target="_blank">{% lang 'Preview' %}</a></span></label>
			                </div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SearchEngineOptimization' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label class="col-md-4 control-label">{% lang 'PageTitle' %}</label>
							<div class="col-md-8">
								<input type="text" id="catpagetitle" name="catpagetitle" class="form-control" value="{{ CategoryPageTitle|safe }}" />
							</div>
						</div>
                    </div>

                    <div class="col-md-6">
						<div class="form-group">
							<label class="col-md-4 control-label">{% lang 'MetaKeywords' %}</label>
							<div class="col-md-8">
								<input type="text" id="catmetakeywords" name="catmetakeywords" class="form-control" value="{{ CategoryMetaKeywords|safe }}" />
							</div>
						</div>
                    </div>
                </div>

				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<label class="col-md-4 control-label">{% lang 'MetaDescription' %}</label>
							<div class="col-md-8">
								<input type="text" id="catmetadesc" name="catmetadesc" class="form-control" value="{{ CategoryMetaDesc|safe }}" />
							</div>
						</div>
                    </div>

                    <div class="col-md-6">
						<div class="form-group">
							<label class="col-md-4 control-label">{% lang 'SearchKeywords' %}</label>
							<div class="col-md-8">
								<input type="text" id="catsearchkeywords" name="catsearchkeywords" class="form-control" value="{{ CategorySearchKeywords|safe }}">
							</div>
						</div>
                    </div>
                </div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'SaveAndExit' %}" class="btn btn-primary" />
			<input type="submit" name="addAnother2" value="{{ SaveAndAddAnother|safe }}" class="btn btn-primary" />
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel();" />
			<input id="currentTab" name="currentTab" value="details" type="hidden">
		</div>
	</div>
</form>

{% include 'category.select.modal.tpl' %}
<script type="text/javascript" src="script/category.selector.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="script/categories.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="../javascript/jquery/plugins/jstree/jquery.jstree.js?{{ JSCacheToken }}"></script>

<script type="text/javascript">
	$.extend(lang, {
		CancelMessage		: "{{ CancelMessage|safe }}",
		NoCategoryName		: "{% jslang 'NoCategoryName' %}",
		NoParentCategory	: "{% jslang 'NoParentCategory' %}",
		NoCatSortOrder		: "{% jslang 'NoCatSortOrder' %}",
		ChooseValidImage	: "{% jslang 'ChooseValidImage' %}",
		CollapseCategory	: "{% jslang 'CollapseCategory' %}",
		ExpandCategory		: "{% jslang 'ExpandCategory' %}",
		CategorySelectModalIntro			: "{% jslang 'CategoryMappingModalIntro' %}",
		CategorySelectModalTitle			: "{% jslang 'CategoryMappingModalTitle' %}",
		CategorySelectLeafCategorySelected	: "{% jslang 'CategoryMappingLeafCategorySelected' %}",
		CategorySelectChooseLeafCategory	: "{% jslang 'CategoryMappingChooseLeafCategory' %}",
		ShoppingComparisonCategoryMappings	: "{% jslang 'ShoppingComparisonCategoryMappings' %}",
		ShoppingComparisonCategoryMappingsDesc : "{% jslang 'ShoppingComparisonCategoryMappingsDesc' %}",
		ChooseGooglePsCategory : "{% jslang 'ChooseGooglePsCategory' %}",
		ChooseGooglePsCategoryIntro : "{% jslang 'ChooseGooglePsCategoryIntro' %}",
		CategorySelectLeafCategorySelected : "{% jslang 'CategoryMappingLeafCategorySelected' %}",
		EnterGoogleProductCategory : "{% jslang 'EnterGoogleProductCategory' %}"
	});

	CategoryForm.skipOptimizerConfirmMsg = {{SkipOptimizerConfirmMsg|default('false')|safe}};
	CategoryForm.currentTab = '{{ CurrentTab|safe }}';

	CategoryForm.shoppingComparisonModules = {};

	{% for module in ShoppingComparisonModules %}
		CategoryForm.shoppingComparisonModules["{{ module.getId|js }}"] = {
			name: "{{ module.getName|js }}"
		};
	{% endfor %}
	$(document).ready(function() {

		// Google Products Search
		$("#enableGoogleProductSearch").live("change", function() {
			if ($(this).attr('checked')) {
				$(".gpsField").show();
			}
			else {
				$(".gpsField").hide();
			}
		});

		{% if googlePsEnabled %}
			 $("#enableGoogleProductSearch").attr("checked", true);
		{% endif %}

		$("#enableGoogleProductSearch").change();

		$("#gpsTabShortCut").live("click", function() {
			$("#tab_google_ps").click();
			$("#googlePsCategoryPathReadOnly").click();
		});

		$('#catimagefile').live('change', function() {
			if ($(this).val()) {
				$("#YesUseImageRow").show();
				$("#YesUseImage").attr('checked', true);
				$("#YesUseImage").next().text($(this).val());
			}
			$("#PreviewCatImage").hide();
		});

		{{ category.categoryPicker("parentCategory", parentCategories, false, 'parentCategory-' ~ parentCategoryId, categoryId) }}

		$("#parentCategory").bind("select_node.jstree", function(event, data) {
			var categoryId = data.inst.get_selected().data("id");
			$("#catparentid").val(categoryId);
			$("#catparentid").change();
		});
	});
</script>
<script src="../javascript/speakingurl.min.js"></script>
<script src="../javascript/jquery.stringtoslug.min.js"></script>

<script type="text/javascript">
$(document).ready( function() {
    $("#catname").stringToSlug({
        setEvents: 'keyup keydown blur',
        getPut: '#caturl',
        space: '-',
        prefix: '',
        suffix: '',
        replace: '',
        AND: 'and',
        options: {},
        callback: false
    });
});
</script>