<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'ShippingSettings' %}</h4>
		<p>{% lang 'ShippingSettingsIntro' %}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="margin-bottom: 20px;">
			<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'StoreLocation' %}</a></li>
			<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'ShippingZones' %}</a></li>
			<br class="Clear" />
		</ul>
	</div>
</div>
<div id="div0">
	<form action="index.php?ToDo=saveUpdatedShippingSettings" name="frmShippingSettings" id="frmShippingSettings" method="post" onsubmit="return ValidateForm(CheckShippingSettingsForm)"class="form-horizontal">
		<input id="currentTab" name="currentTab" value="{{ CurrentTab|safe }}" type="hidden">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Endere&ccedil;o da Empresa</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyName' %}</label>
					<div class="col-md-10">
						<input type="text" name="companyname" id="companyname" value="{{ CompanyName|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyAddress' %}</label>
					<div class="col-md-10">
						<input type="text" name="companyaddress" id="companyaddress" value="{{ CompanyAddress|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyCity' %}</label>
					<div class="col-md-10">
						<input type="text" name="companycity" id="companycity" value="{{ CompanyCity|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyCountry' %}</label>
					<div class="col-md-10">
						<select name="companycountry" id="companycountry" class="form-control" onchange="GetStates(this, 'companystate', 'companystate1')">
							{{ CountryList|safe }}
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyState' %}</label>
					<div class="col-md-10">
						<div id="statemessage" style="color:gray; display:{{ HideStateNote|safe }}">-- {% lang 'ChooseCountryFirst' %} --</div>
						<select style="display:{{ HideStateList|safe }}" name="companystate" id="companystate" class="form-control">
							{{ StateList|safe }}
						</select>
						<input style="display:{{ HideStateBox|safe }}" type="text" name="companystate1" id="companystate1" class="form-control" value="{{ CompanyState|safe }}" />
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CompanyZip' %}</label>
					<div class="col-md-10">
						<input type="text" name="companyzip" id="companyzip" value="{{ CompanyZip|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">
				<input class="FormButton SaveButton btn btn-primary" type="submit" value="{% lang 'Save' %}">
				<input type="reset" value="{% lang 'Cancel' %}" class="FormButton CancelButton btn btn-default" />
			</div>
		</div>
	</form>
</div>

<div id="div1">
	{{ NoZonesMessage|safe }}
	<p style="padding-bottom: 0; margin-bottom: 10px; margin-top: 10px;">
		<input type="button" name="ZoneAddButton" value="{% lang 'AddShippingZoneButton' %}" class="SmallButton btn btn-success" onclick="document.location.href='index.php?ToDo=addShippingZone';" />
		<input type="button" name="ZoneDeleteButton" value="{% lang 'DeleteSelected' %}" class="SmallButton btn btn-danger" onclick="ConfirmDeleteSelected();" {{ DisableDelete|safe }} />
	</p>
	
	<div class="GridContainer">
		{{ ZoneDataGrid|safe }}
	</div>
</div>

	<script type="text/javascript">
		var selDest = null;
		var otherBox = null;

		function ShowTab(T)
		{
			i = 0;
			while (document.getElementById("tab" + i) != null) {
				document.getElementById("div" + i).style.display = "none";
				document.getElementById("tab" + i).className = "";
				i++;
			}

			document.getElementById("div" + T).style.display = "";
			document.getElementById("tab" + T).className = "active";
			document.getElementById("currentTab").value = T;
		}

		function GetStates(selObj, dest, stateTextBox)
		{
			var country = selObj.options[selObj.selectedIndex].value;
			var statemessage = document.getElementById("statemessage");

			selDest = document.getElementById(dest);
			otherBox = document.getElementById(stateTextBox);
			statemessage.style.display = "none";

			if(country == "")
			{
				ResetStates(false);
				selObj.focus();
			}
			else
			{
				// Get all of the states for this country
				//dataMode = 1;
				DoCallback("w=countryStates&c="+country);
			}
		}

		function ResetStates(ShowChoose)
		{
			selDest.options.length = 0;

			if(ShowChoose)
				selDest.options[selDest.options.length] = new Option("{% lang 'ChooseState' %}", "");
		}

		function ProcessData(html)
		{
			ResetStates(true);
			states = html.split("~");
			numStates = 0;

			for(i = 0; i < states.length; i++)
			{
				vals = states[i].split("|");

				if(states[i].length > 0) {
					selDest.options[selDest.options.length] = new Option(vals[0], vals[1]);
					numStates++;
				}
			}

			// If there are no states then hide the state dropdown list
			if(numStates == 0) {
				selDest.style.display = "none";
				otherBox.style.display = "";
			}
			else {
				selDest.style.display = "";
				otherBox.style.display = "none";
			}
		}

		function ConfirmCancel()
		{	
			if(confirm("{% lang 'ConfirmCancelShippingSettings' %}")) {
				document.location.href = "index.php?ToDo=viewShippingSettings";
			}
		}

		function CheckShippingSettingsForm() {
			var companyname = g("companyname");
			var companyaddress = g("companyaddress");
			var companycity = g("companycity");
			var companycountry = g("companycountry");
			var companystate = g("companystate");
			var companystate1 = g("companystate1");
			var companyzip = g("companyzip");

			if(companyname.value == "") {
				ShowTab(0);
				alert("{% lang 'EnterCompanyName' %}");
				companyname.focus();
				return false;
			}

			if(companyaddress.value == "") {
				ShowTab(0);
				alert("{% lang 'EnterCompanyAddress' %}");
				companyaddress.focus();
				return false;
			}

			if(companycity.value == "") {
				ShowTab(0);
				alert("{% lang 'EnterCompanyCity' %}");
				companycity.focus();
				return false;
			}

			if(companycountry.selectedIndex == 0) {
				ShowTab(0);
				alert("{% lang 'SelectCompanyCountry' %}");
				companycountry.focus();
				return false;
			}

			if( (companystate.style.display == "" && companystate.selectedIndex == 0) || (companystate1.style.display == "" && companystate1.value == "") || (companystate.style.display == "none" && companystate1.style.display == "none") ) {
				ShowTab(0);
				alert("{% lang 'SelectEnterCompanyState' %}");
				return false;
			}

			if(companyzip.value == "") {
				ShowTab(0);
				alert("{% lang 'EnterCompanyZip' %}");
				companyzip.focus();
				return false;
			}

			return true;
		}

		function ConfirmDeleteSelected()
		{
			if(!$('.GridContainer input[type=checkbox].check:checked').length) {
				alert('{% lang 'SelectOneMoreZonesDelete' %}');
				return false;
			}
			if(confirm('{% lang 'ConfirmDeleteZones' %}')) {
				$('#frmShippingSettings').attr('action', 'index.php?ToDo=deleteShippingZones');
				$('#frmShippingSettings').attr('onsubmit', function() { return true});
				$('#frmShippingSettings').submit();
			}
			else {
				return false;
			}
		}

		function ConfirmDeleteZone() {
			if(confirm('{% lang 'ConfirmDeleteZone' %}')) {
				return true;
			}

			return false;
		}

		// Load the main shipping settings tab by default
		ShowTab({{ CurrentTab|safe }});
	</script>
