<form action="index.php?ToDo=saveUpdatedGiftCertificateSettings" name="frmGiftCertificateSettings" id="frmGiftCertificateSettings" method="post" onsubmit="return ValidateForm(CheckGiftCertificateSettingsForm)">
	{% if ManageGiftCertificateTemplatesNotice %}
	<div class="alert alert-info" style="">{{ ManageGiftCertificateTemplatesNotice|safe }}</div>
	{% endif %}
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'GiftCertificateSettings' %}</h4>
			<p>{% lang 'GiftCertificateSettingsIntro' %}</p>
			<div id="CustomerStatus">{{ Message|safe }}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Search' %}" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"><h3 class="panel-title">{% lang 'GiftCertificateSettings' %}</h3></div>
				<div class="panel-body">
					<div class="form-group">
						<label class="col-md-2 control-label">
							{% lang 'StoreName' %}: 
						</label>
						<div class="col-md-10">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" name="EnableGiftCertificates" id="EnableGiftCertificates" value="1" {{ IsEnableGiftCertificates|safe }} onclick="ToggleGiftCertificatesStatus(this.checked)" />
								<label> {% lang 'YesEnableGiftCertificates' %}</label>
							</div>
						</div>
					</div>

					<div class="form-group HideOnDisabled">
						<label class="col-md-2 control-label">
							{% lang 'GiftCertificateAmounts' %}: 
						</label>
						<div class="col-md-10">
							<div class="radio radio-primary">
								<input type="radio" name="GiftCertificateCustomAmounts" id="GiftCertificateCustomAmountsNo"  onclick="$('#AmountsSelect').show();  $('#AmountsRange').hide();" value="0" {{ IsGiftCertificateSelectAmounts|safe }} />
								<label> {% lang 'GiftCertificateSelectAmounts' %}</label>
							</div>

							<div id="AmountsSelect" style="display: {{ HideSelectAmounts|safe }}">
								<textarea name="GiftCertificateAmounts" id="GiftCertificateAmounts" class="form-control" rows="6">{{ GiftCertificateAmountsArea|safe }}</textarea>
							</div>

							<div class="radio radio-primary">
								<input type="radio" onclick="$('#AmountsSelect').hide(); $('#AmountsRange').show();" name="GiftCertificateCustomAmounts" id="GiftCertificateCustomAmounts" value="1" {{ IsGiftCertificateCustomAmounts|safe }} />
								<label>{% lang 'GiftCertificateCustomAmounts' %}</label>
							</div>

							<div id="AmountsRange" style="display: {{ HideCustomAmounts|safe }}">
								{% lang 'GiftCertificateMinAmount' %} {{ CurrencyTokenLeft|safe }} 
								<input type="text" name="GiftCertificateMinimum" id="GiftCertificateMinimum" value="{{ GiftCertificateMinimum|safe }}" class="form-control" style="width: auto; display: inline;" /> {{ CurrencyTokenRight|safe }}
								
								{% lang 'GiftCertificateMaxAmount' %} {{ CurrencyTokenLeft|safe }} 
								<input type="text" name="GiftCertificateMaximum" id="GiftCertificateMaximum" value="{{ GiftCertificateMaximum|safe }}" class="form-control" style="width: auto; display: inline;" /> {{ CurrencyTokenRight|safe }}
							</div>
						</div>
					</div>

					<div class="form-group HideOnDisabled">
						<label class="col-md-2 control-label">
							{% lang 'GiftCertificateExpiry' %}: 
						</label>
						<div class="col-md-10">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" name="EnableGiftCertificateExpiry" id="EnableGiftCertificateExpiry" value="1" onclick="if(this.checked == true) { $('#EnableExpiryOptions').show(); } else { $('#EnableExpiryOptions').hide(); }" {{ IsGiftCertificateExpiry|safe }} />
								<label> {% lang 'YesEnableGiftCertificateExpiry' %}</label>
							</div>

							<div id="EnableExpiryOptions">
								<label>{% lang 'GiftCertificateExpiryOptions' %}</label>
								<input type="text" name="GiftCertificateExpiry" id="GiftCertificateExpiry" value="{{ ExpiresAfter|safe }}" class="form-control" style="display: inline; width: auto" />
								
								<select name="GiftCertificateExpiryRange" id="GiftCertificateExpiryRange" class="form-control" style="display: inline; width: auto">
									<option value="days">{% lang 'RangeDays' %}</option>
									<option value="weeks" {{ RangWeeksSelected|safe }}>{% lang 'RangeWeeks' %}</option>
									<option value="months" {{ RangeMonthsSelected|safe }}>{% lang 'RangeMonths' %}</option>
									<option value="years" {{ RangeYearsSelected|safe }}>{% lang 'RangeYears' %}</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Search' %}" class="btn btn-primary" />
			<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>

<script type="text/javascript">
	function ConfirmCancel() {
		if(confirm('{% lang 'ConfirmCancelSettings' %}')) {
			document.location.href='index.php?ToDo=viewGiftCertificateSettings';
		} else {
			return false;
		}
	}

	function CheckGiftCertificateSettingsForm() {
		if($('enablereturns').get().checked == true && $('#returnreasons').val() == "") {
			alert('{% lang 'EnterReturnReason' %}');
			$('#returnreasons').focus();
			$('#returnreasons').select();
			return false;
		}

		return true;
	}

	function ToggleGiftCertificateCustomAmounts(status) {
		if(status == true) {
			$('#EnableCustomAmountOptions').show();
		} else {
			$('#EnableCustomAmountOptions').hide();
		}
	}

	function ToggleGiftCertificatesStatus(status) {
		if(status == true) {
			$('.HideOnDisabled').show();
		} else {
			$('.HideOnDisabled').hide();
		}
	}

	function UpdateGiftCertificatePreview(id, name) {
		if(g('ThemePreview_'+id)) {
			$('#ThemePreview img').hide();
			$('#ThemePreview #ThemePreview_'+id).show();
			$('#ThemePreview div').html('{% lang 'GiftCertificateViewingPreview' %}'.replace('%s', name));
		} else {
			$('#ThemePreview img').hide();
			$('#ThemePreview .NoPreview').show();
			$('#ThemePreview div').html('');
		}
	}

	$(document).ready(function() {
		if ($('#EnableGiftCertificates').attr('checked') == true) {
			$('.HideOnDisabled').show();
		} else {
			$('.HideOnDisabled').hide();
		}

		if ($('#EnableGiftCertificateExpiry').attr('checked') == true) {
			$('#EnableExpiryOptions').show();
		} else {
			$('#EnableExpiryOptions').hide();
		}
	});
</script>