{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}
<div id="content">
	<form action="index.php?ToDo=saveCommentSystemSettings" method="post" id="commentSystemForm" accept-charset="utf-8">
		<input type="hidden" name="currentTab" id="currentTab" value="{{ currentTab }}" />
		<div class="row">
			<div class="col-sm-12">
				<h4 class="page-title">{% lang 'CommentSettings' %}</h4>
				<p>{% lang 'CommentSettingsIntro' %}</p>
				{{ Message|safe}}
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">
				<input type="submit" value="{{ lang.Save }}" class="btn btn-primary" />
			</div>
		</div>
		<br>

		<div id="tabs" class="tabs">
			{{ util.tabs(tabs) }}
		</div>

		<div class="tabContent" id="general">
			{{ formBuilder.startForm }}
			{{ formBuilder.heading(lang.ChooseCommentSystem) }}
			<div class="panel-body">
			{{ formBuilder.startRow(['label': lang.UseCommentSystem, 'required': true]) }}
			<div id="commentSystemList" class="ISSelect form-control" style="height: 80px;">
				{% for system in commentSystems %}
				<label><input type="radio" name="commentSystem" value="{{ system.value }}" {% if system.selected %}checked="checked"{% endif %}/>{{ system.label }}</label>
				{% endfor %}
			</div>
			{{ formBuilder.endRow }}
			</div>
			{{ formBuilder.endForm }}
		</div>
		{{ moduleTabContent|safe }}

		<div class="row">
			<div class="col-sm-12">
				<input type="submit" value="{{ lang.Save }}" class="btn btn-primary" />
			</div>
		</div>
	</form>

	<script type="text/javascript">
		$(document).ready(function() {
			$('#tabs').tabs({
				select: function(event, ui){
					$('#currentTab').val(ui.panel.id);
				}
			});

			{% if currentTab %}$('#tabs').tabs('select', '{{ currentTab|js }}');{% endif %}

			$("#cancelComments").click(function() {
				if(confirm('{% lang 'ConfirmCancel' %}')) {
					window.location = 'index.php?ToDo=viewCommentSystemSettings';
				}
			});
		});
	</script>
</div>