<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang '301Redirects' %}</h4>
		<p>{% lang 'RedirectsIntro' %}</p>
		<p id="TemplateMsgBox">{{ Message|safe }}</p>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" id="AddNewRedirectButton" value="{% lang 'AddNewRedirect' %}" class="btn btn-primary" />
		<input type="button" id="DeleteSelectedRedirects" value="{% lang 'DeleteSelected' %}" class="btn btn-danger" /> 
		<input type="button" id="BulkImportRedirects" value="{% lang 'BulkImportRedirects' %}" class="btn btn-primary" />
	</div>
</div>
<br />

<div class="row">
	<div class="col-sm-12">
		<div class="alert alert-warning" style="display: none;" id="NoRedirects">
			{% lang 'NoRedirects' %}
		</div>

		<form method="post" action="index.php?ToDo=startExport&t=redirects&tempId=4" id="frmRedirects" onsubmit="return false;">
			<div id="RedirectsTable"></div>
		</form>
	</div>
</div>
<script type="text/javascript" src="script/redirects.js?{{ JSCacheToken|safe }}"></script>
<script type="text/javascript" src="script/linker.js?{{ JSCacheToken|safe }}"></script>
<script type="text/javascript">
	lang.SelectRedirectsToDelete = "{% lang 'SelectRedirectsToDelete' %}";
	lang.NoBulkImportFile = "{% lang 'NoBulkImportFile' %}";
	lang.EnterAnOldUrl = "{% lang 'EnterAnOldUrl' %}";
	lang.ConfirmDeleteSelected = "{% lang 'ConfirmDeleteSelected' %}";
	lang.ConfirmDeleteRedirect = "{% lang 'ConfirmDeleteRedirect' %}";
	lang.ClickHereToEnterAURL = "{% lang 'ClickHereToEnterAURL' %}";
	lang.ChangeLink = "{% lang 'ChangeLink' %}";
	$(document).ready(function() {
		Redirects.LoadTable();
		$('.linkerButton').live('click', function(event){
			event.preventDefault();
			StoreLinker.openModal(this.id.replace('linkerButton_', ''));
		});
	});
</script>