<form action="index.php?ToDo={{ FormAction|safe }}" id="frmWrap" method="post" onsubmit="return ValidateForm(CheckWrapForm)" enctype="multipart/form-data">
	<input type="hidden" name="wrapId" id="wrapId" value="{{ WrapId|safe }}" />
	<input type="hidden" name="currentTab" value="{{ CurrentTab|safe }}" id="currentTab" />

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="btn btn-primary" />&nbsp;
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br>

	<div class="panel panel-default">
		<div class="panel-heading"> 
			<h3 class="panel-title">{% lang 'GiftWrapSettings' %}</h3> 
		</div>

		<div class="panel-body">
			<div class="form-group row">
				<label class="col-md-2 control-label">
					{% lang 'WrapName' %}: 
				</label>
				<div class="col-md-10">
					<input type="text" name="wrapname" id="wrapname" class="form-control" value="{{ WrapName|safe }}" />
				</div>
			</div>

			<div class="form-group row">
				<label class="col-md-2 control-label">
					{% lang 'WrapImage' %}: 
				</label>
				<div class="col-md-10">
					<input type="file" name="wrapimage" id="wrapimage" class="form-control" />

					<span style="{{ HideCurrentWrapImage|safe }}">
						Atual: <a href="../{{ ImageDirectory|safe }}/{{ WrapImage|safe }}" target="_blank">{{ WrapImage|safe }}</a>
					</span>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-md-2 control-label">
					{% lang 'WrapPrice' %}: 
				</label>
				<div class="col-md-10">
					<input type="text" name="wrapprice" id="wrapprice" class="form-control" value="{{ GiftWrapPrice|safe }}" />
				</div>
			</div>

			<div class="form-group row">
				<label class="col-md-2 control-label">
					{% lang 'WrapGiftMessage' %}?:
				</label>
				<div class="col-md-10">
					<label><input type="checkbox" name="wrapallowcomments" value="1" id="wrapgiftmessage" {{ GiftWrapAllowCommentsChecked|safe }} /> {% lang 'YesAllowWrapGiftMessage' %}</label>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-md-2 control-label">
					{% lang 'Visible' %}?:
				</label>
				<div class="col-md-10">
					<label><input type="checkbox" name="wrapvisible" value="1" id="wrapvisible" {{ GiftWrapVisibleChecked|safe }} /> {% lang 'YesWrapVisible' %}</label>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="btn btn-primary" />&nbsp;
			<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>
<script type="text/javascript">
	function CheckWrapForm() {
		if(!$('#wrapname').val()) {
			alert('{% lang 'EnterWrapName' %}');
			$('#wrapname').focus();
			return false;
		}

		var price = $('#wrapprice');
		if(isNaN(priceFormat(price.val())) || price.val() == '') {
			alert('{% lang 'EnterWrapPrice' %}');
			price.focus();
			price.select();
			return false;
		}

		return true;
	}

	function ConfirmCancel() {
		if(confirm('{% lang 'ConfirmCancel' %}')) {
			document.location.href='index.php?ToDo=viewGiftWrapping';
		} else {
			return false;
		}
	}
</script>