<form enctype="multipart/form-data" action="index.php" id="frmSearch" method="get" onsubmit="return ValidateForm(CheckSearchForm)">
	<input type="hidden" name="ToDo" value="searchCustomersRedirect" />
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'SearchCustomers' %}</h4>
			<p>{% lang 'SearchCustomersIntro' %}</p>
			<div id="CustomerStatus">{{ Message|safe }}</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Search' %}" class="btn btn-primary" />
		</div>
	</div>
	<br />

	<div class="row">
		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'AdvancedSearch' %}</h3></div>
			<div class="panel-body">
				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'SearchKeywords' %}</label>
					<input class="form-control" name="searchQuery" id="searchQuery" placeholder="{% lang 'SearchKeywords' %}">
				</div>

				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'CustPhone' %}</label>
					<input class="form-control" id="phone" name="phone" placeholder="{% lang 'SearchKeywords' %}">
				</div>

				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'CustCountry' %}</label>
					<select name="country" id="country" class="form-control" onchange="GetStates(this, 'state', 'state_1')">
						<option value="">{% lang 'ChooseCustCountry' %}</option>
						{{ CountryList|safe }}
					</select>
				</div>

				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'CustState' %}</label>
					<select style="display:{{ HideStateList|safe }}" name="state" id="state" class="form-control">
						{{ StateList|safe }}
					</select>
					<input style="display:{{ HideStateBox|safe }}" type="text" name="state_1" id="state_1" value="{{ AddressState|safe }}" class="form-control" />
				</div>

            </div>
        </div>
    </div>

    <div class="row">
		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'SearchByDate' %}</h3></div>
			<div class="panel-body">
				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'DateJoined' %}</label>
					<select name="dateRange" id="dateRange" onchange="ToggleRange()" class="form-control">
						<option value="">{% lang 'ChooseRegDate' %}</option>
						<option value="today">{% lang 'Today' %}</option>
						<option value="yesterday">{% lang 'Yesterday' %}</option>
						<option value="day">{% lang 'Last24Hours' %}</option>
						<option value="week">{% lang 'Last7Days' %}</option>
						<option value="month">{% lang 'Last30Days' %}</option>
						<option value="this_month">{% lang 'ThisMonth' %}</option>
						<option value="this_year">{% lang 'ThisYear' %}</option>
						<option value="custom">{% lang 'CustomPeriod' %}</option>
					</select>

					<div id="dateRangeCustom" style="margin-left: 30px; margin-top: 10px;">
						{% lang 'SearchFrom' %} <input class="plain" name="fromDate" id="dc1" size="12" onfocus="this.blur()" readonly><a href="javascript:void(0)" onclick="if(self.gfPop)gfPop.fStartPop(document.getElementById('dc1'),document.getElementById('dc2'));return false;" HIDEFOCUS><img name="popcal" align="absmiddle" src="images/calbtn.gif" width="34" height="22" border="0" alt=""></a>
						{% lang 'SearchTo' %} <input class="plain" name="toDate" id="dc2" size="12" onfocus="this.blur()" readonly><a href="javascript:void(0)" onclick="if(self.gfPop)gfPop.fEndPop(document.getElementById('dc1'),document.getElementById('dc2'));return false;" HIDEFOCUS><img name="popcal" align="absmiddle" src="images/calbtn.gif" width="34" height="22" border="0" alt=""></a>
					</div>
				</div>
			</div>
		</div>
	</div>

    <div class="row" style="display: {{ HideCustomerGroups|safe }}">
		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'SearchByGroup' %}</h3></div>
			<div class="panel-body">
				<div class="form-group">
					<label for="StoreName" class="control-label">{% lang 'CustomerGroup' %}</label>
					<select name="custGroupId" id="custGroupId" class="form-control">
						<option value="">{% lang 'ChooseACustomerGroup' %}</option>
						{{ CustomerGroups|safe }}
					</select>
				</div>
			</div>
		</div>
	</div>

    <div class="row">
		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'SortOrder' %}</h3></div>
			<div class="panel-body">
				<div class="form-group">
					<select name="sortField" class="form-control">
						<option value="customerid">{% lang 'CustID' %}</option>
						<option value="custconlastname">{% lang 'CustLastName' %}</option>
						<option value="custconfirstname">{% lang 'CustFirstName' %}</option>
						<option value="custconemail">{% lang 'Email' %}</option>
						<option value="custconphone">{% lang 'Phone' %}</option>
						<option value="custconcompany">{% lang 'CustCompany' %}</option>
						<option value="custdatejoined">{% lang 'CustDateCreated' %}</option>
						<option value="numorders">{% lang 'NumOrders' %}</option>
					</select>
				</div>

				<div class="form-group">
					<select name="sortOrder" class="form-control">
						<option value="asc">{% lang 'AscendingOrder' %}</option>
						<option value="desc">{% lang 'DescendingOrder' %}</option>
					</select>
				</div>
			</div>
		</div>
	</div>

	<iframe width=132 height=142 name="gToday:contrast:agenda.js" id="gToday:contrast:agenda.js" src="calendar/ipopeng.htm" scrolling="no" frameborder="0" style="visibility:visible; z-index:999; position:absolute; left:-500px; top:0px;"></iframe>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" value="{% lang 'Search' %}" class="btn btn-primary" />
		</div>
	</div>
</form>

	<script type="text/javascript" src="{{ ShopPath|safe }}/javascript/callback.js"></script>

	<script type="text/javascript">
		function GetStates(selObj, dest, stateTextBox)
		{
			var country = selObj.options[selObj.selectedIndex].value;

			selDest = document.getElementById(dest);
			otherBox = document.getElementById(stateTextBox);
			DoCallback("w=countryStates&c="+country);
		}

		function ResetStates(ShowChoose)
		{
			selDest.options.length = 0;

			if(ShowChoose)
				selDest.options[selDest.options.length] = new Option("{% lang 'ChooseState' %}", "");
		}

		function ProcessData(html)
		{
			ResetStates(true);
			states = html.split("~");
			numStates = 0;

			for(i = 0; i < states.length; i++)
			{
				vals = states[i].split("|");

				if(states[i].length > 0) {
					selDest.options[selDest.options.length] = new Option(vals[0], vals[1]);
					numStates++;
				}
			}

			// If there are no states then hide the state dropdown list
			if(numStates == 0) {
				selDest.style.display = "none";
				otherBox.style.display = "";
			}
			else {
				selDest.style.display = "";
				otherBox.style.display = "none";
			}
		}

		function ToggleRange()
		{
			var range = document.getElementById('dateRange');
			if(range.options[range.selectedIndex].value == "custom")
			{
				document.getElementById('dateRangeCustom').style.display = '';
			}
			else
			{
				document.getElementById('dateRangeCustom').style.display = 'none';
			}
		}

		ToggleRange();

		function ConfirmCancel() {
			if(confirm("{% lang 'ConfirmCancelSearch' %}"))
				document.location.href = "index.php?ToDo=viewCustomers";
		}

		function CheckSearchForm() {
			var ordersFrom = document.getElementById("ordersFrom");
			var ordersTo = document.getElementById("ordersTo");

			if(ordersFrom.value != "" && isNaN(ordersFrom.value)) {
				alert("{% lang 'SearchEnterValidordersId' %}");
				ordersFrom.focus();
				ordersFrom.select();
				return false;
			}

			if(ordersTo.value != "" && isNaN(ordersTo.value)) {
				alert("{% lang 'SearchEnterValidordersId' %}");
				ordersTo.focus();
				ordersTo.select();
				return false;
			}

			var storeCreditFrom = document.getElementById("storeCreditFrom");
			var storeCreditTo = document.getElementById("storeCreditTo");

			if(storeCreditFrom.value != "" && isNaN(priceFormat(storeCreditFrom.value))) {
				alert("{% lang 'SearchEnterValidStoreCredit' %}");
				storeCreditFrom.focus();
				storeCreditFrom.select();
				return false;
			}

			if(storeCreditTo.value != "" && isNaN(priceFormat(storeCreditTo.value))) {
				alert("{% lang 'SearchEnterValidStoreCredit' %}");
				storeCreditTo.focus();
				storeCreditTo.select();
				return false;
			}

			return true;
		}

	</script>
