<form action="index.php?ToDo={{ FormAction|safe }}" method="post" onsubmit="return ValidateForm(CheckMethodForm)" class="form-horizontal">
	<input type="hidden" name="methodId" id="methodId" value="{{ MethodId|safe }}" />
	<input type="hidden" name="zoneId" id="zoneId" value="{{ ZoneId|safe }}" />
	<input type="hidden" name="currentTab" value="{{ CurrentTab|safe }}" id="currentTab" />

	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{{ Title|safe }}</h4>
			<p>{{ Intro|safe }}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'ShippingMethodSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'ShippingMethod' %}</label>
					<div class="col-md-10">
						<div>{{ MethodBasedOn|safe }}</div>
						<div style="{{ HideModuleSelect|safe }}">
							<select name="methodmodule" id="methodmodule" class="form-control" size="10" onchange="UpdateModule($(this).val());">
							{{ ShippingProviders|safe }}
							</select>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'DisplayName' %}</label>
					<div class="col-md-10">
						<input type="text" onkeypress="updateUsingDefault();" name="methodname" id="methodname" class="form-control" value="{{ MethodName|safe }}" required />
						<div id="HandlingSettings" style="{{ HideHandlingFee|safe }}">
							<div class="input-group m-t-10 col-sm-8">
			                   	<span class="input-group-addon">Taxa de manuseio em R$</span>
			                    <input type="text" name="methodhandlingfee" id="methodhandlingfee" class="form-control" value="{{ HandlingFee|safe }}" />
			                </div>
			            </div>

					</div>
				</div>

				<div class="form-group" style="{{ HideZoneEnabled|safe }}">
					<label class="col-md-2 control-label">{% lang 'EnableShippingMethod' %}</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="methodenabled" id="methodenbled" {{ MethodEnabledCheck|safe }} />
	                        <label for="methodenbled">{% lang 'YesEnableShippingMethod' %}</label>
	                    </div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div id="shippingMethodSettings">
			{{ ShippingModuleProperties|safe }}
		</div>
	</div>
	
	<input type="submit" value="{% lang 'Save' %}" class="FormButton btn btn-primary" />
	<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
</form>
<script type="text/javascript">
	var usingDefault = 1;

	function updateUsingDefault()
	{
		usingDefault = 0;
	}

	function ConfirmCancel()
	{
		if(confirm('{% lang 'ConfirmCancel' %}')) {
			window.location = 'index.php?ToDo=editShippingZone&zoneId={{ ZoneId|safe }}&currentTab=1';
		}
	}

function CheckMethodForm()
{
	if(!$('#methodId').val() && !$('#methodmodule').val()) {
		alert('{% lang 'SelectShippingMethod' %}');
		$('#methodmodule').focus();
		return false;
	}

	if(!$('#methodname').val()) {
		alert('{% lang 'EnterShippingMethodName' %}');
		$('#methodname').focus();
		return false;
	}

	if($('#HandlingSettings').css('display') != 'none') {
		if(isNaN(priceFormat($('#methodhandlingfee')))) {
			alert('{% lang 'EnterValidHandlingFee' %}');
			$('#methodhandlingfee').select();
			return;
		}
	}

	if(typeof(ShipperValidation) != 'undefined' && ShipperValidation() == false) {
		return false;
	}

	return true;
}

{{ ShippingProviderErrors|safe }}

function UpdateModule(module) {
	if(module == '' || module == null) {
		$('#chooseMethodFirst').show();
		$('#shippingMethodSettings *').remove();
		return;
	}

	// Is there a reason why this zone cannot be enabled?
	if(typeof(eval('providerErrors.'+module)) != 'undefined') {
		var errors = eval('providerErrors.'+module);
		alert(errors);
		$('#methodmodule').val('');
		return false;
	}

	$.ajax({
		url: 'remote.php',
		method: 'post',
		data: 'w=GetShippingModuleProperties&module='+module,
		success: function(data) {
			$('#shippingMethodSettings').html(data);
			$('#chooseMethodFirst').hide();
			ISSelectReplacement.on_load();
			if(usingDefault == 1) {
				$('#methodname').val($('#shippingMethodSettings #moduleName').html());
			}
		}
	});
}
</script>