<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{{ ViewName|safe }}</h4>
		<p>{% lang 'ShipmentsIntro' %}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" value="{% lang 'DeleteSelected' %}" onclick="return Shipments.DeleteSelected();" class="btn btn-danger" {{ DisableDelete|safe }} />
		<input type="button" value="Exportar" onclick="Shipments.Export()" class="btn btn-success" {{ DisableExport|safe }} />
	</div>
</div>
<br />

<div class="row">
	<div class="col-sm-12">
		<form method="post" id="shipmentsForm" action="index.php?ToDo=deleteShipments">
			<div class="GridContainer" id="GridContainer">
				{{ ShipmentDataGrid|safe }}
			</div>
		</form>
	</div>
</div>

<!-- Begin Export Shipments Box -->
<div id="exportBox" style="display: none">
	<div class="ModalTitle">
		{% lang 'Export' %} {{ ViewName|safe }}
	</div>
	<div class="ModalContent">
		<p>{% lang 'ExportThickBoxIntro' %}</p>
		<p>{% lang 'ChooseAFileFormat' %}</p>

		<table border="0">
			<tr>
				<td><img width="16" height="16" hspace="5" src="images/exportCsv.gif" /></td>
				<td><a onclick="$.modal.close()" href="index.php?ToDo=exportShipments&amp;format=csv{{ SortURL|safe }}" style="color:#005FA3; font-weight:bold">{% lang 'ExportCSV' %}</a></td>
			</tr>
			<tr>
				<td><img width="16" height="16" hspace="5" src="images/exportXml.gif" /></td>
				<td><a onclick="$.modal.close()" href="index.php?ToDo=exportShipments&amp;format=xml{{ SortURL|safe }}" style="color:#005FA3; font-weight:bold">{% lang 'ExportXML' %}</a></td>
			</tr>
		</table>
	</div>
	<div class="ModalButtonRow">
		<input type="button" class="Submit" value="{% lang 'Cancel' %}" onclick="$.modal.close()" />
	</div>
</div>
<!-- End Export Shipments Box -->

<script type="text/javascript" src="script/shipments.js?{{ JSCacheToken }}"></script>
<script type="text/javascript">
	lang.ConfirmDeleteCustomSearch = '{% lang 'ConfirmDeleteCustomSearch' %}';
	lang.ConfirmDeleteShipments = "{% lang 'ConfirmDeleteShipments' %}";
	lang.SelectOneMoreShipmentsDelete = "{% lang 'SelectOneMoreShipmentsDelete' %}";
</script>