<form method="post" action="#" onsubmit="Order.SaveShipment(); return false;" id="ShipmentDetails">
	<input type="hidden" name="orderId" value="{{ OrderId|safe }}" />
	<input type="hidden" name="addressId" value="{{ address.id }}" />
	<div id="ModalTitle">
		{% lang 'CreateShipmentFromOrder' %} #{{ OrderId|safe }} ({{ OrderDate|safe }})
	</div>
	<div id="ModalContent" style="min-height: 100px;">
		<p class="alert alert-warning">{% lang 'CreateShipmentIntro' %}</p>
		<table class="GridPanel ShipmentTable table table-stripped" cellspacing="0" cellpadding="0">
			<thead>
				<tr>
					<th>{% lang 'ShipmentProduct' %}</th>
					<th style="width: 100px; text-align: center;">{% lang 'QtyToShip' %}</th>
				</tr>
			</thead>

			<tbody>
				{{ ProductList|safe }}
			</tbody>
		</table>
		<br />

		<table cellspacing="5" cellpadding="0" border="0" width="100%" class="table table-stripped">
			<tr>
				<td class="FieldLabel">{% lang 'ShippingMethod' %}:</td>
				<td>
					<div class="row">
						<div class="col-md-6">
							<select name="shipping_module" class="form-control">
								<option value="">{{ lang.xNone }}</option>
								{% for module, name in shippingModules %}
									<option value="{{ module }}" {% if module == shipping.module %}selected="selected"{% endif %}>{{ name }}</option>
								{% endfor %}
							</select>
						</div>

						<div class="col-md-6">
							<input type="text" class="form-control" name="shipmethod" value="{{ shipping.method }}" />
						</div>
					</div>
				</td>
			</tr>

			<tr>
				<td class="FieldLabel">{% lang 'TrackingNumber' %}:</td>
				<td>
					<input type="text" class="form-control" name="shiptrackno" value="{{ TrackingNumber|safe }}" />
				</td>
			</tr>

			<tr>
				<td class="FieldLabel">{% lang 'ShipmentComments' %}:</td>
				<td>
					<textarea name="shipcomments" cols="10" rows="4" class="form-control">{{ OrderComments|safe }}</textarea>
				</td>
			</tr>

			<tr>
				<td class="FieldLabel">{% lang 'OrderStatus' %}:</td>
				<td style="padding-top: 4px;"><label><input type="checkbox" name="ordstatus" value="1" checked="checked" /> {% lang 'UpdateOrderStatus' %}</label></td>
			</tr>
		</table>
	</div>
	<div class="modal-footer"> 
		<div class="FloatLeft"><input class="CloseButton btn btn-default" type="button" value="{% lang 'Close' %}" onclick="$.modal.close();" /></div>
		<img src="images/loading.gif" alt="" style="display: none" class="LoadingIndicator" />
		<input type="submit" class="Submit SubmitButton btn btn-primary" value="{% lang 'CreateShipment' %}" />
	</div>
</form>