<form action="index.php?ToDo=saveUpdatedNotificationSettings" name="frmNotificationSettings" id="frmNotificationSettings" method="post" onsubmit="return ValidateForm(CheckNotificationSettingsForm)">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'NotificationSettings' %}</h4>
			<p>{% lang 'NotificationSettingsIntro' %}</p>
			{{ Message|safe }}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input class="FormButton SaveButton btn btn-primary" type="submit" value="{% lang 'Save' %}">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton CancelButton btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
	<br />
	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs tabs" style="margin-bottom: 20px;">
				<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'GeneralSettings' %}</a></li>
				<li style="display:none"><a href="#" id="tab1" onclick="ShowTab(1)"></a></li>
				{{ NotificationTabs|safe }}
			</ul>
		</div>
	</div>

	<input id="currentTab" name="currentTab" value="0" type="hidden">
	<div id="div0">
		<div class="panel panel-default form-horizontal">
			<div class="panel-heading"> 
				<h3 class="panel-title">Configuraes Gerais</h3> 
			</div> 

			<div class="panel-body"> 
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'NotificationSettings' %}:</label>
					<div class="col-md-10">
						<select size="8" multiple name="notificationproviders[]" id="notificationproviders" class="form-control ISSelectReplacement">
							{{ NotificationProviders|safe }}
						</select>
			        </div>
			    </div>
			</div>
		</div>
	</div>

	<div id="div1"></div>
	{{ NotificationDivs|safe }}

	<div class="row">
		<div class="col-sm-12">
			<input class="FormButton SaveButton btn btn-primary" type="submit" value="{% lang 'Save' %}">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton CancelButton btn btn-default" onclick="ConfirmCancel()" />
		</div>
	</div>
</form>

<script type="text/javascript">

		function ShowTab(T) {
			i = 0;
			while (document.getElementById("tab" + i) != null) {
				document.getElementById("div" + i).style.display = "none";
				document.getElementById("tab" + i).className = "";
				i++;
			}

			document.getElementById("div" + T).style.display = "";
			document.getElementById("tab" + T).className = "active";
			document.getElementById("currentTab").value = T;
		}

		function ConfirmCancel() {
			if(confirm("{% lang 'ConfirmCancelNotificationSettings' %}"))
				document.location.href = "index.php?ToDo=viewNotificationSettings";
		}

		function notification_selected(notification_id) {
			var np = document.getElementById("notificationproviders_old");

			for(i = 0; i < np.options.length; i++) {
				if(np.options[i].value == notification_id && np.options[i].selected)
					return true;
			}

			return false;
		}

		function CheckNotificationSettingsForm() {

			{{ NotificationJavaScript|safe }}
			return true;
		}

		// Load the main notification settings tab by default
		ShowTab({{ CurrentTab|safe }});

	</script>
