{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as form %}
<form enctype="multipart/form-data" action="index.php?ToDo=saveUpdatedSettings" name="frmSettings" id="frmSettings" method="post">
	<input id="currentTab" name="currentTab" value="0" type="hidden" />
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'StoreSettings' %}</h4>
			<p>{% lang 'SettingsIntro' %}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="submit" disabled="disabled" name="IndexCreateButton" value="{% lang 'Save' %}" id="IndexCreateButton" class=" btn btn-primary">
			<input type="reset" onclick="ConfirmCancel()" value="{% lang 'Cancel' %}" class="btn btn-danger">
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-sm-12">
			<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="margin-bottom: 20px;">
				<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'WebsiteSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'LocalizationSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab8" onclick="ShowTab(8)">{% lang 'ImageSettings' %}</a></li>
				<li class="tab"><a href="#" id="tab2" onclick="ShowTab(2)">{% lang 'DisplaySettingsTab' %}</a></li>
				<li class="tab" style="display: {{ HideBackupSettings|safe }}"><a href="#" id="tab3" onclick="ShowTab(3)">{% lang 'BackupSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab4" onclick="ShowTab(4)">{% lang 'SearchSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab5" onclick="ShowTab(5)" style="{{ HideLoggingSettingsTab|safe }}" >{% lang 'LoggingSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab6" onclick="ShowTab(6)" style="{{ HideVendorOptions|safe }}">{% lang 'VendorSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab7" onclick="ShowTab(7)">{% lang 'MiscellaneousSettingsTab' %}</a></li>
				<li class="tab"><a href="#" id="tab9" onclick="ShowTab(9)">{% lang 'Googlemerchant' %}</a></li>
				<br class="Clear" />
			</ul>
		</div>
	</div>

	<div id="div0">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SiteSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">
						{% lang 'StoreName' %}: 
					</label>
					<div class="col-md-10">
						<input type="text" name="StoreName" id="StoreName" value="{{ StoreName|safe }}" class="form-control" />
						<small class="help-block">{% lang 'StoreNameHelp' %}</small>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">
						{% lang 'StoreAddress' %}:
					</label>
					<div class="col-md-10">
						<textarea name="StoreAddress" id="StoreAddress" class="form-control" rows="4">{{ StoreAddress|safe }}</textarea>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">
						{% lang 'AllowPurchasing' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="AllowPurchasing" id="AllowPurchasing" value="ON" {{ IsPurchasingEnabled|safe }} />
							<label for="AllowPurchasing">{% lang 'YesAllowPurchasing' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">
						{% lang 'DownForMaintenance' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="DownForMaintenance" id="DownForMaintenance" value="ON" {{ IsDownForMaintenance|safe }} />
							<label for="DownForMaintenance">{% lang 'YesDownForMaintenance' %}</label>
						</div>

						<div class="form-group" id="DownForMaintenanceMessageRow" style="display:none; ">
							<textarea class="form-control" name="DownForMaintenanceMessage" id="DownForMaintenanceMessage" class="form-control" rows="4">{{ DownForMaintenanceMessage|safe }}</textarea>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SiteSecuritySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">
						{% lang 'UseSSLDuringCheckout' %}?
					</label>
					<div class="col-md-10">
						<div class="form-group">
							<div class="radio radio-primary">
								<input type="radio" name="UseSSL" id="NoSSL" value="0" {{ NoSSLChecked|safe }} />
								<label for="NoSSL">{% lang 'DontUseSSL' %}</label>
							</div>
						</div>

						<div class="form-group">
							<div class="radio radio-primary">
								<input type="radio" name="UseSSL" id="UseNormalSSL" value="1" {{ UseNormalSSLChecked|safe }} />
								<label for="UseNormalSSL">Sim,O Certificado SSL est ativo na Hospedagem</label>
							</div>
						</div>

						<div class="form-group">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" name="ForceControlPanelSSL" id="UseControlPanelSSL" value="ON" {{ IsControlPanelSSLEnabled|safe }} />
								<label for="UseControlPanelSSL">{% lang 'YesUseControlPanelSSL' %}</label>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group row" style="{{ HideStoreUrlField|safe }}">
					<label class="col-md-2 control-label">
						Url da loja:
					</label>
					<div class="col-md-10">
						<input type="text" name="ShopPath" id="ShopPath" value="{{ ShopPathNormal|safe }}" class="form-control" />
						<small class="help-block">Caso tenha selecionado Sim altere o http: para https: </small>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default" style="display:none;">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'AdvancedStoreSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CharacterSet' %}:
					</label>
					<div class="col-md-10">
						<select id="CharacterSet" name="CharacterSet" class="form-control">
							<option value="UTF-8" {{ CharacterSet_Selected_utf8|safe }}>{% lang 'SettingsCharset_utf8' %}</option>
							<option value="ISO-8859-1" {{ CharacterSet_Selected_iso88591|safe }}>{% lang 'SettingsCharset_iso88591' %}</option>
							<option value="ISO-8859-15" {{ CharacterSet_Selected_iso885915|safe }}>{% lang 'SettingsCharset_iso885915' %}</option>
							<option value="cp866" {{ CharacterSet_Selected_cp866|safe }}>{% lang 'SettingsCharset_cp866' %}</option>
							<option value="cp1251" {{ CharacterSet_Selected_cp1251|safe }}>{% lang 'SettingsCharset_cp1251' %}</option>
							<option value="cp1252" {{ CharacterSet_Selected_cp1252|safe }}>{% lang 'SettingsCharset_cp1252' %}</option>
							<option value="KOI8-R" {{ CharacterSet_Selected_koi8r|safe }}>{% lang 'SettingsCharset_koi8r' %}</option>
							<option value="Shift_JIS" {{ CharacterSet_Selected_shiftjis|safe }}>{% lang 'SettingsCharset_shiftjis' %}</option>
							<option value="EUC-JP" {{ CharacterSet_Selected_eucjp|safe }}>{% lang 'SettingsCharset_eucjp' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row" style="display:none;">
					<label class="col-md-2 control-label">
						{% lang 'DownloadDirectory' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DownloadDirectory" id="DownloadDirectory" value="{{ DownloadDirectory|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row" style="display:none;">
					<label class="col-md-2 control-label">
						{% lang 'ImageDirectory' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="ImageDirectory" id="ImageDirectory" value="{{ ImageDirectory|safe }}" class="form-control" />
					</div>
				</div>

				
			</div>
		</div>

		<div class="panel panel-default" style="{{ HideLicenseKey|safe }}">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'LicenseSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'LicenseKey' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="serverStamp" id="serverStamp" value="{{ serverStamp|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						Chave Unica:
					</label>
					<div class="col-md-10">
						<input type="text" name="Chave" id="Chave" value="{{ Chave|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'EmailSettings' %}</h3></div>
			<div class="panel-body">
				<div class="form-group row">
					<label for="AdminEmail" class="col-md-2 control-label">{% lang 'AdminEmail' %}</label>
					<div class="col-md-10">
						<input class="form-control" name="AdminEmail" id="AdminEmail" value="{{ AdminEmail|safe }}">
					</div>
				</div>

				<div class="form-group row">
					<label for="OrderEmail" class="col-md-2 control-label">{% lang 'OrderEmail' %}</label>
					<div class="col-md-10">
						<input class="form-control" name="OrderEmail" id="OrderEmail" value="{{ OrderEmail|safe }}">
					</div>
				</div>

				<div class="form-group">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" name="LowInventoryEmails" id="LowInventoryEmails" onclick="if(this.checked) { $('.LowInventoryNotificationToggle').show(); } else { $('.LowInventoryNotificationToggle').hide(); }" value="1" {{ LowInventoryEmailsEnabledCheck|safe }} />
						<label for="LowInventoryEmails">{% lang 'YesEnableLowInventoryEmails' %}</label>
					</div>
				</div>

				<div class="form-group LowInventoryNotificationToggle" style="display: {{ HideLowInventoryNotification|safe }}">
					<input placeholder="Informe o email" class="form-control" name="LowInventoryNotificationAddress" id="LowInventoryNotificationAddress" value="{{ LowInventoryNotificationAddress|safe }}">
				</div>

				<div class="form-group">
					<div class="checkbox checkbox-primary">
						<input type="checkbox" name="ForwardInvoiceEmailsCheck" id="ForwardInvoiceEmailsCheck" onclick="if(this.checked) { $('.ForwardInvoiceEmailsToggle').show(); } else { $('.ForwardInvoiceEmailsToggle').hide(); }" value="1" {{ ForwardInvoiceEmailsCheck|safe }} />
						<label for="ForwardInvoiceEmailsCheck">{% lang 'YesEnableForwardInvoiceEmails' %}</label>
					</div>
				</div>

				<div class="form-group ForwardInvoiceEmailsToggle" style="display: {{ HideForwardInvoiceEmails|safe }}">
					<input placeholder="Informe o email" class="form-control" name="ForwardInvoiceEmails" id="ForwardInvoiceEmails" value="{{ ForwardInvoiceEmails|safe }}">
				</div>

				<label class="control-label">{% lang 'UseSMTPServer' %}</label>

				<div class="row">
					<div class="col-md-6">
						<div class="form-group">
							<div class="radio radio-primary">
								<input type="radio" name="MailUseSMTP" id="MailUsePHP" value="0" onclick="ToggleMailSettings()" {{ MailUsePHPChecked|safe }} />
								<label for="MailUsePHP">{% lang 'UseDefaultMailSettings' %}</label>
							</div>
						</div>
					</div>

					<div class="col-md-6">
						<div class="form-group">
							<div class="radio radio-primary">
								<input type="radio" name="MailUseSMTP" id="MailUseSMTP" onclick="ToggleMailSettings()" value="1" {{ MailUseSMTPChecked|safe }}  />
								<label for="MailUseSMTP">{% lang 'SpecifyOwnSMTPDetails' %}</label>
							</div>
						</div>
					</div>
				</div>

				<div class="SMTPOptions" style="display: {{ HideMailSMTPSettings|safe }}">
					<div class="form-group">
						<label for="MailSMTPServer" class="control-label">{% lang 'SMTPHostname' %}</label>
						<input type="text" class="form-control smtpSettings" type="text" name="MailSMTPServer" id="MailSMTPServer" value="{{ MailSMTPServer|safe }}">
					</div>

					<div class="form-group">
						<label for="MailSMTPUsername" class="control-label">{% lang 'SMTPUsername' %}</label>
						<input type="text" class="form-control smtpSettings" name="MailSMTPUsername" id="MailSMTPUsername" value="{{ MailSMTPUsername|safe }}">
					</div>

					<div class="form-group">
						<label for="MailSMTPPassword" class="control-label">{% lang 'SMTPPassword' %}</label>
						<input type="password" class="form-control smtpSettings" autocomplete="off" name="MailSMTPPassword" id="MailSMTPPassword" value="{{ MailSMTPPassword|safe }}">
					</div>

					<div class="form-group">
						<label for="MailSMTPPort" class="control-label">{% lang 'SMTPPort' %}</label>
						<input type="text" class="form-control smtpSettings" name="MailSMTPPort" id="MailSMTPPort" value="{{ MailSMTPPort|safe }}">
					</div>

					<input type="button" name="cmdTestSMTP" value="{% lang 'TestSMTPSettings' %}" id="TestSMTPSettings" class="btn btn-primary" onclick="startSMTPTest();" />
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'SearchEngineOptimization' %}</h3></div>
			<div class="panel-body">
				<div class="form-group row">
					<label class="control-label col-md-2" for="HomePagePageTitle">{% lang 'SearchEngineFriendlyURLs' %}:</label>
					<div class="col-md-10">
						<select name="EnableSEOUrls" id="EnableSEOUrls" class="form-control">
							<option value="2" {{ IsEnableSEOUrlsAuto|safe }}>{% lang 'SearchEngineFriendlyURLsAuto' %}</option>
							<option value="1" {{ IsEnableSEOUrlsEnabled|safe }}>{% lang 'SearchEngineFriendlyURLsEnabled' %}</option>
							<option value="0" {{ IsEnableSEOUrlsDisabled|safe }}>{% lang 'SearchEngineFriendlyURLsDisabled' %}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2" for="HomePagePageTitle">{{ lang.RedirectWWW }}:</label>
					<div class="col-md-10">
						<select name="RedirectWWW" id="RedirectWWW" class="form-control">
							<option value="1" {{ RedirectToWWWSelected|safe }}>{{ lang.RedirectToWWW }}</option>
							<option value="2" {{ RedirectToNoWWWSelected|safe }}>{{ lang.RedirectToNoWWW }}</option>
							<option value="0" {{ RedirectNoPreferenceSelected|safe }}>{{ lang.RedirectNoPreference }}</option>
						</select>
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2" for="HomePagePageTitle">{% lang 'HomePagePageTitle' %}</label>
					<div class="col-md-10">
						<input type="text" class="form-control" id="HomePagePageTitle" name="HomePagePageTitle"value="{{ HomePagePageTitle|safe }}">
					</div>
				</div>

				<div class="form-group row">
					<label class="control-label col-md-2" for="MetaKeywordsr">{% lang 'MetaKeywords' %}</label>
					<div class="col-md-10">
						<input type="text" class="form-control" name="MetaKeywords" id="MetaKeywords" value="{{ MetaKeywords|safe }}">
					</div>
				</div>

				<div class="form-group row">
					<label class="control-label col-md-2" for="StartingOrderNumber">{% lang 'MetaDescription' %}</label>
					<div class="col-md-10">
						<input type="text" class="form-control" name="MetaDesc" id="MetaDesc" value="{{ MetaDesc|safe }}">
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default" style="{{ HideDatabaseDetails|safe }}">
			<div class="panel-heading"><h3 class="panel-title">{% lang 'DatabaseSettings' %}</h3></div>
			<div class="panel-body">
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabaseType' %}:</label>
					<div class="col-md-10">
						<input type="text" value="{{ dbType|safe }}" class="form-control" disabled readonly />
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabaseUser' %}:</label>
					<div class="col-md-10">
						<input type="text" value="{{ dbUser|safe }}" class="form-control" disabled readonly />
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabasePassword' %}:</label>
					<div class="col-md-10">
						<input type="text" value="" class="form-control" disabled readonly />
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabaseHostname' %}:</label>
					<div class="col-md-10">
						<input type="text" value="{{ dbServer|safe }}" class="form-control" disabled readonly />
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabaseTablePrefix' %}:</label>
					<div class="col-md-10">
						<input type="text" value="{{ tablePrefix|safe }}" class="form-control" disabled readonly />
					</div>
				</div>
				<div class="form-group row">
					<label class="control-label col-md-2">{% lang 'DatabaseVersion' %}:</label>
					<div class="col-md-10">
						{{ dbVersion|safe }}
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div1" style="padding-top: 10px;">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'LanguageSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'Language' %}:
					</label>
					<div class="col-md-10">
						<select name="Language" id="Lanauge" class="form-control">
							{{ LanguageOptions|safe }}
						</select>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'PhysicalDimensionSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'WeightMeasurement' %}:
					</label>
					<div class="col-md-10">
						<select name="WeightMeasurement" id="WeightMeasurement" class="form-control">
							<option value="LBS" {{ IsPounds|safe }}>{% lang 'Pounds' %}</option>
							<option value="Ounces" {{ IsOunces|safe }}>{% lang 'Ounces' %}</option>
							<option value="KGS" {{ IsKilos|safe }}>{% lang 'Kilograms' %}</option>
							<option value="Grams" {{ IsGrams|safe }}>{% lang 'Grams' %}</option>
							<option value="Tonnes" {{ IsTonnes|safe }}>{% lang 'Tonnes' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'LengthMeasurement' %}:
					</label>
					<div class="col-md-10">
						<select name="LengthMeasurement" id="LengthMeasurement" class="form-control">
							<option value="Inches" {{ IsInches|safe }}>{% lang 'Inches' %}</option>
							<option value="Centimeters" {{ IsCentimeters|safe }}>{% lang 'Centimeters' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DimensionsDecimalToken' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DimensionsDecimalToken" value="{{ DimensionsDecimalToken }}" id="DimensionsDecimalToken" class="form-control" maxlenght="1" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DimensionsThousandsToken' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DimensionsThousandsToken" value="{{ DimensionsThousandsToken }}" id="DimensionsThousandsToken" class="form-control" maxlenght="1" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DimensionsDecimalPlaces' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DimensionsDecimalPlaces" value="{{ DimensionsDecimalPlaces|safe }}" id="DimensionsDecimalPlaces" class="form-control" maxlenght="1" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShippingFactoringDimension' %}:
					</label>
					<div class="col-md-10">
						<select name="ShippingFactoringDimension" id="ShippingFactoringDimension" class="form-control">
							<option value="depth" {{ ShippingFactoringDimensionDepthSelected|safe }}>{% lang 'ShippingFactoringDimensionDepth' %}</option>
							<option value="height" {{ ShippingFactoringDimensionHeightSelected|safe }}>{% lang 'ShippingFactoringDimensionHeight' %}</option>
							<option value="width" {{ ShippingFactoringDimensionWidthSelected|safe }}>{% lang 'ShippingFactoringDimensionWidth' %}</option>
						</select>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'DateSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'StoreTimeZone' %}:
					</label>
					<div class="col-md-10">
						<select name="StoreTimeZone" id="StoreTimeZone" class="form-control">
							{{ TimeZoneOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableDSTCorrection' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsDSTCorrectionEnabled|safe }} type="checkbox" name="StoreDSTCorrection" id="StoreDSTCorrection" value="1" />
							<label for="StoreDSTCorrection">{% lang 'YesEnableDSTCorrection' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DisplayDateFormat' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DisplayDateFormat" id="DisplayDateFormat" value="{{ DisplayDateFormat|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ExportDateFormat' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="ExportDateFormat" id="ExportDateFormat" value="{{ ExportDateFormat|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ExtendedDisplayDateFormat' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="ExtendedDisplayDateFormat" id="ExtendedDisplayDateFormat" value="{{ ExtendedDisplayDateFormat|safe }}" class="form-control" />
					</div>
				</div>

			</div>
		</div>
	</div>

	<div id="div8">
		<input type="hidden" name="AutoResizeImages" id="AutoResizeImages" value="no" />
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'ProductThumbnailSizes' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'StorewideThumbnail' %}: 
					</label>
					<div class="col-md-10">
						<input style="width: 80px; display: inline;" type="text" type="text" name="ProductImagesStorewideThumbnail_width" id="ProductImagesStorewideThumbnail_width" value="{{ ProductImagesStorewideThumbnail_width|safe }}" class="form-control SetOriginalImageSizeValue" />&nbsp;x&nbsp;&nbsp;<input style="width: 80px; display: inline;" type="text" name="ProductImagesStorewideThumbnail_height" id="ProductImagesStorewideThumbnail_height" value="{{ ProductImagesStorewideThumbnail_height|safe }}" class="form-control SetOriginalImageSizeValue" />
						<!--<small class="help-block">{% lang 'StorewideThumbnailHelp' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ProductPageImage' %}: 
					</label>
					<div class="col-md-10">
						<input style="width: 80px; display: inline;" type="text" name="ProductImagesProductPageImage_width" id="ProductImagesProductPageImage_width" value="{{ ProductImagesProductPageImage_width|safe }}" class="form-control SetOriginalImageSizeValue" />&nbsp;x&nbsp;&nbsp;<input style="width: 80px; display: inline;" type="text" name="ProductImagesProductPageImage_height" id="ProductImagesProductPageImage_height" value="{{ ProductImagesProductPageImage_height|safe }}" class="form-control SetOriginalImageSizeValue" />
						<!--<small class="help-block">{% lang 'ProductPageImageHelp' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ProductPageGalleryThumbnail' %}: 
					</label>
					<div class="col-md-10">
						<input style="width: 80px; display: inline;" type="text" name="ProductImagesGalleryThumbnail_width" id="ProductImagesGalleryThumbnail_width" value="{{ ProductImagesGalleryThumbnail_width|safe }}" class="form-control SetOriginalImageSizeValue" />&nbsp;x&nbsp;&nbsp;<input style="width: 80px; display: inline;" type="text" name="ProductImagesGalleryThumbnail_height" id="ProductImagesGalleryThumbnail_height" value="{{ ProductImagesGalleryThumbnail_height|safe }}" class="form-control SetOriginalImageSizeValue" />
						<!--<small class="help-block">{% lang 'ProductPageGalleryThumbnail' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ProductPageZoomImage' %}: 
					</label>
					<div class="col-md-10">
						<input style="width: 80px; display: inline;" type="text" name="ProductImagesZoomImage_width" id="ProductImagesZoomImage_width" value="{{ ProductImagesZoomImage_width|safe }}" class="form-control SetOriginalImageSizeValue" />&nbsp;x&nbsp;&nbsp;<input style="width: 80px; display: inline;" type="text" name="ProductImagesZoomImage_height" id="ProductImagesZoomImage_height" value="{{ ProductImagesZoomImage_height|safe }}" class="form-control SetOriginalImageSizeValue" />
						<!--<small class="help-block">{% lang 'ProductPageZoomImageHelp' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ReprocessImages' %}: 
					</label>
					<div class="col-md-10">
						<a href="#" id="ReprocessImages" class="btn btn-primary">{% lang 'ReprocessImagesLink' %}</a>
						<!--<small class="help-block">{% lang 'ReprocessImagesHelp' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowTinyThumbnails' %}: 
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ProductImagesTinyThumbnailsEnabled" id="ProductImagesTinyThumbnailsEnabled" value="ON" {{ IsProductImagesTinyThumbnailsEnabled|safe }} />
							<label for="ProductImagesTinyThumbnailsEnabled">{% lang 'YesShowTinyThumbnails' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableImageZoom' %}: 
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ProductImagesImageZoomEnabled" id="ProductImagesImageZoomEnabled" value="ON" {{ IsProductImagesImageZoomEnabled|safe }} />
							<label for="ProductImagesImageZoomEnabled">{% lang 'YesEnableImageZoom' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ProductImageMode' %}: 
					</label>
					<div class="col-md-10">
						<select name="ProductImageMode" id="ProductImageMode" class="form-control">
							<option value="popup" {{ ProductImageModePopup|safe }}>{% lang 'ProductImageModePopup' %}</option>
							<option value="lightbox" {{ ProductImageModeLightbox|safe }}>{% lang 'ProductImageModeLightbox' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						Imagem Padro: 
					</label>
					<div class="col-md-10">
						<div class="radio radio-primary">
							<input type="radio" class="DefaultProductImage" id="DefaultProductImage1" name="DefaultProductImage" value="none" {{ DefaultProductImageNoneChecked|safe }} />
							<label for="DefaultProductImage1">{% lang 'DefaultProductImageNone' %}</label>
						</div>

						<div class="radio radio-primary">
							<input type="radio" class="DefaultProductImage" id="DefaultProductImage2" name="DefaultProductImage" value="template" {{ DefaultProductImageTemplateChecked|safe }} />
							<label for="DefaultProductImage2">{% lang 'DefaultProductImageTemplate' %} (<a href="{{ AppPath|safe }}/templates/{{ template|safe }}/images/ProductDefault.gif" target="_blank">templates/{{ template|safe }}/images/ProductDefault.gif</a>)</label>
						</div>

						<div class="radio radio-primary">
							<input type="radio" class="DefaultProductImage" id="DefaultProductImage3" name="DefaultProductImage" value="custom" {{ DefaultProductImageCustomChecked|safe }} />
							<label for="DefaultProductImage3">{% lang 'DefaultProductImageNone' %}</label>
						</div>
						
						<div id="DefaultProductImageCustomContainer" style="margin-top: 5px;">
							<span style="{{ HideCurrentDefaultProductImage|safe }}" id="DefaultProductImageCustomCurrent">&nbsp;&nbsp;&nbsp; {% lang 'CurrentDefaultImage' %}: <a href="{{ AppPath|safe }}/{{ DefaultProductImage|safe }}" target="_blank">{{ DefaultProductImage|safe }}</a></span>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CategoryAndBrandImages' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CatItemPerRow' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="CategoryPerRow" id="CategoryPerRow" value="{{ CategoryPerRow|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'CatItemPerRow' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'BrandItemPerRow' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="BrandPerRow" id="BrandPerRow" value="{{ BrandPerRow|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'BrandItemPerRow' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CatImageDimSetting' %}:
					</label>
					<div class="col-md-10">
						<input style="display: inline; width: 80px;" type="text" name="CategoryImageWidth" id="CategoryImageWidth" value="{{ CategoryImageWidth|safe }}" class="form-control" /> x <input style="display: inline; width: 80px;" type="text" name="CategoryImageHeight" id="CategoryImageHeight" value="{{ CategoryImageHeight|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CatImageDefaultSetting' %}:
					</label>
					<div class="col-md-10">
						<input type="file" id="CategoryDefaultImage" name="CategoryDefaultImage" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'BrandImageDefaultSetting' %}:
					</label>
					<div class="col-md-10">
						<input type="file" id="BrandDefaultImage" name="BrandDefaultImage" class="form-control" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div2">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'DisplaySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HomeFeaturedProducts' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="HomeFeaturedProducts" id="HomeFeaturedProducts" value="{{ HomeFeaturedProducts|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'HomeFeaturedProducts' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HomeNewProducts' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="HomeNewProducts" id="HomeNewProducts" value="{{ HomeNewProducts|safe }}" class="form-control" />
						<small class="help-block">digite 99 para ativar o carrossel infinito.Sero listados todos os itens de sua loja de 4 em 4 na Home.</small>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HomeBlogPosts' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="HomeBlogPosts" id="HomeBlogPosts" value="{{ HomeBlogPosts|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'HomeBlogPosts' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CategoryProductsPerPage' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="CategoryProductsPerPage" id="CategoryProductsPerPage" value="{{ CategoryProductsPerPage|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'CategoryProductsPerPage' %}</small>-->
					</div>
				</div>

				<div class="form-group row" style="{{ HideIfReviewsDisabled }}">
					<label class="col-md-2 control-label">
						{% lang 'ProductReviewsPerPage' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="ProductReviewsPerPage" id="ProductReviewsPerPage" value="{{ ProductReviewsPerPage|safe }}" class="form-control" />
						<!--<small class="help-block">{% lang 'ProductReviewsPerPage' %}</small>-->
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CartQuantityBoxes' %}:
					</label>
					<div class="col-md-10">
						<select name="TagCartQuantityBoxes" id="TagCartQuantityBoxes" class="form-control">
							<option value="dropdown"  {{ IsDropdown|safe }}>{% lang 'DropdownList' %}</option>
							<option value="textbox"  {{ IsTextbox|safe }}>{% lang 'TextBox' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'FastCartLabel' %}:
					</label>
					<div class="col-md-10">
						<select name="FastCartAction" id="FastCartAction" class="form-control">
							<option value="popup" {{ IsShowPopWindow|safe }}>{% lang 'FastCartOption1ShowPopWindow' %}</option>
							<option value="cart" {{ IsShowCartPage|safe }}>{% lang 'FastCartOption2ShowCartPage' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ProductBreadcrumbs' %}:
					</label>
					<div class="col-md-10">
						{{ form.select('ProductBreadcrumbs', ProductBreadcrumbOptions, ProductBreadcrumbs, []) }}
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowAddToCartQtyBox' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowAddToCartQtyBox" id="ShowAddToCartQtyBox" value="ON" {{ IsShownAddToCartQtyBox|safe }} /> <label for="ShowAddToCartQtyBox">{% lang 'YesShowAddToCartQtyBox' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						Ativar Aceite LGDP:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableCookies" id="EnableCookies" value="ON" {{ IsEnableCookies|safe }} /> <label for="EnableCookies">Sim, mostrar o Poup-up para que os clientes aceite os termos sobre uso de dados.</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CaptchaEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="CaptchaEnabled" id="CaptchaEnabled" value="ON" {{ IsCaptchaEnabled|safe }} /> <label for="CaptchaEnabled">{% lang 'YesCaptchaEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableSearchSuggest' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="SearchSuggest" id="SearchSuggest" value="ON" {{ IsSearchSuggest|safe }} /> <label for="SearchSuggest">{% lang 'YesSearchSuggest' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">
						Ativar reCAPTCHA v3 Google ?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="Attrecaptchav3" id="Attrecaptchav3" value="ON" {{ IsAttrecaptchav3|safe }} />
							<label for="Attrecaptchav3">Sim!</label>
							
						</div>
					</div>
				</div>
				<div id="H02" style="display: none;">
					<div class="form-group">
						<label class="col-md-2 control-label">
							Informe sua Chave de Site: 
						</label>
						<div class="col-md-10">
							<input type="text" name="SiteKey" id="SiteKey" value="{{ SiteKey|safe }}" class="form-control" />
							<small class="help-block"> <a target='_blank'href='https://g.co/recaptcha/v3'>Obtenha as chaves aqui</a></small>
						</div>
					</div>
					<div class="form-group">
						<label class="col-md-2 control-label">
							Informe sua Chave Segreta: 
						</label>
						<div class="col-md-10">
							<input type="text" name="SecretKey" id="SiteKey" value="{{ SecretKey|safe }}" class="form-control" />
						</div>
					</div>
					
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowThumbsInCart' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowThumbsInCart" id="ShowThumbsInCart" value="ON" {{ IsShowThumbsInCart|safe }} /> <label for="ShowThumbsInCart">{% lang 'YesShowThumbsInCart' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowCartSuggestions' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowCartSuggestions" id="ShowCartSuggestions" value="ON" {{ IsShowCartSuggestions|safe }} /> <label for="ShowCartSuggestions">{% lang 'YesShowCartSuggestions' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row" style="{{ HideIfReviewsDisabled }}">
					<label class="col-md-2 control-label">
						{% lang 'AutoApproveReviews' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="AutoApproveReviews" id="AutoApproveReviews" value="ON" {{ IsAutoApproveReviews|safe }} /> <label for="AutoApproveReviews">{% lang 'YesAutoApproveReviews' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableCustomersAlsoViewed' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableCustomersAlsoViewed" id="EnableCustomersAlsoViewed" value="ON" {{ IsCustomersAlsoViewedEnabled|safe }} onclick="if(this.checked) { $('.HideIfCustomersAlsoViewedDisabled').show(); } else { $('.HideIfCustomersAlsoViewedDisabled').hide(); }" /> <label for="EnableCustomersAlsoViewed">{% lang 'YesEnableCustomersAlsoViewed' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row HideIfCustomersAlsoViewedDisabled">
					<label class="col-md-2 control-label">
						{% lang 'CustomersAlsoViewedCount' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="CustomersAlsoViewedCount" id="CustomersAlsoViewedCount" value="{{ CustomersAlsoViewedCount }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableQuickSearch' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="QuickSearch" id="QuickSearch" value="ON" {{ IsQuickSearch|safe }} /> <label for="QuickSearch">{% lang 'YesQuickSearch' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowInventory' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowInventory" id="ShowInventory" value="ON" {{ IsShowInventory|safe }} onclick="if(this.checked) { $('.HideIfShowInventoryDisabled').show(); } else { $('.HideIfShowInventoryDisabled').hide(); }" /> <label for="ShowInventory">{% lang 'YesShowInventory' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row HideIfShowInventoryDisabled">
					<label class="col-md-2 control-label">
						{% lang 'ShowPreOrderInventory' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowPreOrderInventory" id="ShowPreOrderInventory" value="ON" {{ IsShowPreOrderInventory|safe }} /> <label for="ShowPreOrderInventory">{% lang 'YesShowPreOrderInventory' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableWishlist' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableWishlist" id="EnableWishlist" value="ON" {{ IsWishlistEnabled|safe }} /> <label for="EnableWishlist">{% lang 'YesEnableWishlist' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableWishlist' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableWishlist" id="EnableWishlist" value="ON" {{ IsWishlistEnabled|safe }} /> <label for="EnableWishlist">{% lang 'YesEnableWishlist' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableAccountCreation' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableAccountCreation" id="EnableAccountCreation" value="ON" {{ IsEnableAccountCreation|safe }} /> <label for="EnableAccountCreation">{% lang 'YesEnableAccountCreation' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'BulkDiscountEnabled' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BulkDiscountEnabled" id="BulkDiscountEnabled" value="ON" {{ IsBulkDiscountEnabled|safe }} /> <label for="BulkDiscountEnabled">{% lang 'YesBulkDiscountEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableProductTabs' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableProductTabs" id="EnableProductTabs" value="ON" {{ IsProductTabsEnabled|safe }} /> <label for="EnableProductTabs">{% lang 'YesEnableProductTabs' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'ControlPanelDisplaySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'UseWYSIWYGEditor' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="UseWYSIWYG" id="UseWYSIWYG" value="ON" {{ IsWYSIWYGEnabled|safe }} /> <label for="UseWYSIWYG">{% lang 'YesEnableWYSIWYGEditor' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductThumbnails' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowThumbsInControlPanel" id="ShowThumbsInControlPanel" value="ON" {{ IsProductThumbnailsEnabled|safe }} /> <label for="ShowThumbsInControlPanel">{% lang 'YesShowProductThumbnails' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CategorySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CategoryListMode' %}:
					</label>
					<div class="col-md-10">
						<div class="radio radio-primary">
							<input type="radio" name="CategoryListingMode" value="single" {{ CategoryListModeSingle|safe }} />
							<label>{% lang 'CategoryListModeSingle' %}</label>
						</div>

						<div class="radio radio-primary">
							<input type="radio" name="CategoryListingMode" value="emptychildren" {{ CategoryListModeEmptyChildren|safe }} />
							<label>{% lang 'CategoryListModeEmptyChildren' %}</label>
						</div>

						<div class="radio radio-primary">
							<input type="radio" name="CategoryListingMode" value="children" {{ CategoryListModeChildren|safe }} />
							<label>{% lang 'CategoryListModeChildren' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'CategoryListDepth' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="CategoryListDepth" id="CategoryListDepth" value="{{ CategoryListDepth|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'ProductSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductPrice' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductPrice" id="ShowProductPrice" value="ON" {{ IsProductPriceShown|safe }} /> <label for="ShowProductPrice">{% lang 'YesShowProductPrice' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductSKU' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductSKU" id="ShowProductSKU" value="ON" {{ IsProductSKUShown|safe }} /> <label for="ShowProductSKU">{% lang 'YesShowProductSKU' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductWeight' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductWeight" id="ShowProductWeight" value="ON" {{ IsProductWeightShown|safe }} /> <label for="ShowProductWeight">{% lang 'YesShowProductWeight' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductBrand' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductBrand" id="ShowProductBrand" value="ON" {{ IsProductBrandShown|safe }} /> <label for="ShowProductBrand">{% lang 'YesShowProductBrand' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductShipping' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductShipping" id="ShowProductShipping" value="ON" {{ IsProductShippingShown|safe }} /> <label for="ShowProductShipping">{% lang 'YesShowProductShipping' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowProductRating' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowProductRating" id="ShowProductRating" value="ON" {{ IsProductRatingShown|safe }} /> <label for="ShowProductRating">{% lang 'YesShowProductRating' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowAddToCartLink' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="ShowAddToCartLink" id="ShowAddToCartLink" value="ON" {{ IsAddToCartLinkShown|safe }} /> <label for="ShowAddToCartLink">{% lang 'YesShowAddToCartLink' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'TagCloudFontSize' %}:
					</label>
					<div class="col-md-10">
						<label>
							{% lang 'From' %} 
							<input type="text" name="TagCloudMinSize" id="TagCloudMinSize" value="{{ TagCloudMinSize|safe }}" class="form-control" style="display: inline; width: auto" />
							%
						</label>

						<label>{% lang 'SearchTo' %} <input type="text" name="TagCloudMaxSize" id="TagCloudMaxSize" value="{{ TagCloudMaxSize|safe }}"  class="form-control" style="display: inline; width: auto" />%</label>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DefaultPreOrderMessage' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="DefaultPreOrderMessage" id="DefaultPreOrderMessage" value="{{ DefaultPreOrderMessage|safe }}" class=form-control />
					</div>
				</div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SocialSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'ShowFacebookLikeButton' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="FacebookLikeButtonEnabled" id="FacebookLikeButtonEnabled" value="1" {% if FacebookLikeButtonEnabled %}checked="checked"{% endif %} />
							<label for="FacebookLikeButtonEnabled">{% lang 'YesShowFacebookLikeButton' %}</label>
						</div>

						<div class="NodeJoin" id="facebookLikeOptions" {% if FacebookLikeButtonEnabled == false %}style="display: none;"{% endif %}>
							<label for="FacebookLikeButtonStyle">{{ lang.LayoutStyle }}:</label>
							<select name="FacebookLikeButtonStyle" id="FacebookLikeButtonStyle">
								<option value="standard" {{ FacebookLikeButtonStylestandard }}>{{ lang.StyleStandard }}</option>
								<option value="countonly" {{ FacebookLikeButtonStylecountonly }}>{{ lang.StyleCountOnly }}</option>
							</select>
						</div>

						<div>
							<label for="FacebookLikeButtonPosition">{{ lang.ButtonPosition }}:</label>
							<select name="FacebookLikeButtonPosition" id="FacebookLikeButtonPosition">
								<option value="above" {{ FacebookLikeButtonPositionabove }}>{{ lang.Above }}</option>
								<option value="below" {{ FacebookLikeButtonPositionbelow }}>{{ lang.Below }}</option>
							</select>
						</div>

						<div>
							<label for="FacebookLikeButtonVerb">{{ lang.TextToDisplay }}:</label>
							<select name="FacebookLikeButtonVerb" id="FacebookLikeButtonVerb">
								<option value="like" {{ FacebookLikeButtonVerblike }}>{{ lang.Like }}</option>
								<option value="recommend" {{ FacebookLikeButtonVerbrecommend }}>{{ lang.Recommend }}</option>
							</select>
						</div>

						<div>
							<label for="FacebookLikeButtonShowFaces">{{ lang.ShowFaces }}?</label>
							<label>
								<input type="checkbox" name="FacebookLikeButtonShowFaces" id="FacebookLikeButtonShowFaces" value="1" {% if FacebookLikeButtonShowFacesEnabled %}checked="checked"{% endif %} />
								{{ lang.YesShowFaces }}
							</label>
						</div>

						<div>
							<label for="FacebookLikeButtonAdminIds"><span class="Required">*</span> {{ lang.FacebookAdminIds }}:</label>
							<input type="text" name="FacebookLikeButtonAdminIds" id="FacebookLikeButtonAdminIds" value="{{ FacebookLikeButtonAdminIds }}" />
						</div>
					</div>
				</div>
			</div>
		</div>
		
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'RSSSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSNewProductsEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSNewProducts" id="RSSNewProducts" value="ON" {{ IsRSSNewProductsEnabled|safe }} /> <label for="RSSNewProducts">{% lang 'YesRSSNewProductsEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSPopularProductsEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSPopularProducts" id="RSSPopularProducts" value="ON" {{ IsRSSPopularProductsEnabled|safe }} /> <label for="RSSPopularProducts">{% lang 'YesRSSPopularProductsEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSFeaturedProductsEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSFeaturedProducts" id="RSSFeaturedProducts" value="ON" {{ IsRSSFeaturedProductsEnabled|safe }} /> <label for="RSSFeaturedProducts">{% lang 'YesRSSFeaturedProductsEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSCategoriesEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSCategories" id="RSSCategories" value="ON" {{ IsRSSCategoriesEnabled|safe }} /> <label for="RSSCategories">{% lang 'YesRSSCategoriesEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSProductSearchesEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSProductSearches" id="RSSProductSearches" value="ON" {{ IsRSSProductSearchesEnabled|safe }} /> <label for="RSSProductSearches">{% lang 'YesRSSProductSearchesEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSLatestBlogEntriesEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSLatestBlogEntries" id="RSSLatestBlogEntries" value="ON" {{ IsRSSLatestBlogEntriesEnabled|safe }} /> <label for="RSSLatestBlogEntries">{% lang 'YesRSSLatestBlogEntriesEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSLatestBlogEntriesEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSLatestBlogEntries" id="RSSLatestBlogEntries" value="ON" {{ IsRSSLatestBlogEntriesEnabled|safe }} /> <label for="RSSLatestBlogEntries">{% lang 'YesRSSLatestBlogEntriesEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSSyndicationIconsEnabled' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="RSSSyndicationIcons" id="RSSSyndicationIcons" value="ON" {{ IsRSSSyndicationIconsEnabled|safe }} /> <label for="RSSSyndicationIcons">{% lang 'YesRSSSyndicationIconsEnabled' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSItemsLimit' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="RSSItemsLimit" id="RSSItemsLimit" value="{{ RSSItemsLimit|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'RSSCacheTime' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="RSSCacheTime" id="RSSCacheTime" value="{{ RSSCacheTime|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div3" style="display: {{ HideBackupSettings|safe }}">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'BackupSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableLocalBackups' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsLocal" id="BackupsLocal" onclick="ToggleLocalBackups();" value="ON" {{ IsBackupsLocalEnabled|safe }} /> <label for="BackupsLocal">{% lang 'YesEnableLocalBackups' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row" id="BackupsRemoteFTPContainer" style="display: %%FTPBackupsHide%%">
					<label class="col-md-2 control-label">
						{% lang 'EnableRemoteFTPBackups' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsRemoteFTP" id="BackupsRemoteFTP" onclick="ToggleFTPBackups();" value="ON" {{ IsBackupsRemoteFTPEnabled|safe }} /> <label for="BackupsRemoteFTP">{% lang 'YesEnableRemoteFTPBackups' %}</label>
						</div>
					</div>
				</div>

				<div id="BackupsRemoteFTPSettings" style="display: none;">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'FTPServerDetails' %}:
						</label>
						<div class="col-md-10">
							<div class="form-group">
								<label>{% lang 'FTPHostName' %}:</label>
								<input type="text" name="BackupsRemoteFTPHost" id="BackupsRemoteFTPHost" value="{{ BackupsRemoteFTPHost|safe }}" class="form-control" />
							</div>

							<div class="form-group">
								<label>{% lang 'FTPUsername' %}:</label>
								<input type="text" name="BackupsRemoteFTPUser" id="BackupsRemoteFTPUser" value="{{ BackupsRemoteFTPUser|safe }}" class="form-control" />
							</div>

							<div class="form-group">
								<label>{% lang 'FTPPassword' %}:</label>
								<input type="password" autocomplete="off" name="BackupsRemoteFTPPass" id="BackupsRemoteFTPPass" value="{{ BackupsRemoteFTPPass|safe }}" class="form-control" />
							</div>

							<div class="form-group">
								<label>{% lang 'FTPPath' %}:</label>
								<input type="text" name="BackupsRemoteFTPPath" id="BackupsRemoteFTPPath" value="{{ BackupsRemoteFTPPath|safe }}" class="form-control" />
							</div>

							<div class="form-group">
								<input type="button" value="{% lang 'TestFTPSettings' %}" class="btn btn-primary" onclick="DoTestFTPSettings()" id="TestFTPSettings" /> &nbsp;&nbsp;<img src="images/ajax-loader.gif" style="vertical-align: middle; display: none;" id="TestFTPSettingsLoading" alt="" />
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'AutomaticBackups' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableAutomaticBackups' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsAutomatic" id="BackupsAutomatic" onclick="ToggleAutomaticBackups();" value="ON" {{ IsBackupsAutomaticEnabled|safe }} /> <label for="BackupsAutomatic">{% lang 'YesEnableAutomaticBackups' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row BackupsAutomaticContainer">
					<label class="col-md-2 control-label">
						{% lang 'BackupCronPath' %}:
					</label>
					<div class="col-md-10">
						<input type="text" class="form-control" name="BackupsAutomaticPath" id="BackupsAutomaticPath" value="{{ BackupsAutomaticPath|safe }}" />
					</div>
				</div>

				<div class="form-group row BackupsAutomaticContainer">
					<label class="col-md-2 control-label">
						{% lang 'BackupCronPath' %}:
					</label>
					<div class="col-md-10">
						<input type="text" class="form-control" name="BackupsAutomaticPath" id="BackupsAutomaticPath" value="{{ BackupsAutomaticPath|safe }}" />
					</div>
				</div>

				<div class="form-group row BackupsAutomaticContainer">
					<label class="col-md-2 control-label">
						{% lang 'AutomaticBackupMethod' %}:
					</label>
					<div class="col-md-10">
						<select name="BackupsAutomaticMethod" id="BackupsAutomaticMethod" class="form-control">
							<option value="local" {{ IsBackupsAutomaticMethodLocal|safe }} id="BackupsAutomaticLocal">{% lang 'AutomaticBackupLocal' %}</option>
							<option value="ftp" {{ IsBackupsAutomaticMethodFTP|safe }} id="BackupsAutomaticFTP">{% lang 'AutomaticBackupRemoteFTP' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row BackupsAutomaticContainer">
					<label class="col-md-2 control-label">
						{% lang 'BackupSettings' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsAutomaticDatabase" id="BackupsAutomaticDatabase" value="ON" {{ IsBackupsAutomaticDatabaseEnabled|safe }} /> <label> {% lang 'SettingsBackupDatabase' %}</label>
						</div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsAutomaticImages" id="BackupsAutomaticImages" value="ON" {{ IsBackupsAutomaticImagesEnabled|safe }} /> <label> {% lang 'SettingsBackupProductImages' %}</label>
						</div>

						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="BackupsAutomaticDownloads" id="BackupsAutomaticDownloads" value="ON" {{ IsBackupsAutomaticDownloadsEnabled|safe }} /> <label> {% lang 'SettingsBackupDigitalProducts' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div4" style="padding-top: 10px;">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SearchSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'SearchOptimisation' %}:
					</label>
					<div class="col-md-10">
						<select name="SearchOptimisation" id="SearchOptimisation" class="form-control">
							{{ SearchOptimisationOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'SearchDefaultProductSort' %}:
					</label>
					<div class="col-md-10">
						<select name="SearchDefaultProductSort" id="SearchDefaultProductSort" class="form-control">
							{{ SearchDefaultProductSortOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'SearchDefaultContentSort' %}:
					</label>
					<div class="col-md-10">
						<select name="SearchDefaultContentSort" id="SearchDefaultContentSort" class="form-control">
							{{ SearchDefaultContentSortOptions|safe }}
						</select>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'SearchResultsPerPage' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="SearchResultsPerPage" id="SearchResultsPerPage" value="{{ SearchResultsPerPage|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div5" style="{{ HideLoggingSettingsTab|safe }}">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'SystemLogging' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableSystemLogging' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsSystemLoggingEnabled|safe }} type="checkbox" name="SystemLogging" id="EnableSystemLogging" value="ON" onclick="ToggleSystemLogging()" />
							<label for="EnableSystemLogging">{% lang 'YesEnableSystemLogging' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row SystemLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'ActionsToLog' %}:
					</label>
					<div class="col-md-10">
						<select name="SystemLogTypes[]" id="SystemLogTypes" multiple="multiple" size="10" class="form-control ISSelectReplacement">
							<option selected value="general" {{ IsGeneralLoggingEnabled|safe }}>{% lang 'ActionsToLogGeneral' %}</option>
							<option selected value="payment" {{ IsPaymentLoggingEnabled|safe }}>{% lang 'ActionsToLogPayment' %}</option>
							<option selected value="shipping" {{ IsShippingLoggingEnabled|safe }}>{% lang 'ActionsToLogShipping' %}</option>
							<option selected value="notification" {{ IsNotificationLoggingEnabled|safe }}>{% lang 'ActionsToLogNotification' %}</option>
							<option selected value="sql" {{ IsSQLLoggingEnabled|safe }}>{% lang 'ActionsToLogSQL' %}</option>
							<option selected value="php" {{ IsPHPLoggingEnabled|safe }}>{% lang 'ActionsToLogPHP' %}</option>
							<option selected value="accounting" {{ IsAccountingLoggingEnabled|safe }}>{% lang 'ActionsToLogAccounting' %}</option>
							<option selected value="emailintegration" {{ IsEmailIntegrationLoggingEnabled|safe }}>{% lang 'ActionsToLogEmailIntegration' %}</option>
							<option selected value="ebay" {{ IsEbayLoggingEnabled|safe }}>{% lang 'ActionsToLogEbay' %}</option>
							<option selected value="shoppingcomparison" {{ IsShoppingComparisonLoggingEnabled|safe }}>{% lang 'ActionsToLogShoppingComparison' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row SystemLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'TypesOfMessages' %}:
					</label>
					<div class="col-md-10">
						<select name="SystemLogSeverity[]" id="SystemLogSeverity" multiple="multiple" size="7" class="form-control ISSelectReplacement">
							<option selected value="errors" {{ IsLoggingSeverityErrors|safe }}>{% lang 'TypesOfMessagesErrors' %}</option>
							<option selected value="warnings" {{ IsLoggingSeverityWarnings|safe }}>{% lang 'TypesOfMessagesWarnings' %}</option>
							<option selected value="success" {{ IsLoggingSeveritySuccesses|safe }}>{% lang 'TypesOfMessagesSuccesses' %}</option>
							<option selected value="notices" {{ IsLoggingSeverityNotices|safe }}>{% lang 'TypesOfMessagesNotices' %}</option>
							<option selected value="debug" {{ IsLoggingSeverityDebug|safe }}>{% lang 'TypesOfMessagesDebug' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group row SystemLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'RestrictLogTo' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="SystemLogMaxLength" id="SystemLogMaxLength" value="{{ SystemLogMaxLength|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row SystemLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'HidePHPErrors' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsHidePHPErrorsEnabled|safe }} type="checkbox" name="HidePHPErrors" id="HidePHPErrors" value="1" />
							<label style="padding-left: 4px;" for="HidePHPErrors">{% lang 'YesHidePHPErrors' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row SystemLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'EnableDebugMode' %}?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsDebugModeEnabled|safe }} type="checkbox" name="DebugMode" id="DebugMode" value="1" />
							<label style="padding-left: 4px;" for="DebugMode">{% lang 'YesEnableDebugMode' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default" style="display: {{ HideStaffLogs|safe }}">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'AdministratorLogging' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'EnableAdministratorLogging' %}?:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsAdministratorLoggingEnabled|safe }} type="checkbox" name="AdministratorLogging" id="EnableAdministratorLogging" value="ON" onclick="ToggleAdministratorLogging()" />
							<label for="EnableAdministratorLogging"> {% lang 'YesEnableAdministratorLogging' %}</label>
						</div>
					</div>
				</div>

				<div class="form-group row AdministratorLoggingToggle">
					<label class="col-md-2 control-label">
						{% lang 'RestrictLogTo' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="AdministratorLogMaxLength" id="AdministratorLogMaxLength" value="{{ AdministratorLogMaxLength|safe }}" class="form-control" />
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="div6" style="display: none">
		<table width="100%" class="Panel">
			<tr>
				<td class="Heading2" colspan="2">{% lang 'VendorSettings' %}</td>
			</tr>
			<tr>
				<td class="FieldLabel">
					&nbsp;&nbsp; {% lang 'VendorLogoUploading' %}:
				</td>
				
				<td>
					<label>
						<input type="checkbox" name="VendorLogoUploading" id="VendorLogoUploading" value="1" {{ VendorLogoUploadingChecked|safe }} onclick="$(this).parent().siblings('.CheckToggle').toggle();" /> {% lang 'YesAllowVendorLogoUploading' %}
					</label>
					
					<img onmouseout="HideHelp('VendorLogoUploadingHelp');" onmouseover="ShowHelp('VendorLogoUploadingHelp', '{% lang 'VendorLogoUploading' %}', '{% lang 'VendorLogoUploadingHelp' %}')" src="images/help.gif" width="24" height="16" border="0" />
					<div style="display:none" id="VendorLogoUploadingHelp"></div>
					<div style="{{ HideVendorLogoUploading|safe }}" class="CheckToggle">
						<img src="images/nodejoin.gif" alt="" />
						{% lang 'MaximumImageDimensions' %}:
						<input type="text" name="VendorLogoSizeW" id="VendorLogoSizeW" value="{{ VendorLogoSizeW|safe }}" class="Field40" />
						x
						<input type="text" name="VendorLogoSizeH" id="VendorLogoSizeH" value="{{ VendorLogoSizeH|safe }}" class="Field40" />
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="FieldLabel" style="vertical-align: top">
					&nbsp;&nbsp; {% lang 'VendorPhotoUploading' %}:
				</td>
				<td>
					<label>
						<input type="checkbox" name="VendorPhotoUploading" id="VendorPhotoUploading" value="1" {{ VendorPhotoUploadingChecked|safe }} onclick="$(this).parent().siblings('.CheckToggle').toggle();" /> {% lang 'YesAllowVendorPhotoUploading' %}
					</label>
					<img onmouseout="HideHelp('VendorPhotoUploadingHelp');" onmouseover="ShowHelp('VendorPhotoUploadingHelp', '{% lang 'VendorPhotoUploading' %}', '{% lang 'VendorPhotoUploadingHelp' %}')" src="images/help.gif" width="24" height="16" border="0" />
					<div style="display:none" id="VendorPhotoUploadingHelp"></div>
					<div style="{{ HideVendorPhotoUploading|safe }}" class="CheckToggle">
						<img src="images/nodejoin.gif" alt="" />
						{% lang 'MaximumImageDimensions' %}:
						<input type="text" name="VendorPhotoSizeW" id="VendorPhotoSizeW" value="{{ VendorPhotoSizeW|safe }}" class="Field40" />
						x
						<input type="text" name="VendorPhotoSizeH" id="VendorPhotoSizeH" value="{{ VendorPhotoSizeH|safe }}" class="Field40" />
					</div>
				</td>
			</tr>
		</table>
	</div>

	<div id="div7">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CustomerGroupsSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'GuestCustomerGroup' %}:
					</label>
					<div class="col-md-10">
						<select name="GuestCustomerGroup" id="GuestCustomerGroup" size="5" class="form-control">
							<option value="0">{% lang 'GuestCustomerGroupNone' %}</option>
							{{ CustomerGroupOptions|safe }}
						</select>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default" style="{{ HideProxyFields|safe }}">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'HTTPProxySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HTTPProxyServer' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="HTTPProxyServer" id="HTTPProxyServer" value="{{ HTTPProxyServer|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HTTPProxyPort' %}:
					</label>
					<div class="col-md-10">
						<input type="text" name="HTTPProxyPort" id="HTTPProxyPort" value="{{ HTTPProxyPort|safe }}" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'HTTPSSLVerifyPeer' %}:
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input {{ IsHTTPSSLVerifyPeerEnabled|safe }} type="checkbox" name="HTTPSSLVerifyPeer" id="HTTPSSLVerifyPeer" value="ON" /> <label for="HTTPSSLVerifyPeer">{% lang 'YesHTTPSSLVerifyPeer' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		{% if not ISC_CFG.HideDeletedOrdersActionSetting %}
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'OrderSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'DeletedOrders' %}:
					</label>
					<div class="col-md-10">
						<div class="radio radio-primary">
							<input type="radio" name="DeletedOrdersAction" value="delete" {% if DeletedOrdersAction == 'delete' %}checked="checked"{% endif %} /> <label> {% lang 'DeletedOrdersAction_Delete' %}</label>
						</div>

						<div class="radio radio-primary">
							<input type="radio" name="DeletedOrdersAction" value="purge" {% if DeletedOrdersAction == 'purge' %}checked="checked"{% endif %} /><label> {% lang 'DeletedOrdersAction_Purge' %}</label> 
						</div>
					</div>
				</div>
			</div>
		</div>
		{% endif %}

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'HTTPProxySettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'StartingOrderNumber' %}:
					</label>
					<div class="col-md-10">
						<input id="StartingOrderNumber" name="StartingOrderNumber" value="{{ StartingOrderNumber|safe }}" type="text" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'AbandonOrderLifetime' %}:
					</label>
					<div class="col-md-10">
						<select name="AbandonOrderLifetime" id="AbandonOrderLifetime" class="form-control">
							{{ AbandonOrderLifetimeOptions|safe }}
						</select>
					</div>
				</div>
			</div>
		</div>

		{% if ShowPCISettings %}
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'PCISettingsPanel' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCIPasswordMinLen' %}:
					</label>
					<div class="col-md-10">
						<input id="PCIPasswordMinLen" name="PCIPasswordMinLen" value="{{ PCIPasswordMinLen|safe }}" type="text" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCIPasswordHistoryCount' %}:
					</label>
					<div class="col-md-10">
						<input id="PCIPasswordHistoryCount" name="PCIPasswordHistoryCount" value="{{ PCIPasswordHistoryCount|safe }}" type="text" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCIPasswordExpiryTimeDay' %}:
					</label>
					<div class="col-md-10">
						<input id="PCIPasswordExpiryTimeDay" name="PCIPasswordExpiryTimeDay" value="{{ PCIPasswordExpiryTimeDay|safe }}" type="text" class="form-control" />
						<span class="help-block">dias</span>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCILoginAttemptCount' %}:
					</label>
					<div class="col-md-10">
						<input id="PCILoginAttemptCount" name="PCILoginAttemptCount" value="{{ PCILoginAttemptCount|safe }}" type="text" class="form-control" />
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCILoginLockoutTimeMin' %}:
					</label>
					<div class="col-md-10">
						<input id="PCILoginIdleTimeMin" name="PCILoginIdleTimeMin" value="{{ PCILoginIdleTimeMin|safe }}" type="text" class="form-control" />
						<span class="help-block">minutos</span>
					</div>
				</div>

				<div class="form-group row">
					<label class="col-md-2 control-label">
						{% lang 'PCILoginInactiveTimeDay' %}:
					</label>
					<div class="col-md-10">
						<input id="PCILoginInactiveTimeDay" name="PCILoginInactiveTimeDay" value="{{ PCILoginInactiveTimeDay|safe }}" type="text" class="form-control" />
						<span class="help-block">dias</span>
					</div>
				</div>
			</div>
		</div>
		{% endif %}
	</div>

	<div id="div9">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Google Site Verificao</h3> 
			</div> 
			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">
						Insira sua TAG completa: 
					</label>
					<div class="col-md-10">
						<input type="text" name="SiteVerifica" id="SiteVerifica" value="{{ SiteVerifica|safe }}" class="form-control" />
						<small class="help-block">Exemplo : <img src="images/site_verifica.jpg" ></small>
					</div>
				</div>
			</div>
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Google Tag Manager</h3> 
			</div> 

			<div class="panel-body">

				<div class="form-group">
					<label class="col-md-2 control-label">
						Google Tag Manager Script:
					</label>
					<div class="col-md-10">
						<textarea name="TagManager" id="TagManager" class="form-control" rows="4">{{ TagManager|safe }}</textarea>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">
						Google Tag Manager (noscript):
					</label>
					<div class="col-md-10">
						<textarea name="TagManagerboby" id="TagManagerboby" class="form-control" rows="4">{{ TagManagerboby|safe }}</textarea>
					</div>
				</div>

				
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Google Avaliaes de Consumidores</h3> 
			</div> 
			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">
						Ativar Avaliaes na finalizao ?
					</label>
					<div class="col-md-10">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="AttAvaliacoes" id="AttAvaliacoes" value="ON" {{ IsAttAvaliacoes|safe }} />
							<label for="AttAvaliacoes">Sim!</label>
						</div>
					</div>
				</div>
				<div id="H01" style="display: none;">
					<div class="form-group">
						<label class="col-md-2 control-label">
							Informe sua Merchant Id: 
						</label>
						<div class="col-md-10">
							<input type="text" name="MerchantId" id="MerchantId" value="{{ MerchantId|safe }}" class="form-control" />
							<small class="help-block">Exemplo : 12125421215</small>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-md-2 control-label">
							Prazo de dias para entrega: 
						</label>
						<div class="col-md-10">
							<input type="text" name="MerchantDias" id="MerchantDias" value="{{ MerchantDias|safe }}" class="form-control" />
						</div>
					</div>
									
					<div class="form-group">
						<label class="col-md-2 control-label">
							Ativar selo no Rodap ?
						</label>
						<div class="col-md-10">
							<div class="checkbox checkbox-primary">
								<input type="checkbox" name="AttSelomerchant" id="AttSelomerchant" value="ON" {{ IsAttSelomerchant|safe }} />
								<label for="AttSelomerchant">Sim!</label>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Facebook</h3> 
			</div> 

			<div class="panel-body">

				<div class="form-group">
					<label class="col-md-2 control-label">
						Facebook Pixel Code:
					</label>
					<div class="col-md-10">
						<textarea name="FacePixel" id="FacePixel" class="form-control" rows="4">{{ FacePixel|safe }}</textarea>
					</div>
				</div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">Extra</h3> 
			</div> 

			<div class="panel-body">

				<div class="form-group">
					<label class="col-md-2 control-label">
						Tag &lt;head&gt;&lt;/head&gt;:
					</label>
					<div class="col-md-10">
						<textarea name="ExtraHead" id="ExtraHead" class="form-control" rows="4">{{ ExtraHead|safe }}</textarea>
						<small class="help-block">Insira aqui qualquer outra tag ou Script ou Pixel que queira inserir na tag &lt;head&gt;&lt;/head&gt;</small>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-2 control-label">
						Tag &lt;body&gt;&lt;/body&gt;:
					</label>
					<div class="col-md-10">
						<textarea name="ExtraBody" id="ExtraBody" class="form-control" rows="4">{{ ExtraBody|safe }}</textarea>
						<small class="help-block">Insira aqui qualquer outra tag ou Script ou Pixel que queira inserir na tag &lt;body&gt;&lt;/body&gt;</small>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="row">
		<div class="col-sm-12">
			<input type="submit" disabled="disabled" name="IndexCreateButton" value="{% lang 'Save' %}" id="IndexCreateButton" class=" btn btn-primary">
			<input type="reset" onclick="ConfirmCancel()" value="{% lang 'Cancel' %}" class="btn btn-danger">
		</div>
	</div>
</form>

<div id="stmpTestModal" style="display: none;">
	<div class="ModalTitle">{% lang 'TestSMTPSettings' %}</div>
	<div class="ModalContent" style="padding:5px;">
		<div>
			<div style="width: 208px; padding: 0px; margin: 10px auto 10px auto; position: relative; background: url('images/loadingAnimation.gif') no-repeat;">
				<div id="ProgressBarPercentage" style="margin: 0; padding: 0; height: 13px; width: 0%; background: url('images/progressbar.gif') no-repeat; background-color: transparent;">
					&nbsp;
				</div>
			</div>
		</div>
		
		<div style="text-align: center; height: 20px;" id="ProgressNote">{% lang 'TestSMTPSettingsNote' %}</div>
	</div>
</div>
<script type="text/javascript" src="script/product.images.reprocess.js?{{ JSCacheToken }}"></script>
<script type="text/javascript">

	ProcessProductImages.lang['ModalTitle'] = '{% lang 'ProcessImagesModalTitle' %}';
	ProcessProductImages.lang['ProcessProgress'] = '{% lang 'ProcessImagesProgress' %}';
	ProcessProductImages.lang['ProcessFinished'] = '{% lang 'ProcessImagesFinished' %}';

	lang['ProductImagesStorewideThumbnailWidthInvalidValue']	= '{% lang 'ProductImagesStorewideThumbnailWidthInvalidValue' %}';
	lang['ProductImagesStorewideThumbnailHeightInvalidValue'] = '{% lang 'ProductImagesStorewideThumbnailHeightInvalidValue' %}';
	lang['ProductImagesProductPageImageWidthInvalidValue']	= '{% lang 'ProductImagesProductPageImageWidthInvalidValue' %}';
	lang['ProductImagesProductPageImageHeightInvalidValue']	= '{% lang 'ProductImagesProductPageImageHeightInvalidValue' %}';
	lang['ProductImagesGalleryThumbnailWidthInvalidValue']	= '{% lang 'ProductImagesGalleryThumbnailWidthInvalidValue' %}';
	lang['ProductImagesGalleryThumbnailHeightInvalidValue']	= '{% lang 'ProductImagesGalleryThumbnailHeightInvalidValue' %}';
	lang['ProductImagesZoomImageWidthInvalidValue']	= '{% lang 'ProductImagesZoomImageWidthInvalidValue' %}';
	lang['ProductImagesZoomImageHeightInvalidValue']	= '{% lang 'ProductImagesZoomImageHeightInvalidValue' %}';

	$(document).ready(function() {
		$('#ReprocessImages').bind('click', ProcessProductImages.launch);
	});

	function ShowTab(T) {
		i = 0;
		while (document.getElementById("tab" + i) != null) {
			document.getElementById("div" + i).style.display = "none";
			document.getElementById("tab" + i).className = "";
			i++;
		}

		document.getElementById("div" + T).style.display = "";
		document.getElementById("tab" + T).className = "active";

		document.getElementById("currentTab").value = T;
	}

	function ToggleDefaultProductImage()
	{
		if($('.DefaultProductImage:checked').val() == 'custom') {
			$('#DefaultProductImageCustomContainer').show();
		}
		else {
			$('#DefaultProductImageCustomContainer').hide();
		}
	}

	function ToggleSystemLogging() {
		var siblings = $('.SystemLoggingToggle');
		if(g('EnableSystemLogging').checked) {
			siblings.show();
		}
		else {
			siblings.hide();
		}
	}
	ToggleSystemLogging();

	function ToggleAdministratorLogging() {
		var siblings = $('.AdministratorLoggingToggle');
		if(g('EnableAdministratorLogging').checked) {
			siblings.show();
		}
		else {
			siblings.hide();
		}
	}
	ToggleAdministratorLogging();

	function ConfirmCancel()
	{
		if(confirm("{% lang 'ConfirmCancelSettings' %}"))
			document.location.href = "index.php?ToDo=viewSettings";
	}

	$('#frmSettings').submit(function() {
		var StoreName = g("StoreName");
		var StoreAddress = g("StoreAddress");
		var SSL = g("SSL");
		var SharedSSL = g("UseSharedSSL");
		var SharedSSLPath = g("SharedSSLPath");
		var SubdomainSSL = g("UseSubdomainSSL");
		var SubdomainSSLPath = g("SubdomainSSLPath");
		var ShopPath = g("ShopPath");
		var CharacterSet = g("CharacterSet");
		var MetaKeywords = g("MetaKeywords");
		var MetaDesc = g("MetaDesc");
		var DownloadDirectory = g("DownloadDirectory");
		var ImageDirectory = g("ImageDirectory");
		var serverStamp = g("serverStamp");
		var AdminEmail = g("AdminEmail");
		var OrderEmail = g("OrderEmail");
		var DefaultTaxRate = g("DefaultTaxRate");
		var WeightMeasurement = g("WeightMeasurement");
		var LengthMeasurement = g("LengthMeasurement");
		var DisplayDateFormat = g("DisplayDateFormat");
		var ExportDateFormat = g("ExportDateFormat");
		var ExtendedDisplayDateFormat = g("ExtendedDisplayDateFormat");
		var CategoryPerRow = g("CategoryPerRow");
		var CategoryImageWidth = g("CategoryImageWidth");
		var CategoryImageHeight = g("CategoryImageHeight");
		var CategoryDefaultImage = g("CategoryDefaultImage");
		var BrandPerRow = g("BrandPerRow");
		var BrandImageWidth = g("BrandImageWidth");
		var BrandImageHeight = g("BrandImageHeight");
		var BrandDefaultImage = g("BrandDefaultImage");
		var HomeFeaturedProducts = g("HomeFeaturedProducts");
		var HomeNewProducts = g("HomeNewProducts");
		var HomeBlogPosts = g("HomeBlogPosts");
		var CategoryProductsPerPage = g("CategoryProductsPerPage");
		var CategoryListDepth = g("CategoryListDepth");
		var ProductReviewsPerPage = g("ProductReviewsPerPage");
		var TagCartQuantityBoxes = g("TagCartQuantityBoxes");
		var ShowAddToCartQtyBox = g("ShowAddToCartQtyBox");
		var CaptchaEnabled = g("CaptchaEnabled");
		var ShowThumbsInCart = g("ShowThumbsInCart");
		var ShowCartSuggestions = g("ShowCartSuggestions");
		var AutoApproveReviews = g("AutoApproveReviews");
		var RSSItemsLimit = g("RSSItemsLimit");
		var RSSCacheTime = g("RSSCacheTime");
		var HighestOrderNumber = parseInt('{{ HighestOrderNumber|safe }}');

		if(StoreName.value == "") {
			ShowTab(0);
			alert("{% lang 'EnterStoreName' %}");
			StoreName.focus();
			return false;
		}

		if(StoreAddress.value == "") {
			ShowTab(0);
			alert("{% lang 'EnterStoreAddress' %}");
			StoreAddress.focus();
			return false;
		}

		if (SharedSSL.checked) {
			if (SharedSSLPath.value == "" | SharedSSLPath.value == "http://") {
				ShowTab(0);
				alert("{% lang 'EnterSharedSSL' %}");
				SharedSSLPath.focus();
				SharedSSLPath.select();
				return false;
			}
		}
		else if (SubdomainSSL.checked) {
			if (SubdomainSSLPath.value == "" | SubdomainSSLPath.value == "http://") {
				ShowTab(0);
				alert("{% lang 'EnterSubdomainSSL' %}");
				SubdomainSSLPath.focus();
				SubdomainSSLPath.select();
				return false;
			}
		}

		

		if(ShopPath.value == "" || ShopPath.value == "http://") {
			ShowTab(0);
			alert("{% lang 'EnterShopPath' %}");
			ShopPath.focus();
			ShopPath.select();
			return false;
		}

		if('{{ CharacterSet }}' != $('#CharacterSet').val()) {
			var confirmMsg = '{% jslang 'ConfirmChangeCharacterSet' %}';

			if('{{ CharacterSet }}' == 'UTF-8') {
				confirmMsg = '{% jslang 'ConfirmChangeCharacterSetUTF8' %}';
			}

			if(!confirm(confirmMsg)) {
				ShowTab(0);
				$('#CharacterSet').focus();
				return false;
			}
		}

		if($('#StartingOrderNumber').val() <= HighestOrderNumber) {
			ShowTab(7);
			var tooLowLang = '{% lang 'StartingOrderNumberTooLow' %}';
			tooLowLang = tooLowLang.replace(':currentHighest', HighestOrderNumber);
			tooLowLang = tooLowLang.replace(':lowestPossible', (HighestOrderNumber+1));
			alert(tooLowLang);
			$('#StartingOrderNumber').focus();
			return false;
		}

		if(DownloadDirectory.value == "") {
			ShowTab(0);
			alert("{% lang 'EnterDownloadDirectory' %}");
			DownloadDirectory.focus();
			return false;
		}

		if(ImageDirectory.value == "") {
			ShowTab(0);
			alert("{% lang 'EnterImageDirectory' %}");
			ImageDirectory.focus();
			return false;
		}

		if(serverStamp.value == "") {
			ShowTab(0);
			alert("{% lang 'EnterLicenseKey' %}");
			serverStamp.focus();
			return false;
		}

		if(AdminEmail.value.indexOf("@") == -1 || AdminEmail.value.indexOf(".") == -1) {
			ShowTab(0);
			alert("{% lang 'EnterValidAdminEmail' %}");
			AdminEmail.focus();
			AdminEmail.select();
			return false;
		}

		if (!ValidateSMTPSettings()) {
			return false;
		} else {
			if (smtpChecked == false) {
				TestSMTPMailSettings(function() {
					// submit again if test is successful
					$('#frmSettings').submit();
				});
				return false;
			}
		}

		if(OrderEmail.value.indexOf("@") == -1 || OrderEmail.value.indexOf(".") == -1) {
			ShowTab(0);
			alert("{% lang 'EnterValidOrderEmail' %}");
			OrderEmail.focus();
			OrderEmail.select();
			return false;
		}

		if(!$('#DimensionsDecimalToken').val()) {
			alert('{% lang 'EnterDecimalToken' %}');
			$('#DimensionsDecimalToken').focus();
			$('#DimensionsDecimalToken').select();
			return false;
		}

		if(!$('#DimensionsThousandsToken').val()) {
			alert('{% lang 'EnterThousandsToken' %}');
			$('#DimensionsThousandsToken').focus();
			$('#DimensionsThousandsToken').select();
			return false;
		}

		if(!$('#DimensionsDecimalPlaces').val() || isNaN($('#DimensionsDecimalPlaces').val())) {
			alert('{% lang 'EnterDecimalPlaces' %}');
			$('#DimensionsDecimalPlaces').focus();
			$('#DimensionsDecimalPlaces').select();
			return false;
		}

		if(DisplayDateFormat.value == "") {
			ShowTab(1);
			alert("{% lang 'EnterDisplayDateFormat' %}");
			DisplayDateFormat.focus();
			return false;
		}

		if(ExportDateFormat.value == "") {
			ShowTab(1);
			alert("{% lang 'EnterExportDateFormat' %}");
			ExportDateFormat.focus();
			return false;
		}

		if(ExtendedDisplayDateFormat.value == "") {
			ShowTab(1);
			alert("{% lang 'EnterExtendedDisplayDateFormat' %}");
			ExtendedDisplayDateFormat.focus();
			return false;
		}

		if(isNaN(HomeFeaturedProducts.value) || HomeFeaturedProducts.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterHomeFeaturedProducts' %}");
			HomeFeaturedProducts.focus();
			HomeFeaturedProducts.select();
			return false;
		}

		if(isNaN(HomeNewProducts.value) || HomeNewProducts.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterHomeNewProducts' %}");
			HomeNewProducts.focus();
			HomeNewProducts.select();
			return false;
		}

		if(isNaN(HomeBlogPosts.value) || HomeBlogPosts.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterHomeBlogPosts' %}");
			HomeBlogPosts.focus();
			HomeBlogPosts.select();
			return false;
		}

		if($('.DefaultProductImage:checked').val() == 'custom') {
			if(($('#DefaultProductImageCustomCurrent').css('display') == 'none' || $('#DefaultProductImageCustom').val()) && !IsValidImageExtension($('#DefaultProductImageCustom').val())) {
				ShowTab(2);
				alert('{% lang 'ChooseDefaultProductImageUpload' %}');
				$('#DefaultProductImageCustom').focus();
				return false;
			}
		}

		if(isNaN(CategoryProductsPerPage.value) || CategoryProductsPerPage.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterCategoryProductsPerPage' %}");
			CategoryProductsPerPage.focus();
			CategoryProductsPerPage.select();
			return false;
		}

		if(isNaN(CategoryListDepth.value) || CategoryListDepth.value == "" || CategoryListDepth.value<=0) {
			ShowTab(2);
			alert("{% lang 'EnterCategoryListDepth' %}");
			CategoryListDepth.focus();
			CategoryListDepth.select();
			return false;
		}

		if(isNaN(ProductReviewsPerPage.value) || ProductReviewsPerPage.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterProductReviewsPerPage' %}");
			ProductReviewsPerPage.focus();
			ProductReviewsPerPage.select();
			return false;
		}

		if(isNaN(CategoryPerRow.value) || CategoryPerRow.value == "" || CategoryPerRow.value <= 0) {
			ShowTab(2);
			alert("{% lang 'EnterCategoryPerRow' %}");
			CategoryPerRow.focus();
			CategoryPerRow.select();
			return false;
		}

		if(isNaN(BrandPerRow.value) || BrandPerRow.value == "" || BrandPerRow.value <= 0) {
			ShowTab(2);
			alert("{% lang 'EnterBrandPerRow' %}");
			BrandPerRow.focus();
			BrandPerRow.select();
			return false;
		}

		if(isNaN(CategoryImageWidth.value) || CategoryImageWidth.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterCategoryImageWidth' %}");
			CategoryImageWidth.focus();
			CategoryImageWidth.select();
			return false;
		}

		if(isNaN(CategoryImageHeight.value) || CategoryImageHeight.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterCategoryImageHeight' %}");
			CategoryImageHeight.focus();
			CategoryImageHeight.select();
			return false;
		}

		if(isNaN(BrandImageWidth.value) || BrandImageWidth.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterBrandImageWidth' %}");
			BrandImageWidth.focus();
			BrandImageWidth.select();
			return false;
		}

		if(isNaN(BrandImageHeight.value) || BrandImageHeight.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterBrandImageHeight' %}");
			BrandImageHeight.focus();
			BrandImageHeight.select();
			return false;
		}

		if(CategoryDefaultImage.value != "") {
			// Make sure it has a valid extension
			img = CategoryDefaultImage.value.split(".");
			ext = img[img.length-1].toLowerCase();

			if(ext != "jpg" && ext != "png" && ext != "gif") {
				ShowTab(2);
				alert("{% lang 'ChooseValidImage' %}");
				CategoryDefaultImage.focus();
				CategoryDefaultImage.select();
				return false;
			}
		}

		if(BrandDefaultImage.value != "") {
			// Make sure it has a valid extension
			img = BrandDefaultImage.value.split(".");
			ext = img[img.length-1].toLowerCase();

			if(ext != "jpg" && ext != "png" && ext != "gif") {
				ShowTab(2);
				alert("{% lang 'ChooseValidImage' %}");
				BrandDefaultImage.focus();
				BrandDefaultImage.select();
				return false;
			}
		}

		if ($('#FacebookLikeButtonEnabled').attr('checked') && !$('#FacebookLikeButtonAdminIds').val()) {
			// no admin id entered for facebook
			ShowTab(2);
			alert("{% jslang 'FacebookAdminIdsRequired' %}");
			$('#FacebookLikeButtonAdminIds').focus();
			return false;
		}

		// check image sizes
		var imageSizeChanges = false;
		var imageValueProblem  = false;

		$('.SetOriginalImageSizeValue').each(function() {
			if(isNaN($(this).val()) || $(this).val() == '') {

				imageValueProblem = true;

				var LanguageVariableKey = $(this).attr('id') + 'InvalidValue';
				LanguageVariableKey = LanguageVariableKey.replace('_height', 'Height');
				LanguageVariableKey = LanguageVariableKey.replace('_width', 'Width');

				var alertMsg = lang[LanguageVariableKey];

				if($(this).val().indexOf('%') != -1 || $(this).val().indexOf('px') != -1) {
					alertMsg += '{% lang 'EnterNumberForImageSizesMeasurements' %}';
				}

				ShowTab(8);
				alert(alertMsg);

				$(this).focus();
				$(this).select();

				return false;
			}
		});

		if(imageValueProblem) {
			return false;
		}

		$('.SetOriginalImageSizeValue').each(function() {
			if($(this).val() != $.data(this, "origValue")) {
				imageSizeChanges = true;
				return;
			}
		});

		if(imageSizeChanges){
			if(confirm('{% lang 'ShouldImagesBeResized' %}')) {
				$('#AutoResizeImages').val('yes');
			}
		}

		if(isNaN($('#TagCloudMinSize').val()) || $('#TagCloudMinSize').val() == '') {
			ShowTab(2);
			alert('{% lang 'EnterTagCloudMinSize' %}');
			$('#TagCloudMinSize').focus();
			$('#TagCloudMinSize').select();
			return false;
		}

		if(isNaN($('#TagCloudMaxSize').val()) || $('#TagCloudMaxSize').val() == '') {
			ShowTab(2);
			alert('{% lang 'EnterTagCloudMaxSize' %}');
			$('#TagCloudMaxSize').focus();
			$('#TagCloudMaxSize').select();
			return false;
		}

		if(isNaN(RSSItemsLimit.value) || RSSItemsLimit.value == "") {
			ShowTab(2);
			alert("{% lang 'EnterRSSItemsLimit' %}");
			RSSItemsLimit.focus();
			RSSItemsLimit.select();
			return false;
		}

		if(isNaN(RSSCacheTime.value)) {
			ShowTab(2);
			alert("{% lang 'EnterValidRSSCacheTime' %}");
			RSSCacheTime.focus();
			RSSCacheTime.select();
			return false;
		}

		if(ValidateFTPSettings() == false)
		{
			return false;
		}

		if($("#BackupsAutomatic:checked").val() && !$("#BackupsAutomaticDatabase:checked").val() && !$("#BackupsAutomaticImages:checked").val() && !$("#BackupsAutomaticDownloads:checked").val()) {
			alert("{% lang 'AtLeastOnAutomaticBackup' %}");
			return false;
		}

		if(!$("#SearchResultsPerPage").val() || isNaN($("#SearchResultsPerPage").val())) {
			ShowTab(4);
			alert("{% lang 'EnterSearchResultsPerPage' %}");
			$("#SearchResultsPerPage").focus();
			$("#SearchResultsPerPage").select();
			return false;
		}

		if($('#tab5').css('display') != 'none') {
			if(g('EnableSystemLogging').checked == true) {
				var f = g('SystemLogTypes');
				if(f.selectedIndex == -1) {
					ShowTab(5);
					alert('{% lang 'SelectOneMoreLoggingTypes' %}');
					g('SystemLogTypes').focus();
					return false;
				}
				var f = g('SystemLogSeverity');
				if(f.selectedIndex == -1) {
					ShowTab(5);
					alert('{% lang 'SelectOneMoreLoggingSeverities' %}');
					g('SystemLogSeverity').focus();
					return false;
				}
				if(isNaN(g('SystemLogMaxLength').value) && g('SystemLogMaxLength').value != '') {
					ShowTab(5);
					alert('{% lang 'EnterValidSystemLogLength' %}');
					g('SystemLogMaxLength').focus();
					g('SystemLogMaxLength').select();
					return false;
				}
			}

			if(g('EnableAdministratorLogging').checked == true) {
				if(isNaN(g('AdministratorLogMaxLength').value) && g('AdministratorLogMaxLength').value != '') {
					ShowTab(5);
					alert('{% lang 'EnterValidAdministratorLogLength' %}');
					g('AdministratorLogMaxLength').focus();
					g('AdministratorLogMaxLength').select();
					return false;
				}
			}
		}
		if($('#tab6').css('display') != 'none') {
			if($('#VendorLogoUploading:checked').val()) {
				if(isNaN($('#VendorLogoSizeW').val()) && $('#VendorLogoSizeW').val() != '') {
					alert('{% lang 'EnterVendorLogoSizeDimensions' %}');
					ShowTab(6);
					$('#VendorLogoSizeW').focus();
					$('#VendorLogoSizeW').select();
					return false;
				}

				if(isNaN($('#VendorLogoSizeH').val()) && $('#VendorLogoSizeH').val() != '') {
					alert('{% lang 'EnterVendorLogoSizeDimensions' %}');
					ShowTab(6);
					$('#VendorLogoSizeH').focus();
					$('#VendorLogoSizeH').select();
					return false;
				}
			}

			if($('#VendorPhotoUploading:checked').val()) {
				if(isNaN($('#VendorPhotoSizeW').val()) && $('#VendorPhotoSizeW').val() != '') {
					alert('{% lang 'EnterVendorPhotoSizeDimensions' %}');
					ShowTab(6);
					$('#VendorPhotoSizeW').focus();
					$('#VendorPhotoSizeW').select();
					return false;
				}

				if(isNaN($('#VendorPhotoSizeH').val()) && $('#VendorPhotoSizeH').val() != '') {
					alert('{% lang 'EnterVendorPhotoSizeDimensions' %}');
					ShowTab(6);
					$('#VendorPhotoSizeH').focus();
					$('#VendorPhotoSizeH').select();
					return false;
				}
			}
		}

		return true;
	});

	function TestSSL() {
		// See if the site is capable of handling HTTPS requests
		var https_url = "{{ HTTPSUrl|safe }}";

		alert("{% lang 'TestSSLText' %}");
		window.open(https_url);
	}

	function ToggleLocalBackups()
	{
		if($('#BackupsLocal:checked').val()) {
			$('#BackupsAutomaticLocal').attr('disabled', false);
			CheckAutomaticBackups();
		}
		else {
			$('#BackupsAutomaticLocal').attr('disabled', true);
			CheckAutomaticBackups();
		}
	}

	function CheckAutomaticBackups()
	{
		if(!$('#BackupsLocal:checked').val() && (!$('#BackupsRemoteFTPContainer:visible') || !$('#BackupsRemoteFTP:checked').val())) {
			$('#BackupsAutomatic').attr('disabled', true);
			$('#BackupsAutomatic').attr('checked', false);
			$('.BackupsAutomaticContainer').hide();
		}
		else {
			$('#BackupsAutomatic').attr('disabled', false);
			ToggleAutomaticBackups();
		}
	}

	function ToggleFTPBackups()
	{
		if($('#BackupsRemoteFTPContainer:visible')) {
			if($('#BackupsRemoteFTP:checked').val()) {
				$('#BackupsRemoteFTPSettings').show();
				$('#BackupsAutomaticFTP').attr('disabled', false);
			}
			else {
				$('#BackupsRemoteFTPSettings').hide();
				$('#BackupsAutomaticFTP').attr('disabled', true);
				$('#BackupsAutomaticMethod').get()[0].selectedIndex = 0;
			}
		}
		else {
			$('#BackupsAutomaticFTP').attr('disabled', true);
			$('#BackupsAutomaticMethod').get()[0].selectedIndex = 0;
		}
		CheckAutomaticBackups();
	}

	function ToggleAutomaticBackups()
	{
		if($('#BackupsAutomatic:checked').val()) {
			$('.BackupsAutomaticContainer').show();
		} else {
			$('.BackupsAutomaticContainer').hide();
		}
	}

	ToggleLocalBackups();
	ToggleAutomaticBackups();
	ToggleFTPBackups();

	function DoTestFTPSettings() {
		result = ValidateFTPSettings();
		if(result == false) return false;

		var host = $('#BackupsRemoteFTPHost').val();
		var user = $('#BackupsRemoteFTPUser').val();
		var pass = $('#BackupsRemoteFTPPass').val();
		var path = $('#BackupsRemoteFTPPath').val();

		$('#TestFTPSettings').attr('disabled', true);
		$('#TestFTPSettings').val('{% lang 'TestingFTPSettings' %}');
		$('#TestFTPSettingsLoading').show();

		jQuery.ajax({
			type: 'POST',
			url: 'remote.php?w=TestFTPSettings',
			data: 'host='+host+'&user='+user+'&pass='+pass+'&path='+path,
			dataType: 'script',
			success: function() {
				$('#TestFTPSettings').attr('disabled', false);
				$('#TestFTPSettings').val('{% lang 'TestFTPSettings' %}');
				$('#TestFTPSettingsLoading').hide();
			}
		});
	}

	function ValidateFTPSettings()
	{
		if($('#BackupsRemoteFTPContainer:visible') && $('#BackupsRemoteFTP:checked').val()) {
			if($('#BackupsRemoteFTPHost').val() == '') {
				ShowTab(3);
				alert('{% lang 'EnterFTPHostname' %}');
				$('#BackupsRemoteFTPHost').focus();
				$('#BackupsRemoteFTPHost').select();
				return false;
			}
			if($('#BackupsRemoteFTPUser').val() == '') {
				ShowTab(3);
				alert('{% lang 'EnterFTPUsername' %}');
				$('#BackupsRemoteFTPUser').focus();
				$('#BackupsRemoteFTPUser').select();
				return false;
			}
			if($('#BackupsRemoteFTPPass').val() == '') {
				ShowTab(3);
				alert('{% lang 'EnterFTPPassword' %}');
				$('#BackupsRemoteFTPPass').focus();
				$('#BackupsRemoteFTPPass').select();
				return false;
			}
		}
		return true;
	}

	function ToggleMailSettings() {
		if($('#MailUseSMTP').attr('checked') == true) {
			$('.SMTPOptions').show();
		}
		else {
			$('.SMTPOptions').hide();
		}
	}

	var smtpChecked = true;
	var disableLoadingIndicator;

	function startSMTPTest() {
		if(!ValidateSMTPSettings()) {
			return;
		}

		TestSMTPMailSettings();
	}

	function TestSMTPMailSettings(callback) {
		$('#TestSMTPSettings').attr('disabled', true);
		$('#TestSMTPSettings').val('{% lang 'TestingSMTPSettings' %}');

		var email = $('#AdminEmail').val();
		var host = $('#MailSMTPServer').val();
		var user = $('#MailSMTPUsername').val();
		var pass = $('#MailSMTPPassword').val();
		var port = $('#MailSMTPPort').val();

		disableLoadingIndicator = true;
		$.iModal({
			type: 'inline',
			inline: '#stmpTestModal',
			width: 400,
			close: false
		});

		jQuery.ajax({
			type: 'POST',
			url: 'remote.php?w=TestSMTPSettings',
			data: 'AdminEmail='+escape(email)+'&MailSMTPServer='+escape(host)+'&MailSMTPUsername='+escape(user)+'&MailSMTPPassword='+escape(pass)+'&MailSMTPPort='+escape(port),
			dataType: 'xml',
			success: function(xml) {
				$.iModal.close();

				$('#TestSMTPSettings').attr('disabled', false);
				$('#TestSMTPSettings').val('{% lang 'TestSMTPSettings' %}');
				var message = $('message', xml).text();
				message = message.replace('\\n', '\n');
				message = message.replace('\\n', '\n');
				if($('status', xml).text() == 1) {
					smtpChecked = true;
					if (callback) {
						callback.call(this);
					} else {
						alert(message);
					}
				}
				else {
					// test failed
					smtpChecked = false;
					ShowTab(0);
					$('#MailSMTPServer').focus();
					alert(message);
				}

				disableLoadingIndicator = false;
			}
		});
	}

	function ValidateSMTPSettings() {
		if($('#MailUseSMTP').attr('checked') == true) {
			if(!$('#MailSMTPServer').val()) {
				alert('{% lang 'EnterSMTPServer' %}');
				$('#MailSMTPServer').focus();
				return false;
			}
		}

		return true;
	}

	var sslChecked = false;
	var sslWorks = false;

	function checkSSLWorks() {
		if(sslChecked) {
			return sslWorks;
		}
		sslChecked = true;
		var imageLocation = document.location.toString();
		imageLocation = imageLocation.replace('http:', 'https:').replace(/index.php(.*)/g, '') + 'images/1x1.gif';

		$('<img />').load(function () {
			sslWorks = true;
		}).error(function () {
			sslWorks = false;
		}).attr('src', imageLocation);

		return sslWorks;
	}

	$('#UseControlPanelSSL').bind('click', function () {
		if($(this).is(':checked')) {
			checkSSLWorks();
		}
	});

	$(document).ready(function() {
		ShowTab({{ CurrentTab|safe }});

		$('input[type=submit]').attr('disabled', '');

		if ($('#EnableCustomersAlsoViewed:checked').val()) {
			$('.HideIfCustomersAlsoViewedDisabled').show();
		} else {
			$('.HideIfCustomersAlsoViewedDisabled').hide();
		}

		if($('#ShowInventory:checked').val()) {
			$('.HideIfShowInventoryDisabled').show();
		}
		else {
			$('.HideIfShowInventoryDisabled').hide();
		}

		ToggleDefaultProductImage();
		$('.DefaultProductImage[type=radio]').click(ToggleDefaultProductImage);

		$('.SetOriginalImageSizeValue').each(function() {
			$.data(this, "origValue", $(this).val());
		});

		$("input:radio[name='UseSSL']").click(function() {
			$("input:radio[name='UseSSL']").each(function() {
				if($(this).is(':checked')) {
					$(this).parent('label').nextAll('.NodeJoin:first').show();
				}
				else {
					$(this).parent('label').nextAll('.NodeJoin:first').hide();
				}
			});

			if($("#NoSSL").is(':checked')) {
				$('#UseControlPanelSSL').attr('disabled', 'disabled').removeAttr('checked');
			} else {
				$('#UseControlPanelSSL').removeAttr('disabled');
			}
		});

		$("input:radio[name='UseSSL']:checked").trigger('click');

		if('{{ RunImageResize|safe }}' == '1') {
			ProcessProductImages.launch();
		}

		if($('#DownForMaintenance').is(':checked')) {
			$('#DownForMaintenanceMessageRow').css('display', '');
		}

		$('#DownForMaintenance').bind('click', function () {
			if($(this).is(':checked')) {
				$('#DownForMaintenanceMessageRow').css('display', '');
			} else {
				$('#DownForMaintenanceMessageRow').css('display', 'none');
			}
		});

		if($('#AttAvaliacoes').is(':checked')) {
			$('#H01').css('display', '');
		}

		$('#AttAvaliacoes').bind('click', function () {
			if($(this).is(':checked')) {
				$('#H01').css('display', '');
			} else {
				$('#H01').css('display', 'none');
			}
		});

		if($('#Attrecaptchav3').is(':checked')) {
			$('#H02').css('display', '');
		}

		$('#Attrecaptchav3').bind('click', function () {
			if($(this).is(':checked')) {
				$('#H02').css('display', '');
			} else {
				$('#H02').css('display', 'none');
			}
		});


		$("#FacebookLikeButtonEnabled").change(function() {
			if($(this).is(':checked')) {
				$(this).parent('label').nextAll('.NodeJoin:first').show();
			}
			else {
				$(this).parent('label').nextAll('.NodeJoin:first').hide();
			}
		});

		// if any SMTP options has changed, force a test before save
		$(".SMTPOptions input:text").each(function() {
			$(this).bind('change', function() {
				smtpChecked = false;
			});
		});

		{% if not TPL_CFG.EnableFlyoutMenuSupport %}
			// prevent selection of flyout style if not supported by current temlpate
			$('#CategoryListStyle').change(function(event){
				if ($(this).val() == 'flyout') {
					alert("{% jslang 'CategoryListStyleFlyoutNotSupported' %}");
					$(this).val('static');
				}
			});
		{% endif %}
	});
</script>
