<style>
	.form-control{
		width: 80%!important;
	}
</style>

{% import 'macros/util.tpl' as util %}
<form action="index.php?ToDo=saveUpdatedCheckoutSettings" name="frmCheckoutSettings" id="frmCheckoutSettings" method="post" onsubmit="return ValidateForm(CheckCheckoutSettingsForm)" class="form-horizontal" role="form">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'CheckoutSettings' %}</h4>
			<p>{% lang 'CheckoutSettingsIntro' %}</p>
			
				<input type="submit" value="{% lang 'Save' %}" class="FormButton SaveButton btn btn-success" />
				<input type="reset" value="{% lang 'Cancel' %}" class="FormButton CancelButton btn btn-danger" onclick="ConfirmCancel()" />
		</div>
	</div>
<br>
	<div class="row">
		<div class="col-sm-12">
			<div id="CheckoutStatus">{{ Message|safe }}</div>
			<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="margin-bottom: 20px;">
				<li class="tab"><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'GeneralSettings' %}</a></li>
				{{ CheckoutTabs|safe }}
				<br class="Clear" />
			</ul>
		</div>
	</div>

	<input id="currentTab" name="currentTab" value="0" type="hidden">
	<div id="div0">
		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'CheckoutSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'CheckoutMethods' %}</label>
					<div class="col-md-4">
						<div id="BuiltInGatewayOption" style="{{ HideBuiltInGateway|safe }}">
							<div>
								<label><input type="radio" id="CheckoutMethodBuiltIn" name="builtInGateway" value="1" {{ UseBuiltInGatewayChecked|safe }} /> {{ UseBuiltInGateway|safe }}</label>
							</div>

							<div class="builtInGateway builtInGateway_1">
								<div class="BuiltInGatewayForm">
									{{ BuiltInGatewayErrors|safe }}
									<div class="BuiltInCheckoutIntro">
										{{ BuiltInGatewayIntro|safe }}
									</div>
									{{ BuiltInGatewayProperties|safe }}
								</div>
							</div>

							<div>
								<label><input type="radio" id="CheckoutMethodCustom" name="builtInGateway" value="0" {{ UseCustomGatewayChecked|safe }} /> {% lang 'UseCustomGateway' %}</label>
							</div>
						</div>
						
						<div class="builtInGateway builtInGateway_0">
							<select size="20" multiple="multiple" name="checkoutproviders[]" id="checkoutproviders" class="form-control ISSelectReplacement {{ CheckoutProviderClass|safe }}">
								{{ CheckoutProviders|safe }}
							</select>
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'EnableOrderComments' %}</label>
					<div class="col-md-4">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="EnableOrderComments" id="EnableOrderComments" value="1" {{ IsEnableOrderComments|safe }} />
	                        <label for="EnableOrderComments">{% lang 'YesEnableOrderComments' %}</label>
	                    </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'EnableOrderTermsAndConditions' %}</label>
					<div class="col-md-4">
						<div class="checkbox checkbox-primary">
							<input onclick="$('.OrderTermsAndConditions').toggle();" type="checkbox" name="EnableOrderTermsAndConditions" id="EnableOrderTermsAndConditions" value="1" {{ IsEnableOrderTermsAndConditions|safe }} />
	                        <label for="EnableOrderTermsAndConditions">{% lang 'YesEnableOrderTermsAndConditions' %}</label>
	                    </div>

	                    <div style="{{ HideOrderTermsAndConditions|safe }}" class="OrderTermsAndConditions">
	                    	<input class="form-control OrderTermsAndConditionsLink" name="OrderTermsAndConditionsLink" value="{{ OrderTermsAndConditionsLink|safe }}">
	                    	<small>Informe o link para a pgina com os termos</small>
	                    </div>
					</div>
				</div>
			</div> 
		</div>

		<div class="panel panel-default">
			<div class="panel-heading"> 
				<h3 class="panel-title">{% lang 'OrderSettings' %}</h3> 
			</div> 

			<div class="panel-body">
				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'UpdateProductInventoryWhen' %}</label>
					<div class="col-md-4">
						<select name="updateinventory" id="updateinventory" class="form-control">
							<option value="1" {{ UpdateInventorySuccessfulSelected|safe }}>{% lang 'UpdateInventorySuccessfulOrder' %}</option>
							<option value="2" {{ UpdateInventoryCompletedSelected|safe }}>{% lang 'UpdateInventoryOrderCompleted' %}</option>
						</select>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'UpdateInventoryOnOrderEdit' %}</label>
					<div class="col-md-4">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="UpdateInventoryOnOrderEdit" id="UpdateInventoryOnOrderEdit" value="1" {% if config.UpdateInventoryOnOrderEdit %}checked="checked"{% endif %} />
	                        <label for="UpdateInventoryOnOrderEdit">{% lang 'YesUpdateInventoryOnOrderEdit' %}</label>
	                    </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'UpdateInventoryOnOrderDelete' %}</label>
					<div class="col-md-4">
						<div class="checkbox checkbox-primary">
							<input type="checkbox" name="UpdateInventoryOnOrderDelete" id="UpdateInventoryOnOrderDelete" value="1" {% if config.UpdateInventoryOnOrderDelete %}checked="checked"{% endif %} />
	                        <label for="UpdateInventoryOnOrderDelete">{% lang 'YesUpdateInventoryOnOrderDelete' %}</label>
	                    </div>
					</div>
				</div>

				<div class="form-group">
					<label class="col-md-2 control-label">{% lang 'EmailOnOrderStatusChange' %}</label>
					<div class="col-md-4">
						<select name="orderstatusemails[]" id="orderstatusemails" class="form-control ISSelectReplacement" size="11" multiple="multiple">
							{{ OrderStatusEmailList|safe }}
						</select>
					</div>
				</div>
			</div>
		</div>
	</div>

	{{ CheckoutDivs|safe }}

	<input type="submit" value="{% lang 'Save' %}" class="FormButton SaveButton btn btn-success" />
	<input type="reset" value="{% lang 'Cancel' %}" class="FormButton CancelButton btn btn-danger" onclick="ConfirmCancel()" />
</form>

<div id="ViewsMenu" class="DropShadow DropDownMenu" style="display: none; width:200px">
	<ul>
		{{ CheckoutFieldsOptions|safe }}
	</ul>
</div>

	<script type="text/javascript">

		function ToggleTermsAndConditions(type)
		{
			if(type == 'link') {
				$('.OrderTermsAndConditionsLink').css({display: ''});
				$('.OrderTermsAndConditionsTextarea').css({display: 'none'});
			} else {
				$('.OrderTermsAndConditionsTextarea').css({display: ''});
				$('.OrderTermsAndConditionsLink').css({display: 'none'});
			}
		}

		function checkout_selected(checkout_id) {
			if(checkout_id == 'builtin') {
				if($('input[name=builtInGateway]:checked').val() == 1) {
					return true;
				}
				else {
					return false;
				}
			}

			if(g('checkoutproviders_old')) {
				var cp = g('checkoutproviders_old');
			}
			else {
				var cp = document.getElementById("checkoutproviders");
			}
			for(i = 0; i < cp.options.length; i++) {
				if(cp.options[i].value == checkout_id && cp.options[i].selected) {
					return true;
				}
			}
			return false;
		}

		function ShowTab(T)
		{
			i = 0;
			while (document.getElementById("tab" + i) != null) {
				document.getElementById("div" + i).style.display = "none";
				document.getElementById("tab" + i).className = "";
				i++;
			}

			document.getElementById("div" + T).style.display = "";
			document.getElementById("tab" + T).className = "active";
			document.getElementById("currentTab").value = T;
		}

		function CheckCheckoutSettingsForm()
		{
			if($('input[name=builtInGateway]:checked').val() == 1 && $('.BuiltInGatewayForm .MessageBoxError').length > 0) {
				alert('{% lang 'CannotEnableBuiltInModuleErrors' %}');
				return false;
			}

			if($('#EnableDigitalOrderHandlingFee').attr('checked')) {
				if($('#DigitalOrderHandlingFee').val() == '' || isNaN(priceFormat($('#DigitalOrderHandlingFee').val()))) {
					alert('{% lang 'EnterDigitalOrderHandlingFee' %}');
					$('#DigitalOrderHandlingFee').select();
					return false;
				}
			}

			if($('#EnableOrderTermsAndConditions').attr('checked')) {
				if($('.OrderTermsAndConditionsType:checked').val() == 'link') {
					if($('.OrderTermsAndConditionsLink').val() == '' || $('.OrderTermsAndConditionsLink').val() == 'http://') {
						alert("{% lang 'EnterTermsAndConditionsLink' %}");
						return false;
					}
				} else if($('.OrderTermsAndConditionsType:checked').val() == 'textarea') {
					if($('.OrderTermsAndConditionsTextarea').val() == '') {
						alert("{% lang 'EnterTermsAndConditions' %}");
						return false;
					}
				} else {
					alert("{% lang 'SelectTermsAndConditionsType' %}");
					return false;
				}
			}

			{{ CheckoutJavaScript|safe }}
		}

		function ConfirmCancel() {
			if(confirm('{% lang 'CancelCheckoutMessage' %}')) {
				document.location.href='index.php?ToDo=viewCheckoutSettings';
			}
			else {
				return false;
			}
		}

		function ToggleBuiltInGateway()
		{
			// Built in gateway is disabled
			if($('#BuiltInGatewayOption').css('display') == 'none') {
				return;
			}
			selected = $('input[name=builtInGateway]:checked').val();
			$('.builtInGateway').hide();
			$('.builtInGateway_'+selected).show();
		}

		$(document).ready(function() {
			$('input[name=builtInGateway]').click(function() {
				ToggleBuiltInGateway();
			});
			ToggleBuiltInGateway();

			ShowTab({{ CurrentTab|safe }});

		});

	</script>