{% import "macros/util.tpl" as util %}
{% import "macros/forms.tpl" as formBuilder %}

<script type="text/javascript" src="script/jquery.slugify.js"></script>
<script type="text/javascript">
	$(document).ready( function() {
		$('#prodUrl').slugify('#prodName');
	});
</script>

<script type="text/javascript" src="../javascript/jquery/plugins/jquery.htmlEncode.js?{{ JSCacheToken }}"></script>
<input type="hidden" name="youTubeVideos" id="youTubeVideos" value="{{ YouTubeVideos|safe }}">
<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" id="frmProduct" method="post">
	<input type="hidden" name="productId" id="productId" value="{{ ProductId|safe }}">
	<input type="hidden" name="productHash" id="productHash" value="{{ ProductHash|safe }}">
	<input type="hidden" name="originalProductId" id="originalProductId" value="{{ OriginalProductId|safe }}">
	<input id="currentTab" name="currentTab" value="0" type="hidden">
	<input id="productVariationExisting" name="productVariationExisting" value="{{ ProductVariationExisting|safe }}" type="hidden">
	<div id="youTubeData" style="display: none;"></div>
	<div class="BodyContainer">
		<div class="row">
			<div class="col-sm-12">
				<h4 class="page-title">{{ Title|safe }}</h4>
				<p>{{ Intro|safe }}</p>
				{{ Message|safe}}
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">
				<input type="submit" disabled="disabled" value="{% lang 'SaveAndExit' %}" class="btn btn-success" />
				<input type="submit" disabled="disabled" value="{{ SaveAndAddAnother|safe }}" onclick="SaveAndAddAnother()" class="btn btn-primary" />
				<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
			</div>
		</div>
		<br>
		<div class="row">
			<div class="col-sm-12">
				<ul id="tabnav" class="nav nav-tabs tabs ui-tabs ui-widget ui-widget-content ui-corner-all" style="margin-bottom: 20px;">
					<li><a href="#" class="active" id="tab0" onclick="ShowTab(0)">{% lang 'Details' %}</a></li>
					<li style="display: {{ HideDigitalOptions|safe }}"><a href="#" id="tab2" class="ShowOnDigitalProduct" onclick="ShowTab(2)" style="display: none;">{% lang 'DigitalDownloads' %}</a></li>
					<li><a href="#" id="tab8" onclick="ShowTab(8)">{% lang 'ImagesVideos' %}</a></li>
					<li><a href="#" id="tab1" onclick="ShowTab(1)">{% lang 'EventDate' %}</a></li>
					<li style="display: {{ HideInventoryOptions|safe }}"><a href="#" id="tab3" class="HideOnDigitalProduct" onclick="ShowTab(3)">{% lang 'Inventory' %}</a></li>
					<li><a href="#" id="tab4" onclick="ShowTab(4)" class="HideOnDigitalProduct">{% lang 'Variations' %}</a></li>
					<li><a href="#" id="tab5" onclick="ShowTab(5)">Campos Personalizados</a></li>
					<li><a href="#" id="tab6" onclick="ShowTab(6)">{% lang 'OtherDetails' %}</a></li>
					<li><a href="#" id="tab7" onclick="ShowTab(7)">{% lang 'DiscountRules' %}</a></li>
					<br class="Clear" />
				</ul>
			</div>
		</div>

		<div id="div0">
			<div class="alert alert-info">{% lang 'CatalogInformationIntro' %}</div>
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'CatalogInformation' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductType' %}:
						</label>
						<div class="col-md-10">
							<div id="ProductType">
								<div>
									<input {{ ProdType_1|safe }} id="ProductType_0" type="radio" name="prodtype" value="1" onclick="ToggleType(0)"/><label for="ProductType_0">{% lang 'PhysicalProduct' %}</label>
								</div>
								<div>
									<input {{ ProdType_2|safe }} id="ProductType_1" type="radio" name="prodtype" value="2" onclick="ToggleType(1)" /><label for="ProductType_1">{% lang 'DownloadableProduct' %}</label>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductName' %}:
						</label>
						<div class="col-md-10">
							<input type="text" id="prodName" name="prodName" class="form-control" value="{{ ProdName|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							URL do Produto:
						</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="prodUrl" name="prodUrl" value="{{ ProdUrl|safe }}" readonly />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductCodeSKU' %}:
						</label>
						<div class="col-md-10">
							<input type="text" id="prodCode" name="prodCode" class="form-control" value="{{ ProdCode|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'Categories' %}: &nbsp;&nbsp;&nbsp;<span style="{{ HideCategoryCreation|safe }}">(<a href="#" onclick="CreateNewCategory(); return false;">{% lang 'CreateNew' %}</a>)</span>
						</label>
						<div class="col-md-10">
							<select size="5" id="category" name="category[]" class="form-control ISSelectReplacement" multiple="multiple">
								{{ CategoryOptions|safe }}
							</select>
						</div>
					</div>

					<div class="form-group row" style="{{ HideVendorOption|safe }}">
						<label class="col-md-2 control-label">
							{% lang 'Vendor' %}:
						</label>
						<div class="col-md-10">
							<span style="{{ HideVendorLabel|safe }}">{{ CurrentVendor|safe }}</span>
							<select name="vendor" id="vendor" class="form-control" style="{{ HideVendorSelect|safe }}" onchange="toggleVendorSettings($(this).val());">
								{{ VendorList|safe }}
							</select>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ProductDescription' %}</h3> 
				</div> 

				<div class="panel-body" style="padding: 0">
					<div class="form-group">
						{{ WYSIWYG|safe }}
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ProductPriceOptions' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'PreorderAvailability' %}:
						</label>
						<div class="col-md-10">
							<div><label><input type="radio" name="_prodorderable" id="_prodorderable_yes" value="yes" {% if _prodorderable == 'yes' %}checked="checked"{% endif %} /> {% lang 'ThisProductCanBePurchasedInMyOnlineStore' %}</label></div>

							<div><label><input type="radio" name="_prodorderable" id="_prodorderable_pre" value="pre" {% if _prodorderable == 'pre' %}checked="checked"{% endif %} /> {% lang 'ThisProductIsComingSoonButIWantToTakePreOrders' %}</label></div>
							<div class="_prodorderable_detail" id="_prodorderable_pre_detail" style="display:none;">
								<div>
									<img src="images/nodejoin.gif" alt="" style="vertical-align: middle;" /> {% lang 'Message' %}: <input type="text" name="prodpreordermessage" id="prodpreordermessage" class="Field300" value="{{ prodpreordermessage }}" maxlength="250" />
									<img onmouseout="HideHelp('PreorderMessageHelp');" onmouseover="ShowHelp('PreorderMessageHelp', '{% jslang 'PreorderMessage' %}?', '{% jslang 'PreorderMessageHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display:none" id="PreorderMessageHelp"></div>
								</div>
								<div>
									<img src="images/nodejoin.gif" alt="" style="vertical-align: middle;" /> {% lang 'ReleaseDate' %}: <input type="text" name="prodreleasedate" id="prodreleasedate" class="Field80" value="{{ prodreleasedate }}" />
									<input type="checkbox" name="prodreleasedateremove" id="prodreleasedateremove" {% if prodreleasedateremove %}checked="checked"{% endif %} /> <label for="prodreleasedateremove" />{% lang 'RemovePreOrderStatusOnThisDate' %}</label>
									<img onmouseout="HideHelp('PreorderRemoveDateHelp');" onmouseover="ShowHelp('PreorderRemoveDateHelp', '{% jslang 'RemovePreOrderStatusOnThisDate' %}?', '{% jslang 'PreorderRemoveDateHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display:none" id="PreorderRemoveDateHelp"></div>
								</div>
							</div>

							<div><label><input type="radio" name="_prodorderable" id="_prodorderable_no" value="no" {% if _prodorderable == 'no' %}checked="checked"{% endif %} /> {% lang 'ThisProductCannotBePurchasedInMyOnlineStore' %}</label></div>
							<div class="_prodorderable_detail" id="_prodorderable_no_detail" style="display:none;">
								<div>
									<img src="images/nodejoin.gif" alt="" style="vertical-align: middle;" />
									<input type="checkbox" name="prodHidePrices" id="prodHidePrices" value="1" {{ ProdHidePrice|safe }} onclick="ToggleCallForPricing()" />
									<label for="prodHidePrices">{% lang 'ProductCallForPricing' %}</label>
									<img onmouseout="HideHelp('prodhidepriceshelp');" onmouseover="ShowHelp('prodhidepriceshelp', '{% jslang 'ProductCallForPricing' %}?', '{% jslang 'ProductCallForPricingHelp' %}')" src="images/help.gif" width="24" height="16" border="0" />
									<div style="display:none" id="prodhidepriceshelp"></div>
								</div>
								<div id="prodCallForPricingLabelContainer" style="margin-left: 18px; display:none;">
									<img src="images/nodejoin.gif" alt="" style="vertical-align: middle;" /> <label for="prodCallForPricingLabel">{% lang 'ProductCallForPricingLabel' %}:</label> <input type="text" name="prodCallForPricingLabel" id="prodCallForPricingLabel" class="Field250" value="{{ ProdCallForPricingLabel|safe }}" />
								</div>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							<span class="Required">*</span>{% lang 'Price' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<span class="input-group-addon">{{ CurrencyTokenLeft|safe }}</span>
								<input type="text" id="prodPrice" name="prodPrice" class="form-control" value="{{ ProdPrice|safe }}" />
								{% if enterPricesWithTax %}
								<span class="input-group-addon">{{ lang.IncTax }}</span>
								{% else %}
								<span class="input-group-addon">{{ lang.ExTax }}</span>
								{% endif %}

							</div>
							<a href="javascript:void(0)" class="ExpandLink" onclick="toggle_price_options()"><span id="more_price_options">{% lang 'MorePricingOptions' %} &raquo;</span></a>
						</div>
					</div>

					<div id="tr_costprice" class="form-group row"style="display:none">
						<label class="col-md-2 control-label">
							{% lang 'CostPrice' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<span class="input-group-addon">{{ CurrencyTokenLeft|safe }}</span>
								<input type="text" id="prodCostPrice" name="prodCostPrice" class="form-control" value="{{ ProdCostPrice|safe }}" />
							</div>
						</div>
					</div>

					<div id="tr_retailprice" class="form-group row"style="display:none">
						<label class="col-md-2 control-label">
							{% lang 'RetailPrice' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<span class="input-group-addon">{{ CurrencyTokenLeft|safe }}</span>
								<input type="text" id="prodRetailPrice" name="prodRetailPrice" class="form-control" value="{{ ProdRetailPrice|safe }}" />
							</div>
						</div>
					</div>

					<div id="tr_saleprice" class="form-group row"style="display:none">
						<label class="col-md-2 control-label">
							{% lang 'SalePrice' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<span class="input-group-addon">{{ CurrencyTokenLeft|safe }}</span>
								<input type="text" id="prodSalePrice" name="prodSalePrice" class="form-control" value="{{ ProdSalePrice|safe }}" />
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{{ lang.ProductTaxClass }}:
						</label>
						<div class="col-md-10">
							{{ formBuilder.select('tax_class_id', taxClasses, product.tax_class_id, [
								'class': 'form-control',
							]) }}
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default HideOnDigitalProduct" id="shipping_table">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ShippingDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							<span class="Required">*</span>{% lang 'ProductWeight' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<input type="text" id="prodWeight" name="prodWeight" class="form-control" value="{{ ProdWeight|safe }}" /> 
								<span class="input-group-addon">{{ WeightMeasurement|safe }}</span>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductWidth' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<input type="text" id="prodWidth" name="prodWidth" class="form-control" value="{{ ProdWidth|safe }}" /> 
								<span class="input-group-addon">{{ LengthMeasurement|safe }}</span>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductHeight' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<input type="text" id="prodHeight" name="prodHeight" class="form-control" value="{{ ProdHeight|safe }}" />
								<span class="input-group-addon">{{ LengthMeasurement|safe }}</span>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ProductDepth' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<input type="text" id="prodDepth" name="prodDepth" class="form-control" value="{{ ProdDepth|safe }}" />
								<span class="input-group-addon">{{ LengthMeasurement|safe }}</span>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'FixedShippingCost' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<span class="input-group-addon">{{ CurrencyTokenLeft|safe }}</span>
								<input type="text" id="prodFixedCost" name="prodFixedCost" class="form-control" style="width:70px; text-align: right;" value="{{ ProdFixedShippingCost|safe }}" onkeyup="document.getElementById('prodFreeShipping').checked=false">
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'FreeShipping' %}:
						</label>
						<div class="col-md-10">
							<div class="input-group">
								<input type="checkbox" id="prodFreeShipping" name="prodFreeShipping" value="1" {{ FreeShipping|safe }} onclick="if(this.checked) { document.getElementById('prodFixedCost').value='0'; }"> <label for="prodFreeShipping">{% lang 'YesFreeShipping' %}</label>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div1">
			<div class="alert alert-info">{% lang 'EventDateIntro' %}</div>
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'EventDate' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'EventDateFieldName' %}
						</label>
						<div class="col-md-10">
							<label><input id="EventDateRequired" name="EventDateRequired" type="checkbox" {{ EventDateRequired|safe }} /> {% lang 'EventDateRequiredInfo' %}</label>
						</div>
					</div>
					<div id="DateFieldNameTR">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'EventDateRequired' %}</label>
						<div class="col-md-10">
							<div class="input-group">
								<input id="EventDateFieldName" name="EventDateFieldName" value="{{ EventDateFieldName|safe }}" type="text" class="form-control" />
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'EventDateLimit' %}</label>
						<div class="col-md-10">
							<label><input id="LimitDates" name="LimitDates" type="checkbox" {{ LimitDates|safe }} /> {% lang 'EventDateLimitInfo' %}</label>
							<select id="LimitDatesSelect" name="LimitDatesSelect" class="form-control" style="display: inline-block; width: auto">
								<option value="1" {{ LimitDateOption1|safe }}>{% lang 'EventDateLimitOption1' %}</option>
								<option value="2" {{ LimitDateOption2|safe }}>{% lang 'EventDateLimitOption2' %}</option>
								<option value="3" {{ LimitDateOption3|safe }}>{% lang 'EventDateLimitOption3' %}</option>
							</select>
							{% lang 'EventDateLimitInfo2' %}
							<img onmouseout="HideHelp('ed3');" onmouseover="ShowHelp('ed3', '{% lang 'EventDateLimitHelpHeader' %}', '{% lang 'EventDateLimitHelp' %}')" src="images/help.gif" width="24" height="16" border="0" style="margin-top: 5px;" />
							<div style="display:none" id="ed3"></div>
							<br/>
							<div id="LimitDates1">
								<img style="float: left;" src="images/nodejoin.gif"/>
								<span id=customDate7 style="float : left; display:block; margin-top:2px;">&nbsp;
								{% lang 'EventDateLimitOption1Info' %}
								<select name="Calendar1[From][Day]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromDays|safe }}
								</select>
								<select name="Calendar1[From][Mth]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromMonths|safe }}
								</select>
								<select name="Calendar1[From][Yr]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromYears|safe }}
								</select>
								<span class=body>{% lang 'EventDateLimitOption1Info2' %}</span>
								<select name="Calendar1[To][Day]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToDays|safe }}
								</select>
								<select name="Calendar1[To][Mth]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToMonths|safe }}
								</select>
								<select name="Calendar1[To][Yr]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToYears|safe }}
								</select>
								</span>&nbsp;
							</div>
							<div id="LimitDates2">
								<img style="float: left;" src="images/nodejoin.gif"/>
								<span id=customDate7 style="float : left; display:block; margin-top:2px;">&nbsp;
								{% lang 'EventDateLimitOption2Info' %}
								<select name="Calendar2[From][Day]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromDays|safe }}
								</select>
								<select name="Calendar2[From][Mth]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromMonths|safe }}
								</select>
								<select name="Calendar2[From][Yr]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewFromYears|safe }}
								</select>
								</span>&nbsp;
							</div>
							<div id="LimitDates3">
								<img style="float: left;" src="images/nodejoin.gif"/>
								<span id=customDate7 style="float : left; display:block; margin-top:2px;">&nbsp;
								{% lang 'EventDateLimitOption3Info' %}
								<select name="Calendar3[To][Day]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToDays|safe }}
								</select>
								<select name="Calendar3[To][Mth]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToMonths|safe }}
								</select>
								<select name="Calendar3[To][Yr]" class="form-control" style="display: inline-block; width: auto;margin-bottom:3px">
									{{ OverviewToYears|safe }}
								</select>
								</span>&nbsp;
							</div>
						</div>
					</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div2">
			<div class="alert alert-info">{% lang 'ProductDownloadIntro' %}</div>
			<div id="DownloadStatus"></div>
			<div class="panel panel-default" id="ExistingDownloads" style="display: {{ DisplayDownloaadGrid|safe }};">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'EventDate' %}</h3> 
				</div> 

				<div class="panel-body">
					<table class="GridPanel table table-striped" id="ExistingDownloadsGrid" style="width:100%;">
						<thead>
							<tr>
								<th align="center">&nbsp;</th>
								<th>{% lang 'FileName' %}</th>
								<th>{% lang 'FileSize' %}</th>
								<th><span onmouseover="ShowQuickHelp(this, '{% lang 'Downloads' %}', '{% lang 'DownloadsHelp' %}');" onmouseout="HideQuickHelp(this);" class="HelpText">{% lang 'Downloads' %}</span></th>
								<th>{% lang 'MaximumDownloads' %}</th>
								<th>{% lang 'ExpiresAfterHeader' %}</th>
								<th>{% lang 'Action' %}</th>
							</tr>
						</thead>
						<tbody>
							{{ DownloadsGrid|safe }}
						</tbody>
					</table>
				</div>
			</div>

			<div class="panel panel-default" style="display: {{ DisplayDownloadUploadHeading|safe }}">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'DigitalDownloadUploadHeading' %}</h3> 
				</div> 

				<div class="panel-body">
					<div id="NewDownload" style="display: {{ DisplayNewDownload|safe }}">
						<div class="form-group row">
							<label class="col-md-2 control-label">
								{% lang 'DownloadDescription' %}:
							</label>

							<div class="col-md-10">
								<input type="text" name="downdescription" id="DownloadDescription" class="form-control" />
							</div>
						</div>

						<div class="form-group row" id="EditDownload" style="display: none;">
							<label class="col-md-2 control-label">
								{% lang 'EditExistingDownload' %}:
							</label>

							<div class="col-md-10" id="EditDownloadFile">
								
							</div>
						</div>

						<div class="form-group row" id="NewDownloadUpload">
							<label class="col-md-2 control-label">
								{% lang 'UploadNewDownload' %}:
							</label>

							<div class="col-md-10" id="EditDownloadFile">
								<input type="hidden" name="downloadid" id="CurrentDownloadId" value="" />
								<div id="StatusUploading" style="display: none;">
									<input type="button" class="btn bn-sm btn-primary" disabled value="{% lang 'SavingDownload' %}" />
								</div>

								<label><input id="ProductImportUseUpload" type="radio" name="useserver" value="0" checked="checked" onclick="ToggleSource();" /> {% lang 'ImportFileUpload' %} {% lang 'MaxUploadSize' %}</label>
								<div id="StatusNormal">
									<input type="file" class=" form-control" name="newdownload" id="NewDownloadFile" />
									<span id="EditDownloadButtons" style="display: none;">
										<input type="button" value="{% lang 'SaveDownload' %}" onclick="saveDownload();" class="btn btn-primary" />
										<input type="button" value="{% lang 'CancelEdit' %}" onclick="cancelDownloadEdit();" class="btn btn-default" />
									</span>
								</div>

								<span style="font-size: 11px; font-style: italic;">{% lang 'MaxUploadSize' %}</span>
								<div>
									<label><input id="ProductImportUseServer" type="radio" name="useserver" value="1" onclick="ToggleSource();" /> {% lang 'ImportProductFileServer' %}</label>
									<img onmouseout="HideHelp('i1');" onmouseover="ShowHelp('i1', '{% lang 'ImportProductFileServer' %}', '{% lang 'ImportProductFileServerDesc' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display: none;" id="i1"></div>
								</div>
								<div id="ProductImportServerField" style="margin-left: 25px; display: none;">
									<select name="serverfile" id="ServerFile" class="form-control">
										<option value="">{% lang 'ImportChooseFile' %}</option>
										{{ ServerFiles|safe }}
									</select>
								</div>
								<div id="ProductImportServerNoList" style="margin: 5px 0 0 25px; display: none; font-style: italic;" class="Field500">
									{% lang 'FieldNoServerFilesProductDownloads' %}
								</div>
								<br/>
							</div>
						</div>

						<div class="form-group row">
							<label class="col-md-2 control-label">
								{% lang 'ExpiresAfter' %}:
							</label>

							<div class="col-md-10">
								<input type="text" name="downexpiresafter" id="DownloadExpiresAfter" class="form-control" style="width: auto; display: inline-block;" />
								<select name="downloadexpiresrange" id="DownloadExpiresRange" class="form-control" style="width: auto; display: inline-block;">
									<option value="days">{% lang 'RangeDays' %}</option>
									<option value="weeks">{% lang 'RangeWeeks' %}</option>
									<option value="months">{% lang 'RangeMonths' %}</option>
									<option value="years">{% lang 'RangeYears' %}</option>
								</select>
							</div>
						</div>

						<div class="form-group row">
							<label class="col-md-2 control-label">
								{% lang 'MaximumDownloads' %}:
							</label>

							<div class="col-md-10">
								<input type="text" name="downmaxdownloads" id="DownloadMaxDownloads" class="form-control" />
								<br>
								<input type="button" value="{% lang 'AttachFile' %}" onclick="attachFile();" class="btn btn-success" />
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div3">
			<div class="alert alert-info">{% lang 'InventoryTrackingIntro' %}</div>
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'InventoryTracking' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'TrackingMethod' %}:</label>

						<div class="col-md-10">
							<input type="radio" id="prodInvTrack_0" name="prodInvTrack" value="0" onclick="ToggleProductInventoryOptions(false); toggleVariationInventoryColumns();" {{ InvTrack_0|safe }}> <label for="prodInvTrack_0">{% lang 'DoNotTrackInventory' %}</label><br>

							<input type="radio" id="prodInvTrack_1" name="prodInvTrack" value="1" onclick="ToggleProductInventoryOptions(true); toggleVariationInventoryColumns();" {{ InvTrack_1|safe }}> <label for="prodInvTrack_1">{% lang 'TrackInvForProduct' %}</label><br />
							<div id="divTrackProd" style="display: {{ HideProductInventoryOptions|safe }};">
							<div class="row">
								<label class="col-md-2 control-label">{% lang 'CurrentStockLevel' %}:</label>
								<div class="col-md-10">
									<input type="text" id="prodCurrentInv" name="prodCurrentInv" class="Field50" value="{{ CurrentStockLevel|safe }}">
								</div>
							</div>

							<div class="row">
								<label class="col-md-2 control-label">{% lang 'LowStockLevel1' %}:</label>
								<div class="col-md-10">
									<input type="text" id="prodLowInv" name="prodLowInv" class="Field50" value="{{ LowStockLevel|safe }}">
								</div>
							</div>
							</div>
							<input type="radio" id="prodInvTrack_2" name="prodInvTrack" value="2" onclick="ToggleProductInventoryOptions(false); toggleVariationInventoryColumns();" {{ InvTrack_2|safe }}> <label for="prodInvTrack_2">{% lang 'TrackInvForProductOpt' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div4">
			<div class="alert alert-info">{% lang 'ProductVariationsIntro' %}</div>
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ProductVariationOptions' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ThisProduct' %}:</label>

						<div class="col-md-10">
							<input type="radio" name="useProdVariation" id="useProdVariationNo" value="0" {{ IsNoVariation|safe }} /> <label for="useProdVariationNo">{% lang 'ProductWillNotUseVariation' %}</label><br />
							<input type="radio" name="useProdVariation" id="useProdVariationYes" value="1" {{ IsYesVariation|safe }} {{ VariationDisabled|safe }} /> <label for="useProdVariationYes" id="variationLabel" style="color:{{ VariationColor|safe }}">{% lang 'ProductWillUseVariation' %}</label>
							<span style="display:{{ HideVariationList|safe }};" id="variationList">
								<select class="Field200" name="variationId" id="variationId">
									<option value="">{% lang 'ChooseAVariation' %}</option>
									{{ VariationOptions|safe }}
								</select>
								<div style="padding-left:20px">
									<input type="checkbox" name="prodOptionsRequired" id="prodOptionsRequired" {{ OptionsRequired|safe }} value="ON" /> <label for="prodOptionsRequired">{% lang 'ProductOptionRequired' %}</label>
									<img onmouseout="HideHelp('dforceopt');" onmouseover="ShowHelp('dforceopt', '{% lang 'ProductOptionRequiredTitle' %}', '{% lang 'ProductOptionRequiredHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display:none" id="dforceopt"></div>
								</div>
							</span>
						</div>
					</div>
				</div>
			</div>
			<div style="display:{{ HideVariationCombinationList|safe }}; margin-bottom:5px" class="GridContainer" id="variationCombinationsList">
				{{ VariationCombinationList|safe }}
			</div>
		</div>

		<div id="div5" style="padding-top: 10px;">
			<div class="alert alert-info">{% lang 'CustomFieldsIntro' %}</div>
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'CustomFields' %}</h3> 
				</div> 

				<div class="panel-body">
					<div id="CustomFieldsContainer">
						<table class="Panel table">
							{{ CustomFields|safe }}
						</table>
					</div>
				</div>
			</div>

			<div class="alert alert-info">{% lang 'ConfigurableFieldsIntro' %}</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ConfigurableFields' %}</h3> 
				</div> 

				<div class="panel-body">
					<input type="hidden" id="FieldLastKey" value="{{ FieldLastKey|safe }}" />
					<table class="Panel table" style="width: 100%" id="ProductFieldsContainer">
						{{ ProductFields|safe }}
					</table>
				</div>
			</div>
		</div>

		<div id="div6" style="padding-top: 10px;">
			<div class="alert alert-info">{% lang 'RelatedProductsIntro' %}</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'RelatedProducts' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'RelatedProducts' %}:</label>
						<div class="col-md-10">
							<input type="checkbox" id="prodRelatedAuto" name="prodRelatedAuto" value="1" onclick="toggle_related_auto(this.checked)" {{ IsProdRelatedAuto|safe }}> <label for="prodRelatedAuto">{% lang 'ProductRelatedOptionsAutomatically' %}</label>

							<div id="relatedProductsBoxes">
								<select id="relCategory" size="10" name="relCategory" class="form-control" onchange="GetProducts(this)">
									{{ RelatedCategoryOptions|safe }}
								</select>

								<br />

								<select size="10" id="relProducts" name="relProducts" onDblClick="AddRelatedProduct(this)" class="form-control">
								</select>
								<br />
								<b>{% lang 'DoubleClickToAdd' %}</b><br />
								<select multiple size="5" id="related" name="prodRelatedProducts[]" onDblClick="RemoveRelatedProduct(this)" class="form-control">{{ RelatedProductOptions|safe }}</select>
								<br />
								<b>{% lang 'DoubleClickToRemove' %}</b><br />
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="alert alert-info">{% lang 'OtherDetailsIntro' %}</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'OtherDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductWarranty' %}:</label>
						<div class="col-md-10">
							<textarea id="prodWarranty" name="prodWarranty" class="form-control" rows="5">{{ ProdWarranty|safe }}</textarea>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'TemplateLayoutFile' %}:</label>
						<div class="col-md-10">
							<select name="prodlayoutfile" id="prodlayoutfile" class="form-control">{{ LayoutFiles|safe }}</select>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'BrandName' %}:</label>
						<div class="col-md-10">
							<select name="brandbox" id="brandbox" class="form-control" style="width: auto; display: inline;">
								<option value="">{% lang 'ChooseAnExistingBrand' %}</option>
								{{ BrandNameOptions|safe }}
							</select>
							<span style="{{ HideAddBrandBox|safe }}">
								{% lang 'OrCreateANewBrand' %}:
								<input type="text" id="brandname" name="brandname" class="form-control" style="width: auto; display: inline;" value="{{ BrandName|safe }}">
							</span>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductUPC' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodUPC" name="prodUPC" class="form-control" value="{{ ProdUPC|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'SearchKeywords' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodSearchKeywords" name="prodSearchKeywords" class="form-control" value="{{ ProdSearchKeywords|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductTags' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodTags" name="prodTags" class="form-control" value="{{ ProdTags|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'Availability' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodAvailability" name="prodAvailability" class="form-control" value="{{ ProdAvailability|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'Visible' %}:</label>
						<div class="col-md-10">
							<input type="checkbox" id="prodVisible" name="prodVisible" value="1" {{ ProdVisible|safe }}> <label for="prodVisible">{% lang 'YesProductVisible' %}</label>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'FeaturedProduct' %}:</label>
						<div class="col-md-10">
							<div style="{{ HideStoreFeatured|safe }}">
								<input type="checkbox" id="prodFeatured" name="prodFeatured" value="1" {{ ProdFeatured|safe }}> <label for="prodFeatured">{% lang 'YesProductFeatured' %}</label>
								<img onmouseout="HideHelp('d11');" onmouseover="ShowHelp('d11', '{% lang 'FeaturedProduct' %}', '{% lang 'FeaturedProductHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
								<div style="display:none" id="d11"></div>
							</div>
							<div style="{{ HideVendorFeatured|safe }}" id="vendorFeaturedToggle">
								<input type="checkbox" id="prodvendorfeatured" name="prodvendorfeatured" value="1" {{ ProdVendorFeatured|safe }}> <label for="prodvendorfeatured">{% lang 'YesProductVendorFeatured' %}</label>
								<img onmouseout="HideHelp('prodvendorfeaturedhelp');" onmouseover="ShowHelp('prodvendorfeaturedhelp', '{% lang 'VendorFeaturedProduct' %}', '{% lang 'VendorFeaturedProductHelp' %}')" src="images/help.gif" width="24" height="16" border="0" />
								<div style="display:none" id="prodvendorfeaturedhelp"></div>
							</div>
						</div>
					</div>

					<div class="form-group row HideOnDigitalProduct">
						<label class="col-md-2 control-label">{% lang 'GiftWrapping' %}:</label>
						<div class="col-md-10">
							<label><input type="radio" onclick="ToggleGiftWrapping(this.value)" name="prodwraptype" value="default" {{ WrappingOptionsDefaultChecked|safe }} /> {% lang 'ProductGiftWrappingDefault' %}</label>
							<img onmouseout="HideHelp('prodwrappinghelp');" onmouseover="ShowHelp('prodwrappinghelp', '{% lang 'GiftWrapping' %}', '{% lang 'GiftWrappingHelp' %}')" src="images/help.gif" width="24" height="16" border="0">
							<div style="display:none" id="prodwrappinghelp"></div><br />
							<label style="display: black;"><input type="radio" onclick="ToggleGiftWrapping(this.value)" name="prodwraptype" value="none" {{ WrappingOptionsNoneChecked|safe }} /> {% lang 'ProductGiftWrappingNone' %}</label>
							<label style="display: block;"><input type="radio" onclick="ToggleGiftWrapping(this.value)" name="prodwraptype" id="prodwraptype_custom" value="custom" {{ WrappingOptionsCustomChecked|safe }} /> {% lang 'ProductGiftWrappingCustom' %}</label>
							<div style="{{ HideGiftWrappingOptions|safe }}" id="GiftWrapOptions">
								<img src="images/nodejoin.gif" alt="" style="float: left; margin-right: 10px;" />
								<select name="prodwrapoptions[]" id="prodwrapoptions" multiple="multiple" size="10" class="Field300 ISSelectReplacement">
									{{ WrappingOptions|safe }}
								</select>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'SortOrder' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodSortOrder" name="prodSortOrder" class="form-control" style="width:100px" value="{{ ProdSortOrder|safe }}">
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductCondition' %}:</label>
						<div class="col-md-10">
							<select name="prodCondition" id="prodCondition" class="form-control">
								<option value="New" {{ ProdConditionNewSelected|safe }}>{% lang 'ConditionNew' %}</option>
								<option value="Used" {{ ProdConditionUsedSelected|safe }}>{% lang 'ConditionUsed' %}</option>
								<option value="Refurbished" {{ ProdConditionRefurbishedSelected|safe }}>{% lang 'ConditionRefurbished' %}</option>
							</select>
							<label><input type="checkbox" name="prodShowCondition" id="prodShowCondition" value="1" {{ ProdShowCondition|safe }} />{% lang 'ShowConditionOnProduct' %}</label>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductMinimumQuantity' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodminqty" name="prodminqty" class="form-control" value="{{ prodminqty }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ProductMaximumQuantity' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodmaxqty" name="prodmaxqty" class="form-control" value="{{ prodmaxqty }}" />
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'SearchEngineOptimization' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'PageTitle' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodPageTitle" name="prodPageTitle" class="form-control" value="{{ ProdPageTitle|safe }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'MetaKeywords' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodMetaKeywords" name="prodMetaKeywords" class="form-control" value="{{ ProdMetaKeywords|safe }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'MetaDescription' %}:</label>
						<div class="col-md-10">
							<input type="text" id="prodMetaDesc" name="prodMetaDesc" class="form-control" value="{{ ProdMetaDesc|safe }}" />
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{{ lang.FacebookOpenGraphSettings }}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{{ lang.ObjectType }}:</label>
						<div class="col-md-10">
							{{ formBuilder.select('OpenGraphObjectType', openGraphTypes, openGraphSelectedType, ['class': 'form-control']) }}
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{{ lang.Title }}:</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="OpenGraphUseProductName" id="OpenGraphUseProductName" value="1" {% if openGraphUseProductName %}checked="checked"{% endif %} />{{ lang.UseProductName }}</label>
							<div class="NodeJoin" {% if openGraphUseProductName %}style="display: none;"{% endif %}>
								<input type="text" class="form-control" name="OpenGraphTitle" id="OpenGraphTitle" value="{{ openGraphTitle }}" />
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{{ lang.Description }}:</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="OpenGraphUseMetaDescription" id="OpenGraphUseMetaDescription" value="1" {% if openGraphUseMetaDescription %}checked="checked"{% endif %} />{{ lang.UseMetaDescription }}</label>
							<div class="NodeJoin" {% if openGraphUseMetaDescription %}style="display: none;"{% endif %}>
								<input type="text" class="form-control" name="OpenGraphDescription" id="OpenGraphDescription" value="{{ openGraphDescription }}" />
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{{ lang.Image }}:</label>
						<div class="col-md-10">
							<label><input type="radio" name="OpenGraphUseImage" value="1" {% if openGraphUseImage %}checked="checked"{% endif %} />{{ lang.UseThumbnailImage }}</label>
							<br />
							<label><input type="radio" name="OpenGraphUseImage" value="0" {% if openGraphUseImage == false %}checked="checked"{% endif %} />{{ lang.DontUseImage }}</label>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default" style="display: none;">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'MYOBSettings' %}</h3> 
				</div> 

				<div class="panel-body" >
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'MYOBAsset' %}:</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="prodMYOBAsset" name="prodMYOBAsset" maxlength="6" size="6" value="{{ ProdMYOBAsset|safe }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'MYOBIncome' %}:</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="prodMYOBIncome" name="prodMYOBIncome" maxlength="6" size="6" value="{{ ProdMYOBIncome|safe }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'MYOBExpense' %}:</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="prodMYOBExpense" name="prodMYOBExpense" maxlength="6" size="6" value="{{ ProdMYOBExpense|safe }}" />
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default" style="display: none;">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'PeachtreeSettings' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'PeachtreeGL' %}:</label>
						<div class="col-md-10">
							<input type="text" class="form-control" id="prodPeachtreeGL" name="prodPeachtreeGL" maxlength="20" size="6" value="{{ ProdPeachtreeGL|safe }}" />
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default " style="display: none;">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ShoppingComparison' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="alert alert-info">{% lang 'ShoppingComparisonInstructions' %}</div>
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'ShoppingComparisonIncludeProductIn' %}:</label>
						<div class="col-md-10">
							<select name="comparisons[]" class="Field250 ISSelectReplacement" multiple="multiple" style="height: 108px;">
								{% for module in shoppingComparisonModules %}
								<option value="{{ module.getId() }}"{% if module.selected %} selected="selected"{% endif %}>{{ module.getName() }}</option>
								{% endfor %}
							</select>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default" style="display: none;">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'GoogleCheckoutSettings' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="alert alert-info">{% lang 'ShoppingComparisonInstructions' %}</div>
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'DisableGoogleCheckout' %}:</label>
						<div class="col-md-10">
							<input type="hidden" name="prodDisableGoogleCheckout" value="0"/>
							<input type="checkbox" name="prodDisableGoogleCheckout" id="prodDisableGoogleCheckout" value="1" {% if ProdDisableGoogleCheckout == 1 %}checked="checked"{% endif %} />
							<label for="prodDisableGoogleCheckout">{% lang 'YesDisableGoogleCheckout' %}</label>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div7">
			<div class="alert alert-info">{% lang 'DiscountRulesIntro' %}</div>
			<div id="DiscountRulesWarning" class="alert alert-warning" style="display: {{ HideDiscountRulesWarningBox|safe }};">{{ DiscountRulesWarningText|safe }}</div>

			<div id="DiscountRulesDisplay" style="display: {{ DiscountRulesWithWarning|safe }};">

				<div class="panel panel-default">
					<div class="panel-heading"> 
						<h3 class="panel-title">{% lang 'DiscountRules' %}</h3> 
					</div> 

					<div class="panel-body">
						<table class="Panel" id="DiscountRulesContainer">
							<tbody>
								{{ DiscountRules|safe }}
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>

		<div id="div8">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ProductImages' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="alert alert-info">{% lang 'ProductImagesIntroduction' %}</div>
					<button class="btn btn-danger" id="productImagesDeleteSelected" disabled>{% lang 'DeleteSelected' %}</button>
					<hr>
					<table class="GridPanel productImagesTable table" cellspacing="0">
						<thead>
							<tr>
								<th class="productImageCheck"><input type="checkbox" /></th>
								<th class="productImageThumbDisplay">{% lang 'Image' %}</th>
								<th class="productImageDescription">{% lang 'Description' %}</th>
								<th class="productImageBaseThumb">{% lang 'UseAsBaseThumbnail' %}</th>
								<th class="productImageAction">{% lang 'Action' %}</th>
							</tr>
						</thead>
					</table>

					<div class="productImagesListItem" id="productImagesListItemNew">
						<table class="table" width="100%">
							<tbody>
								<tr class="GridRowNoOver">
									<td class="productImageCheck"><input type="checkbox" /></td>
									<td class="productImageThumbDisplay">
										<div class="productImageNewPlaceholder">
											<div><span>{% lang 'NewImage' %}</span></div>
										</div>
									</td>
									<td class="productImageDescription">
										<p>{% lang 'ProductImagesSelectUploadMethod' %}</p>
										<ul>
											<li><span id="productImageNewUploadPlaceholder"></span><a id="productImageNewUpload" class="ProductImageNewUpload" href="#">{% lang 'UploadAnImage' %}</a> <span class="SwfUploadAlternativeNotice" style="display:none;">{% lang 'ProductImagesBasicUploader' %}</span></li>
											<li><a id="productImageNewWeb" href="#">{% lang 'UseImageFromWeb' %}</a></li>
											<li><a id="productImageNewGallery" href="#">{% lang 'ChooseFromGallery' %}</a></li>
										</ul>
									</td>
									<td class="productImageBaseThumb">&nbsp;</td>
									<td class="productImageAction">&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>

					{{ productImagesList|safe }}
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'YouTubeVideos' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="alert alert-info">Para mostrar vdeos do YouTube na pgina do produto, Cole o cdigo do video. 
Ex: se o link do video for https://www.youtube.com/watch?v=2oX2FSv4Rys voc precisa colar apenas o cdigo 2oX2FSv4Rys</div>
					<div class="form-group row">
						<label class="col-md-2 control-label">Video 01</label>
						<div class="col-md-10">
							<input id="video01" name="video01" type="text" class="form-control" value="{{video01True|safe}}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">Video 02</label>
						<div class="col-md-10">
							<input id="video02" name="video02" class="form-control" type="text" value="{{video02True|safe}}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">Video 03</label>
						<div class="col-md-10">
							<input id="video03" name="video03" class="form-control" type="text" value="{{video03True|safe}}" />
						</div>
					</div>
				</div>
			</div>
		</div>

		<div id="div9" style="display: none;">
			<div class="alert alert-info">{{ GoogleWebsiteOptimizerIntro|safe }}</p>
			<div class="panel panel-default" style="{{ ShowEnableGoogleWebsiteOptimzer|safe }}">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'GoogleWebsiteOptimizer' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">{% lang 'EnableGoogleWebsiteOptimizer' %}?</label>
						<div class="col-md-10">
							<input {{ DisableOptimizerCheckbox|safe }} type="checkbox" name="prodEnableOptimizer" id="prodEnableOptimizer" {{ CheckEnableOptimizer|safe }} onclick = "ToggleOptimizerConfigForm({{ SkipOptimizerConfirmMsg|safe }});" />
							<label for="prodEnableOptimizer">{% lang 'YesEnableGoogleWebsiteOptimizer' %}</label>
						</div>
					</div>

					{{ OptimizerConfigForm|safe }}
				</div>
			</div>
		</div>
	</div>
		<div class="row">
			<div class="col-sm-12">
				<input type="submit" disabled="disabled" value="{% lang 'SaveAndExit' %}" class="btn btn-success" />
				<input type="submit" disabled="disabled" value="{{ SaveAndAddAnother|safe }}" onclick="SaveAndAddAnother()" class="btn btn-primary" />
				<input type="reset" value="{% lang 'Cancel' %}" class="btn btn-default" onclick="ConfirmCancel()" />
			</div>
		</div>
</div>
</form>

<script type="text/javascript" src="../javascript/jquery.growinguploader.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="../javascript/jquery/plugins/ajax.file.upload.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="script/multiuploaddialog.js?{{ JSCacheToken }}"></script>
<script type="text/javascript">//<![CDATA[
var shop = { config: { } };

shop.config.DiscountRulesEnabled = '{{ DiscountRulesEnabled|safe }}';
shop.config.NoCategoriesJS = '{{ NoCategoriesJS|safe }}';
shop.config.IsProdRelatedAuto = '{{ IsProdRelatedAuto|safe }}';
shop.config.CurrencyTokenLeft = '{{ CurrencyTokenLeft|safe }}';
shop.config.CurrencyTokenRight = '{{ CurrencyTokenRight|safe }}';
shop.config.AppPath = '{{ AppPath|safe }}';
shop.config.sessionid = '{{ sessionid|safe }}';
shop.config.maxUploadSize = '{{ maxUploadSize|safe }}';

lang.DiscountRulesNotEnabledWarning = '{% jslang 'DiscountRulesNotEnabledWarning' %}';
lang.DiscountRulesVariationWarning = '{% jslang 'DiscountRulesVariationWarning' %}';
lang.PleaseWaitRelated = '{% jslang 'PleaseWaitRelated' %}';
lang.NoProdsInCat = '{% jslang 'NoProdsInCat' %}';
lang.PleaseChooseAProduct = '{% jslang 'PleaseChooseAProduct' %}';
lang.ProdAlreadyInRelatedList = '{% jslang 'ProdAlreadyInRelatedList' %}';
lang.MoreImages = '{% jslang 'MoreImages' %}';
lang.LessImages = '{% jslang 'LessImages' %}';
lang.EnterProductFieldName = '{% jslang 'EnterProductFieldName' %}';
lang.EnterProductFieldFileType = '{% jslang 'EnterProductFieldFileType' %}';
lang.EnterProductFieldFileSize = '{% jslang 'EnterProductFieldFileSize' %}';
lang.EnterValidProductFieldFileSize = '{% jslang 'EnterValidProductFieldFileSize' %}';
lang.DiscountRulesQuantityMinRequired = '{% jslang 'DiscountRulesQuantityMinRequired' %}';
lang.DiscountRulesQuantityMinInvalid = '{% jslang 'DiscountRulesQuantityMinInvalid' %}';
lang.DiscountRulesQuantityMaxRequired = '{% jslang 'DiscountRulesQuantityMaxRequired' %}';
lang.DiscountRulesQuantityMaxInvalid = '{% jslang 'DiscountRulesQuantityMaxInvalid' %}';
lang.DiscountRulesTypeRequired = '{% jslang 'DiscountRulesTypeRequired' %}';
lang.DiscountRulesTypeInvalid = '{% jslang 'DiscountRulesTypeInvalid' %}';
lang.DiscountRulesAmountRequired = '{% jslang 'DiscountRulesAmountRequired' %}';
lang.DiscountRulesAmountInvalid = '{% jslang 'DiscountRulesAmountInvalid' %}';
lang.DiscountRulesAmountPriceInvalid = '{% jslang 'DiscountRulesAmountPriceInvalid' %}';
lang.DiscountRulesAmountPercentInvalid = '{% jslang 'DiscountRulesAmountPercentInvalid' %}';
lang.DiscountRulesAmountPercentIsFloat = '{% jslang 'DiscountRulesAmountPercentIsFloat' %}';
lang.DiscountRulesAmountFixedInvalid = '{% jslang 'DiscountRulesAmountFixedInvalid' %}';
lang.DiscountRulesQuantityMinHigher = '{% jslang 'DiscountRulesQuantityMinHigher' %}';
lang.DiscountRulesQuantityBothAstrix = '{% jslang 'DiscountRulesQuantityBothAstrix' %}';
lang.DiscountRulesQuantityMinPrevMaxAstrix = '{% jslang 'DiscountRulesQuantityMinPrevMaxAstrix' %}';
lang.DiscountRulesQuantityMinOverlap = '{% jslang 'DiscountRulesQuantityMinOverlap' %}';
lang.DiscountRulesQuantityMaxOverlap = '{% jslang 'DiscountRulesQuantityMaxOverlap' %}';
lang.EnterProdName = '{% jslang 'EnterProdName' %}';
lang.MustCreateCategoryFirst = '{% jslang 'MustCreateCategoryFirst' %}';
lang.ChooseCategory = '{% jslang 'ChooseCategory' %}';
lang.EnterPrice = '{% jslang 'EnterPrice' %}';
lang.EnterCostPrice = '{% jslang 'EnterCostPrice' %}';
lang.EnterRetailPrice = '{% jslang 'EnterRetailPrice' %}';
lang.EnterSalePrice = '{% jslang 'EnterSalePrice' %}';
lang.ChooseValidImage = '{% jslang 'ChooseValidImage' %}';
lang.EnterWeight = '{% jslang 'EnterWeight' %}';
lang.EnterWidth = '{% jslang 'EnterWidth' %}';
lang.EnterHeight = '{% jslang 'EnterHeight' %}';
lang.EnterDepth = '{% jslang 'EnterDepth' %}';
lang.EnterFixedShipping = '{% jslang 'EnterFixedShipping' %}';
lang.ProductHasNoDownloads = '{% jslang 'ProductHasNoDownloads' %}';
lang.EnterCurrentInventory = '{% jslang 'EnterCurrentInventory' %}';
lang.EnterLowInventory = '{% jslang 'EnterLowInventory' %}';
lang.ChooseProductVariation = '{% jslang 'ChooseProductVariation' %}';
lang.VariationChooseVariation = '{% jslang 'VariationChooseVariation' %}';
lang.VariationEnterValidPrice = '{% jslang 'VariationEnterValidPrice' %}';
lang.VariationEnterValidWeight = '{% jslang 'VariationEnterValidWeight' %}';
lang.VariationEnterValidImage = '{% jslang 'VariationEnterValidImage' %}';
lang.VariationEnterValidStockLevel = '{% jslang 'VariationEnterValidStockLevel' %}';
lang.VariationEnterValidLowStockLevel = '{% jslang 'VariationEnterValidLowStockLevel' %}';
lang.EnterCustomFieldName = '{% jslang 'EnterCustomFieldName' %}';
lang.SelectOneMoreWrapOptions = '{% jslang 'SelectOneMoreWrapOptions' %}';
lang.EnterSortOrder = '{% jslang 'EnterSortOrder' %}';
lang.EnterEventDateName = '{% jslang 'EnterEventDateName' %}';
lang.EnterEventDateRange = '{% jslang 'EnterEventDateRange' %}';
lang.AddProductWithEmptyDimensions = '{% jslang 'AddProductWithEmptyDimensions' %}';
lang.ConfirmCancelProduct = '{% lang 'ConfirmCancelProduct' %}';
lang.ChooseOptionValue = '{% jslang 'ChooseOptionValue' %}';
lang.MorePricingOptions = '{% jslang 'MorePricingOptions' %}';
lang.LessPricingOptions = '{% jslang 'LessPricingOptions' %}';
lang.ConfirmChangeDownloadEdit = '{% jslang 'ConfirmChangeDownloadEdit' %}';
lang.InvalidExpiresAfter = '{% jslang 'InvalidExpiresAfter' %}';
lang.InvalidMaxDownloads = '{% jslang 'InvalidMaxDownloads' %}';
lang.SavingDownload = '{% jslang 'SavingDownload' %}';
lang.UploadFailed2 = '{% jslang 'UploadFailed2' %}';
lang.SelectDownloadFile = '{% jslang 'SelectDownloadFile' %}';
lang.UploadingDownload = '{% jslang 'UploadingDownload' %}';
lang.ConfirmDeleteDownload = '{% jslang 'ConfirmDeleteDownload' %}';
lang.DigitalDownloadDeleted = '{% jslang 'DigitalDownloadDeleted' %}';
lang.NoParent = '{% jslang 'NoParent' %}';
lang.NoCategoryName = '{% jslang 'NoCategoryName' %}';
lang.ProductWillUseVariation = '{% jslang 'ProductWillUseVariation' %}';
lang.ProductWillUseVariationSemi = '{% jslang 'ProductWillUseVariationSemi' %}';
lang.ConfirmRemoveProdField = '{% jslang 'ConfirmRemoveProdField' %}';
lang.DiscountRulesForEachItem = '{% jslang 'DiscountRulesForEachItem' %}';
lang.DiscountRulesOffEachItem = '{% jslang 'DiscountRulesOffEachItem' %}';
lang.DiscountRulesField = '{% jslang 'DiscountRulesField' %}';
lang.Number0 = '{% jslang 'Number0' %}';
lang.Number1 = '{% jslang 'Number1' %}';
lang.Number2 = '{% jslang 'Number2' %}';
lang.Number3 = '{% jslang 'Number3' %}';
lang.Number4 = '{% jslang 'Number4' %}';
lang.Number5 = '{% jslang 'Number5' %}';
lang.Number6 = '{% jslang 'Number6' %}';
lang.Number7 = '{% jslang 'Number7' %}';
lang.Number8 = '{% jslang 'Number8' %}';
lang.Number9 = '{% jslang 'Number9' %}';
lang.VideoLoading = '{% jslang 'VideoLoading' %}';
lang.VideoPleaseEnterSearchTerm = '{% jslang 'VideoPleaseEnterSearchTerm' %}';
lang.ClickHereToAddADescription = '{% jslang 'ClickHereToAddADescription' %}';
lang.ConfirmDeleteProductImage = '{% jslang 'ConfirmDeleteProductImage' %}';
lang.ChooseProductImage = '{% jslang 'ChooseProductImage' %}';
lang.ProductImagesDeleted = '{% jslang 'ProductImagesDeleted' %}';
lang.ProductImagesDeletedErrors = '{% jslang 'ProductImagesDeletedErrors' %}';
lang.ProductImagesDeletedWarnings = '{% jslang 'ProductImagesDeletedWarnings' %}';
lang.ProductImage = '{% jslang 'ProductImage' %}';
lang.ProductImageAddedSuccessfully = '{% jslang 'ProductImageAddedSuccessfully' %}';
lang.ProductImagesAddedSuccessfully = '{% jslang 'ProductImagesAddedSuccessfully' %}';
lang.ProductImageUrlsFailed = '{% jslang 'ProductImageUrlsFailed' %}';
lang.Images = '{% jslang 'Images' %}';
lang.ProductImagesProcessing = '{% jslang 'ProductImagesProcessing' %}';
lang.ProductImagesUploadError = '{% jslang 'ProductImagesUploadError' %}';
lang.ProductImagesTransportError = '{% jslang 'ProductImagesTransportError' %}';
lang.ProductImagesUploadProgressStatus = '{% jslang 'ProductImagesUploadProgressStatus' %}';
lang.ProductImagesUploadProgressFile = '{% jslang 'ProductImagesUploadProgressFile' %}';
lang.ProductImagesSortOrderChanged = '{% jslang 'ProductImagesSortOrderChanged' %}';
lang.ImageFromGalleryViewLarger = '{% jslang 'ImageFromGalleryViewLarger' %}';
lang.ProductImagesNoSourceImageNoThumbnail = '{% jslang 'ProductImagesNoSourceImageNoThumbnail' %}';
lang.ProductImagesNotUploadedDueToErrors = '{% jslang 'ProductImagesNotUploadedDueToErrors' %}';
lang.ProductImagesAnyImageNotListedHere = '{% jslang 'ProductImagesAnyImageNotListedHere' %}';
lang.UploadAnImage = '{% jslang 'UploadAnImage' %}';
lang.ProductImagesNonFlashIntro = '{% jslang 'ProductImagesNonFlashIntro' %}';
lang.ProductImagesUploadImagesElipsis = '{% jslang 'ProductImagesUploadImagesElipsis' %}';
lang.CancelEdit = '{% jslang 'CancelEdit' %}';
lang.ProductImagesNonFlashRemove = '{% jslang 'ProductImagesNonFlashRemove' %}';
lang.ShowErrorMessage = '{% jslang 'ShowErrorMessage' %}';
lang.ProductImagesChooseAnImage = '{% jslang 'ProductImagesChooseAnImage' %}';
lang.PleaseChooseAReleaseDate = '{% jslang 'PleaseChooseAReleaseDate' %}';
lang.PleaseChooseAReleaseDateInTheFuture = '{% jslang 'PleaseChooseAReleaseDateInTheFuture' %}';
lang.ProductMinimumError = '{% jslang 'ProductMinimumError' %}';
lang.ProductMaximumError = '{% jslang 'ProductMaximumError' %}';
lang.ProductMinimumMaximumError = '{% jslang 'ProductMinimumMaximumError' %}';
//]]></script>
<script type="text/javascript" src="script/product.js?{{ JSCacheToken }}"></script>
<script type="text/javascript" src="script/product.youtube.js?{{ JSCacheToken }}"></script>
<script type="text/javascript">//<![CDATA[
$(document).ready(function() {

	$('#frmProduct').bind('submit', function () {
		return ValidateForm(CheckAddProductForm);
	});

	{{ OptionButtons|safe }}

	// Toggle the product type
	var f = g('ProductType_0');
	if(f.checked)
	{
		ToggleType(0);
	}
	else
	{
		ToggleType(1);
	}

	ToggleAllowPurchasing();
	ToggleCallForPricing();

	if(g('prodInvTrack_2').checked) {
		$('#prodOptionsRequired').attr('checked', true);
		$('#prodOptionsRequired').attr('disabled', true);
	}

	$('#prodInvTrack_2').click(function() {
		if(this.checked) {
			$('#prodOptionsRequired').attr('checked', true);
			$('#prodOptionsRequired').attr('disabled', true);
		}
	});

	$('#prodInvTrack_1').click(function() {
		$('#prodOptionsRequired').attr('checked', false);
		$('#prodOptionsRequired').attr('disabled', false);
	});

	$('#prodInvTrack_0').click(function() {
		$('#prodOptionsRequired').attr('checked', false);
		$('#prodOptionsRequired').attr('disabled', false);
	});

	{{ MoreImages|safe }}

	ShowTab({{ CurrentTab|safe }});

	// Are related products set to auto?
	if(shop.config.IsProdRelatedAuto == 'checked="checked"') {
		toggle_related_auto(true);
	}

	youtube.videos = '{{ YouTubeVideos|safe }}';
	youtube.init();

	$('input[type=submit]').attr('disabled', '');

	$('input[name=_prodorderable]').bind('click', function(){
		$('._prodorderable_detail').hide();
		if (this.checked) {
			$('#_prodorderable_' + $(this).val() + '_detail').show();
		}
	});

	$('input[name=_prodorderable]:checked').trigger('click');

	$('#prodreleasedate').datepicker({
		showOn: 'both',
		buttonImage: 'images/calendar.gif',
		buttonImageOnly: true,
		minDate: new Date(),
		firstDay: 1,
		duration: '',
		dateFormat: 'mm/dd/yy'
	});

	$('#prodreleasedate').bind('keydown keyup keypress', function(event){
		switch (event.keyCode) {
			case 8: // backspace
			case 16: // shift
			case 17: // control
			case 18: // alt
			case 35: // end
			case 36: // home
			case 37: // left
			case 38: // up
			case 39: // right
			case 40: // down
			case 46: // delete
				return;
				break;
		}

		if ((event.shiftKey || event.metaKey) && event.keyCode == 88) {
			// cut
			return;
		}

		event.preventDefault();
	});

	$("#OpenGraphUseProductName").change(function() {
		if($(this).is(':checked')) {
			$(this).parent('label').nextAll('.NodeJoin:first').hide();
		}
		else {
			$(this).parent('label').nextAll('.NodeJoin:first').show();
		}
	});

	$("#OpenGraphUseMetaDescription").change(function() {
		if($(this).is(':checked')) {
			$(this).parent('label').nextAll('.NodeJoin:first').hide();
		}
		else {
			$(this).parent('label').nextAll('.NodeJoin:first').show();
		}
	});
});
//]]></script>

<div style="display:none;" id="UseImageFromWebDialog">
	<div class="ModalTitle">{% lang 'UseImageFromWebDialogTitle' %}</div>
	<div class="ModalContent">
		<input type="text" class="Field100pct UseImageFromWebDialogImageUrl" name="imageurl[]" value="http://" /><br />
		<input type="text" class="Field100pct UseImageFromWebDialogImageUrl" name="imageurl[]" value="http://" /><br />
		<input type="text" class="Field100pct UseImageFromWebDialogImageUrl" name="imageurl[]" value="http://" /><br />
		<input type="text" class="Field100pct UseImageFromWebDialogImageUrl" name="imageurl[]" value="http://" /><br />
		<input type="text" class="Field100pct UseImageFromWebDialogImageUrl" name="imageurl[]" value="http://" /><br />
	</div>
	<div class="ModalButtonRow">
		<div class="FloatLeft">
			<img src="images/loading.gif" alt="" style="vertical-align: middle; display: none;" class="LoadingIndicator" />
			<input type="button" class="CloseButton FormButton" value="{% lang 'Close' %}" onclick="$.modal.close();return false;" />
		</div>
		<input type="button" class="Submit" value="{% lang 'UseImages' %}" onclick="ProductImages.useImageFromWebDialogSubmit();return false;" />
	</div>
</div><!-- end #UseImageFromWebDialog --><!-- located here to be outside of posted product info -->

<div id="QuickCategoryCreation" style="display: none;">
	<div class="ModalTitle">{% lang 'CreateACategory' %}</div>
	<div class="ModalContent">
		<table class="Panel" width="100%">
			<tr>
				<td><strong>{% lang 'CatName' %}:</strong></td>
			</tr>
			<tr>
				<td><input id="QuickCatName" type="text" name="catname" value=""  class="Field250" style="width: 100%;" /></td>
			</tr>
		</table>
		<div style="height: 4px; font-size: 1px;"></div>
		<table class="Panel" width="100%">
			<tr>
				<td><strong>{% lang 'CatParentCategory' %}:</strong></td>
			</tr>
			<tr>
				<td>
					<select name="catparentid" size="8" id="QuickCatParent" style="width: 100%">
					</select>
				</td>
			</tr>
		</table>
	</div>
	<div class="ModalButtonRow">
		<div class="FloatLeft">
			<img src="images/loading.gif" alt="" style="vertical-align: middle; display: none;" class="LoadingIndicator" />
			<input type="button" class="CloseButton FormButton" value="{% lang 'Cancel' %}" onclick="$.modal.close();" />
		</div>
		<input type="button" class="Submit" value="{% lang 'Save' %}" onclick="SaveQuickCategory()" />
	</div>
</div>

<div id="AddProductWithEmptyDimensions" style="display: none;">
<div class="ModalTitle">{% lang 'ConfirmProductDimension' %}</div>
	<div class="ModalContent">
		{% lang 'AddProductWithEmptyDimensions' %}<br /><br />
		<input type="checkbox" value="{% lang 'DontShowDimensionsCheck' %}" id="DontShowDimensionsCheck" name="DontShowDimensionsCheck" /> <label for="DontShowDimensionsCheck">{% lang 'DontShowDimensionsAgain' %}</label>
	</div>
	<div class="ModalButtonRow">
		<div class="FloatLeft">
			<input type="button" class="CloseButton FormButton" value="{% lang 'Cancel' %}" onclick="$.modal.close();" />
		</div>
		<input type="button" class="Submit" value="{% lang 'Continue' %}" onclick="CheckedDimensionsContinue()" />
	</div>
</div>