<form enctype="multipart/form-data" action="index.php?ToDo=importProductVariations&Step=2" onsubmit="return ValidateForm(CheckImportVariationsForm)" id="frmImport" method="post">
<div class="BodyContainer">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ImportProductVariationsStep1' %}</h4>
			<p>{% lang 'ImportProductVariationsStep1Desc' %}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
	<br />

	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'UpdateExistingVariations' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="UpdateExisting" value="1" checked="checked"/> {% lang 'YesUpdateExistingVariations' %}</label>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'DefaultForEmptyValues' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="DefaultForEmpty" value="1" /> {% lang 'YesDefaultForEmptyValues' %}</label>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'CreateAllCombinations' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="CreateAllCombos" value="1" /> {% lang 'YesCreateAllCombinations' %}</label>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportFileDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportFile' %}: 
						</label>
						<div class="col-md-10">
							<label>
								<input id="ProductImportUseUpload" type="radio" name="useserver" value="0" checked="checked" onclick="ToggleSource();" />
								{% lang 'ImportFileUpload' %}
								{% lang 'ImportMaxSize' with [
									'maxSize': ImportMaxSize
								]%}
							</label>

							<div id="ProductImportUploadField">
								<input type="file" name="importfile" id="ImportFile" class="Field250" />
							</div>

							<div>
								<label><input id="ProductImportUseServer" type="radio" name="useserver" value="1" onclick="ToggleSource();" /> {% lang 'ImportFileServer' %}</label>
								<img onmouseout="HideHelp('d2');" onmouseover="ShowHelp('d2', '{% lang 'ImportFileServer' %}', '{% lang 'ImportFileServerDesc' %}')" src="images/help.gif" width="24" height="16" border="0">
								<div style="display: none;" id="d2"></div>
							</div>
							<div id="ProductImportServerField" style="display: none;">
								<select name="serverfile" id="ServerFile" class="Field250">
									<option value="">{% lang 'ImportChooseFile' %}</option>
									{{ ServerFiles|safe }}
								</select>
							</div>
							<div id="ProductImportServerNoList" style="display: none; font-style: italic;" class="Field250">
								{% lang 'FieldNoServerFiles' %}
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldSeparator' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldSeparator" id="FieldSeparator" class="Field250" value="{{ FieldSeparator|safe }}" />
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldEnclosure' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldEnclosure" id="FieldEnclosure" class="Field250" value='{{ FieldEnclosure|safe }}' />
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
</form>

	<script type="text/javascript">
	function ConfirmCancel() {
		if(confirm('{% lang 'ConfirmCancelImport' %}'))
			window.location = 'index.php?ToDo=viewProductVariations';
	}

	function CheckImportVariationsForm() {
		var f = document.getElementById('ProductImportUseUpload');
		if(f.checked == true) {
			var f = document.getElementById('ImportFile');
			if(f.value == '') {
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		} else {
			var f = document.getElementById('ServerFile');
			if(f.value < 1) {
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		}

		var f = document.getElementById('FieldSeparator');
		if(f.value == '') {
			alert('{% lang 'NoImportFieldSeparator' %}');
			f.focus();
			return false;
		}

		var f = document.getElementById('FieldEnclosure');
		if(f.value == '') {
			alert('{% lang 'NoImportFieldEnclosure' %}');
			f.focus();
			return false;
		}
		return true;
	}

	function ToggleSource() {
		var file = document.getElementById('ProductImportUseUpload');
		if(file.checked == true) {
			document.getElementById('ProductImportUploadField').style.display = '';
			document.getElementById('ProductImportServerField').style.display = 'none';
			document.getElementById('ProductImportServerNoList').style.display = 'none';
		} else {
			document.getElementById('ProductImportUploadField').style.display = 'none';
			if(document.getElementById('ProductImportServerField').getElementsByTagName('SELECT')[0].options.length == 1) {
				document.getElementById('ProductImportServerNoList').style.display = '';
			} else {
				document.getElementById('ProductImportServerField').style.display = '';
			}
		}
	}
</script>