<form enctype="multipart/form-data" action="index.php?ToDo=importProducts&Step=2" onsubmit="return ValidateForm(CheckImportProductForm)" id="frmImport" method="post">
<div class="BodyContainer">
	<div class="row">
		<div class="col-sm-12">
			<h4 class="page-title">{% lang 'ImportProductsStep1' %}</h4>
			<p>{% lang 'ImportProductsStep1Desc' %}</p>
			{{ Message|safe}}
		</div>
	</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
	<br />
	<div class="row">
		<div class="col-sm-12">
			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportBulkEditCSV' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="BulkEditTemplate" id="BulkEditTemplate" value="1" /> {% lang 'ImportBulkEditCSVYes' %}</label>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportProductsCategory' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="AutoCategory" value="1" onclick="ToggleCategory();" id="AutoCategoryCheck" {{ AutoCategoryChecked|safe }} /> {% lang 'AutoDetectCategories' %}</label>

							<div id="ManualCategory" style="display:none; padding-top: 5px; padding-left: 25px;">
								<div style="display:{{ HideCategorySelect|safe }}">
									<select name="CategoryId" id="CategoryId" class="Field250">
										<option value="">{% lang 'ChooseACategory' %}</option>
										{{ CategoryOptions|safe }}
									</select>
									<img onmouseout="HideHelp('a1');" onmouseover="ShowHelp('a1', '{% lang 'ImportProductsCategory' %}', '{% lang 'ImportProductsCategoryDesc' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display: none;" id="a1"></div>
								</div>

								<div style="display:{{ HideCategoryTextbox|safe }}" id="HideCategoryBox">
									<input type="text" name="CategoryName" id="CategoryName" class="Field250" />
									<img onmouseout="HideHelp('b1');" onmouseover="ShowHelp('b1', '{% lang 'ImportProductsCategory' %}', '{% lang 'ImportProductsCategoryCreateDesc' %}')" src="images/help.gif" width="24" height="16" border="0">
									<div style="display: none;" id="b1"></div>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportOverride' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="OverrideDuplicates" id="Override" value="1" /> {% lang 'YesImportOverride' %}</label>

							<div style="display: none" id="HideOverrideOptions">
								<label><input type="checkbox" name="DeleteImages" value="1" /> {% lang 'DeleteExistingImages' %}</label>
								<br />
								<label><input type="checkbox" name="DeleteDownloads" value="1" /> {% lang 'DeleteExistingDownloads' %}</label>
								<div style="display: none;" id="b1"></div>
							</div>
						</div>
					</div>

					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportIgnoreBlanks' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="IgnoreBlankFields" value="1" checked="checked"/>&nbsp;{% lang 'ImportIgnoreBlankFields' %}<label>
						</div>
					</div>
				</div>
			</div>

			<div class="panel panel-default">
				<div class="panel-heading"> 
					<h3 class="panel-title">{% lang 'ImportDetails' %}</h3> 
				</div> 

				<div class="panel-body">
					<div class="form-group row">
						<label class="col-md-2 control-label">
							{% lang 'ImportFile' %}: 
						</label>
						<div class="col-md-10">
							<label>
								<input id="ProductImportUseUpload" type="radio" name="useserver" value="0" checked="checked" onclick="ToggleSource();" />
								{% lang 'ImportFileUpload' %}
								{% lang 'ImportMaxSize' with [
									'maxSize': ImportMaxSize
								]%}
							</label>

							<div id="ProductImportUploadField" style="margin-left: 25px;">
								<input type="file" name="importfile" id="ImportFile" class="Field250" />
							</div>

							<div>
								<label><input id="ProductImportUseServer" type="radio" name="useserver" value="1" onclick="ToggleSource();" /> {% lang 'ImportFileServer' %}</label>
								<img onmouseout="HideHelp('d2');" onmouseover="ShowHelp('d2', '{% lang 'ImportFileServer' %}', '{% lang 'ImportFileServerDesc' %}')" src="images/help.gif" width="24" height="16" border="0">
								<div style="display: none;" id="d2"></div>
							</div>
							<div id="ProductImportServerField" style=" display: none;">
								<select name="serverfile" id="ServerFile" class="Field250">
									<option value="">{% lang 'ImportChooseFile' %}</option>
									{{ ServerFiles|safe }}
								</select>
							</div>
							<div id="ProductImportServerNoList" style="display: none; font-style: italic;" class="Field250">
								{% lang 'FieldNoServerFiles' %}
							</div>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportContainsHeaders' %}: 
						</label>
						<div class="col-md-10">
							<label><input type="checkbox" name="Headers" id="Headers" value="1" /> {% lang 'YesImportContainsHeaders' %}</label>
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldSeparator' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldSeparator" id="FieldSeparator" class="Field250" value="{{ FieldSeparator|safe }}" />
						</div>
					</div>

					<div class="form-group row BulkImportRowHide">
						<label class="col-md-2 control-label">
							{% lang 'ImportFieldEnclosure' %}:
						</label>
						<div class="col-md-10">
							<input type="text" name="FieldEnclosure" id="FieldEnclosure" class="Field250" value='{{ FieldEnclosure|safe }}' />
						</div>
					</div>
				</div>
			</div>
		</div>

	<div class="row">
		<div class="col-sm-12">
			<input type="reset" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()" />
			<input type="submit" value="{% lang 'Next' %}" class="FormButton btn btn-success" />
		</div>
	</div>
</form>

<script type="text/javascript">
	function ConfirmCancel()
	{
		if(confirm('{% lang 'ConfirmCancelImport' %}'))
			window.location = 'index.php?ToDo=manageProducts';
	}

	function ToggleCategory()
	{
		var e = document.getElementById('AutoCategoryCheck');
		if(e.checked == true)
		{
			document.getElementById('ManualCategory').style.display = 'none';
		}
		else
		{
			document.getElementById('ManualCategory').style.display = '';
		}
	}
	ToggleCategory();

	function CheckImportProductForm()
	{

		var f= document.getElementById('AutoCategoryCheck');
		if(f.checked != true)
		{
			if(document.getElementById('HideCategoryBox').style.display == "none")
			{
				var f = document.getElementById('CategoryId');
				if(f.selectedIndex < 1)
				{
					alert('{% lang 'NoSelectedCategoryName' %}');
					f.focus();
					return false;
				}
			}
			else
			{
				var f = document.getElementById('CategoryName');
				if(f.value == '')
				{
					alert('{% lang 'NoCategoryName' %}');
					f.focus();
					return false;
				}
			}
		}
		var f = document.getElementById('ProductImportUseUpload');
		if(f.checked == true)
		{
			var f = document.getElementById('ImportFile');
			if(f.value == '')
			{
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		}
		else
		{
			var f = document.getElementById('ServerFile');
			if(f.value < 1)
			{
				alert('{% lang 'NoImportFile' %}');
				f.focus();
				return false;
			}
		}

		var f = document.getElementById('FieldSeparator');
		if(f.value == '')
		{
			alert('{% lang 'NoImportFieldSeparator' %}');
			f.focus();
			return false;
		}

		var f = document.getElementById('FieldEnclosure');
		if(f.value == '')
		{
			alert('{% lang 'NoImportFieldEnclosure' %}');
			f.focus();
			return false;
		}
		return true;
	}

	function ToggleSource()
	{
		var file = document.getElementById('ProductImportUseUpload');
		if(file.checked == true)
		{
			document.getElementById('ProductImportUploadField').style.display = '';
			document.getElementById('ProductImportServerField').style.display = 'none';
			document.getElementById('ProductImportServerNoList').style.display = 'none';
		}
		else
		{
			document.getElementById('ProductImportUploadField').style.display = 'none';
			if(document.getElementById('ProductImportServerField').getElementsByTagName('SELECT')[0].options.length == 1)
			{
				document.getElementById('ProductImportServerNoList').style.display = '';
			}
			else
			{
				document.getElementById('ProductImportServerField').style.display = '';
			}
		}
	}

	$("#BulkEditTemplate").change(function() {
		var disabled = '';
		if ($(this).attr('checked')) {
			disabled = 'disabled';
			$("#AutoCategoryCheck").attr('checked', true);
			ToggleCategory();
		}

		$("#Headers").attr({
			'checked': $(this).attr('checked'),
			'disabled': disabled

		});

		$("#Override").attr({
			'checked': $(this).attr('checked'),
			'disabled': disabled
		});

		$("#Override").change();

		$(".BulkImportRowHide").toggle();
	});

	$("#Override").change(function() {
		if ($(this).attr('checked')) {
			$("#HideOverrideOptions").show();
		}
		else {
			$("#HideOverrideOptions").hide();
		}
	});
</script>
