<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{% lang 'View' %}: <a href="#" style="color:#005FA3" id="ViewsMenuButton" class="PopDownMenu">{{ ViewName|safe }} <img width="8" height="5" src="images/arrow_blue.gif" border="0" /></a></h4>
		<div id="ViewsMenu" class="DropDownMenu DropShadow" style="display: none; width:200px">
			<ul>
				{{ CustomSearchOptions|safe }}
			</ul>
			<hr />
			<ul>
				<li><a href="index.php?ToDo=createGiftCertificateView" style="background-image:url('images/view_add.gif'); background-repeat:no-repeat; background-position:5px 5px; padding-left:28px">{% lang 'CreateANewView' %}</a></li>
				<li style="display:{{ HideDeleteViewLink|safe }}"><a onclick="$('#ViewsMenu').hide(); ConfirmDeleteCustomSearch('{{ CustomSearchId|safe }}')" href="javascript:void(0)" style="background-image:url('images/view_del.gif'); background-repeat:no-repeat; background-position:5px 5px; padding-left:28px">{% lang 'DeleteThisView' %}</a></li>
			</ul>
		</div>
		<p>{% lang 'ManageGiftCertificatesIntro' %}</p>
		<div id="DiscountStatus">{{ Message|safe }}</div>
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="button" name="IndexDeleteButton" value="{% lang 'DeleteSelected' %}" id="IndexDeleteButton" class="btn btn-danger" onclick="ConfirmDeleteSelected()" {{ DisableDelete|safe }} />
	</div>
</div>
<br />

<div class="panel panel-color panel-primary" style="display: {{ DisplayGrid|safe }}">
	<div class="panel-body pn">
		<div class="table-responsive">
			<form name="frmGiftCertificates1" id="frmGiftCertificates1" method="post" action="index.php?ToDo=deleteGiftCertificates">
				<div class="GridContainer">
					{{ GiftCertificatesDataGrid|safe }}
				</div>
			</form>
		</div>
	</div>
</div>

<script type="text/javascript">
	function ConfirmDeleteSelected() {
		if($('.DeleteCheck:checked').length == 0) {
			alert('{% lang 'ChooseGiftCertificatesToDelete' %}');
		} else {
			if(confirm('{% lang 'ConfirmDeleteGiftCertificates' %}')) {
				$('#frmGiftCertificates1').submit();
			}
		}
	}

	function UpdateGiftCertificateStatus(giftcertid, statusid, statustext) {
		$('#ajax_status_'+giftcertid).show();
		$.ajax({
			url: 'remote.php?w=updateGiftCertificateStatus&giftCertificateId='+giftcertid+'&status='+statusid,
			success: function(response) {
				$('#ajax_status_'+giftcertid).hide();
				if(response == 0) {
					alert('{% lang 'FailedUpdateGiftCertificateStatus' %}');
				}
			},
			error: function() {
				alert('{% lang 'FailedUpdateGiftCertificateStatus' %}');
			}
		});
	}

	function ConfirmDeleteCustomSearch(id) {
		if(confirm('{% lang 'ConfirmDeleteCustomSearch' %}')) {
			document.location.href = "index.php?ToDo=deleteCustomGiftCertificateSearch&searchId="+search_id;
		}
	}

	function QuickGiftCertificateView(id) {
		var tr = document.getElementById("tr"+id);
		var trQ = document.getElementById("trQ"+id);
		var tdQ = document.getElementById("tdQ"+id);
		var img = document.getElementById("expand"+id);

		if(img.src.indexOf("plus.gif") > -1) {
			img.src = "images/minus.gif";

			for(i = 0; i < tr.childNodes.length; i++) {
				if(tr.childNodes[i].style != null)
					tr.childNodes[i].style.backgroundColor = "#dbf3d1";
			}

			$(trQ).find('.QuickView').load('remote.php?w=giftCertificateQuickView&giftCertificateId='+id, {}, function() {
				trQ.style.display = "";
			});
		} else {
			img.src = "images/plus.gif";

			for(i = 0; i < tr.childNodes.length; i++) {
				if(tr.childNodes[i].style != null)
					tr.childNodes[i].style.backgroundColor = "";
			}
			trQ.style.display = "none";
		}
	}
</script>