<form enctype="multipart/form-data" action="index.php?ToDo={{ FormAction|safe }}" onSubmit="return ValidateForm(CheckForm)" name="frmAddBrand" method="post">
<input type="hidden" name="brandId" value="{{ BrandId|safe }}">
<input type="hidden" name="oldBrandName" value="{{ BrandName|safe }}">

<div class="row">
	<div class="col-sm-12">
		<h4 class="page-title">{{ BrandTitle|safe }}</h4>
		<p>{{ BrandIntro|safe }}</p>
		{{ Message|safe }}
	</div>
</div>

<div class="row">
	<div class="col-sm-12">
		<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
		<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
	</div>
</div>
<br />

<div class="panel panel-default form-horizontal">
	<div class="panel-heading"> 
		<h3 class="panel-title">{% lang 'BrandDetails' %}</h3> 
	</div> 

	<div class="panel-body">
		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'BrandName' %}</label>
			<div class="col-md-10">
				<input type="text" name="brandName" id="brandName" class="form-control" value="{{ BrandName|safe }}">
			</div>
		</div>

		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'PageTitle' %}</label>
			<div class="col-md-10">
				<input type="text" id="brandPageTitle" name="brandPageTitle" class="form-control" value="{{ BrandPageTitle|safe }}" />
			</div>
		</div>

		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'MetaKeywords' %}</label>
			<div class="col-md-10">
				<input type="text" id="brandMetaKeywords" name="brandMetaKeywords" class="form-control" value="{{ BrandMetaKeywords|safe }}" />
			</div>
		</div>

		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'MetaDescription' %}</label>
			<div class="col-md-10">
				<input type="text" id="brandMetaKeywords" name="brandMetaKeywords" class="form-control" value="{{ BrandMetaKeywords|safe }}" />
			</div>
		</div>

		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'SearchKeywords' %}</label>
			<div class="col-md-10">
				<input type="text" id="brandSearchKeywords" name="brandSearchKeywords" class="form-control" value="{{ BrandSearchKeywords|safe }}">
			</div>
		</div>

		<div class="form-group">
			<label class="col-md-2 control-label">{% lang 'BrandImage' %}</label>
			<div class="col-md-10">
				<input type="file" id="brandimagefile" name="brandimagefile" class="form-control" />
				{{ BrandImageMessage|safe }}
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-sm-12">
		<input type="submit" name="SubmitButton1" value="{% lang 'Save' %}" class="FormButton btn btn-primary">
		<input type="button" name="CancelButton1" value="{% lang 'Cancel' %}" class="FormButton btn btn-default" onclick="ConfirmCancel()"></p>
	</div>
</div>
</form>

<script type="text/javascript">

	function CheckForm() {
		var brands = document.getElementById("brandName");
		var bimg = document.getElementById("brandimagefile");

		if(brands.value == "") {
			alert("{% lang 'EnterBrand' %}");
			brands.focus();
			return false;
		}

		if(bimg.value != "") {
			// Make sure it has a valid extension
			img = bimg.value.split(".");
			ext = img[img.length-1].toLowerCase();

			if(ext != "jpg" && ext != "png" && ext != "gif") {
				alert("{% lang 'ChooseValidImage' %}");
				bimg.focus();
				bimg.select();
				return false;
			}
		}

		return true;
	}

	function ConfirmCancel()
	{
		if(confirm('{{ CancelMessage|safe }}'))
			document.location.href='index.php?ToDo=viewBrands';
		else
			return false;
	}

</script>
